/*
 * Decompiled with CFR 0.152.
 */
package com.supermap;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class Enum {
    private final int m_value;
    private final int m_ugcValue;
    private static boolean m_isCustom;
    protected static HashMap<Class<?>, ArrayList<Enum>> m_hashMap;
    protected static HashMap<Class<?>, Field[]> m_allEnumsFields;

    static {
        m_hashMap = new HashMap();
        m_allEnumsFields = new HashMap();
    }

    public static final String[] getNames(Class type) {
        if (type == null) {
            return new String[0];
        }
        if (!Enum.isValidEnumClass(type)) {
            return new String[0];
        }
        ArrayList names = new ArrayList();
        Enum.getEnumNameValueAndEntry(type, names, null, null);
        String[] nameArr = new String[names.size()];
        names.toArray(nameArr);
        return nameArr;
    }

    public static int[] getValues(Class type) {
        if (type == null) {
            return new int[0];
        }
        if (!Enum.isValidEnumClass(type)) {
            return new int[0];
        }
        ArrayList values = new ArrayList();
        Enum.getEnumNameValueAndEntry(type, null, values, null);
        int[] valueArr = new int[values.size()];
        int i = 0;
        while (i < values.size()) {
            valueArr[i] = Integer.parseInt(values.get(i).toString());
            ++i;
        }
        return valueArr;
    }

    public static int[] getPredefineValues(Class type) {
        if (type == null) {
            return new int[0];
        }
        if (!Enum.isValidEnumClass(type)) {
            return new int[0];
        }
        ArrayList values = new ArrayList();
        Enum.getEnumNameValueAndEntry(type, null, values, null, true);
        int[] valueArr = new int[values.size()];
        int i = 0;
        while (i < values.size()) {
            valueArr[i] = Integer.parseInt(values.get(i).toString());
            ++i;
        }
        return valueArr;
    }

    public static Enum[] getEnums(Class type) {
        if (type == null) {
            return new Enum[0];
        }
        if (!Enum.isValidEnumClass(type)) {
            return new Enum[0];
        }
        ArrayList entries = new ArrayList();
        Enum.getEnumNameValueAndEntry(type, null, null, entries);
        Enum[] enums = new Enum[entries.size()];
        entries.toArray(enums);
        return enums;
    }

    public static String getNameByValue(Class type, int value) {
        ArrayList names = new ArrayList();
        ArrayList values = new ArrayList();
        Enum.getEnumNameValueAndEntry(type, names, values, null);
        Integer valueObject = value;
        if (!values.contains(valueObject)) {
            String message = "value:" + value + "undefind";
            throw new RuntimeException(message);
        }
        int index = values.indexOf(valueObject);
        return (String)names.get(index);
    }

    public static int getValueByName(Class type, String name) {
        ArrayList names = new ArrayList();
        ArrayList values = new ArrayList();
        Enum.getEnumNameValueAndEntry(type, names, values, null);
        if (!names.contains(name)) {
            String message = "name:" + name + "undefind";
            throw new RuntimeException(message);
        }
        int index = names.indexOf(name);
        return Integer.parseInt(values.get(index).toString());
    }

    public static Enum parse(Class type, int value) {
        ArrayList values = new ArrayList();
        ArrayList entries = new ArrayList();
        Enum.getEnumNameValueAndEntry(type, null, values, entries);
        Integer valueObject = value;
        if (!values.contains(valueObject)) {
            String message = "value:" + value + "undefind";
            throw new RuntimeException(message);
        }
        int index = values.indexOf(valueObject);
        return (Enum)entries.get(index);
    }

    public static Enum parse(Class type, String name) {
        if (type == null || name == null) {
            return null;
        }
        ArrayList names = new ArrayList();
        ArrayList entries = new ArrayList();
        Enum.getEnumNameValueAndEntry(type, names, null, entries);
        if (!names.contains(name)) {
            String message = "name:" + name + "undefind";
            throw new RuntimeException(message);
        }
        int index = names.indexOf(name);
        return (Enum)entries.get(index);
    }

    public static boolean isDefined(Class type, int value) {
        ArrayList values = new ArrayList();
        Enum.getEnumNameValueAndEntry(type, null, values, null);
        Integer valueObject = value;
        return values.contains(valueObject);
    }

    public static boolean isDefined(Class type, String name) {
        ArrayList names = new ArrayList();
        Enum.getEnumNameValueAndEntry(type, names, null, null);
        return names.contains(name);
    }

    protected Enum(int value, int ugcValue) {
        this.m_value = value;
        this.m_ugcValue = ugcValue;
    }

    protected static final int internalGetUGCValue(Enum e) {
        return e.getUGCValue();
    }

    protected static final Enum internalParseUGCValue(Class type, int ugcValue) {
        return Enum.parseUGCValue(type, ugcValue);
    }

    static final Enum parseUGCValue(Class type, int ugcValue) {
        ArrayList entries = new ArrayList();
        ArrayList values = new ArrayList();
        Enum.getEnumNameValueAndEntry(type, null, values, entries);
        Integer value = ugcValue;
        if (!values.contains(value)) {
            String message = "value:" + value + "undefind";
            throw new RuntimeException(message);
        }
        int index = values.indexOf(value);
        return (Enum)entries.get(index);
    }

    private static final boolean isValidEnumField(Field field) {
        if (field == null) {
            return false;
        }
        Class<?> type = field.getDeclaringClass();
        if (!field.getType().equals(type)) {
            return false;
        }
        int moidifiers = field.getModifiers();
        return Modifier.isPublic(moidifiers) && Modifier.isStatic(moidifiers) && Modifier.isFinal(moidifiers);
    }

    private static void getEnumNameValueAndEntry(Class type, ArrayList names, ArrayList values, ArrayList entries) {
        Enum.getEnumNameValueAndEntry(type, names, values, entries, false);
    }

    private static void getEnumNameValueAndEntry(Class type, ArrayList names, ArrayList values, ArrayList entries, boolean onlyPredefine) {
        if (type == null) {
            return;
        }
        if (names == null && values == null && entries == null) {
            return;
        }
        Field[] fields = null;
        if (m_allEnumsFields.containsKey(type)) {
            fields = m_allEnumsFields.get(type);
        } else {
            fields = type.getFields();
            m_allEnumsFields.put(type, fields);
        }
        if (fields == null || fields.length == 0) {
            return;
        }
        int len = fields.length;
        int i = 0;
        while (i < len) {
            block20: {
                Field field = fields[i];
                if (Enum.isValidEnumField(field)) {
                    Enum e = null;
                    try {
                        e = (Enum)field.get(null);
                    }
                    catch (IllegalAccessException ex) {
                        break block20;
                    }
                    catch (IllegalArgumentException ex) {
                        break block20;
                    }
                    if (e != null) {
                        if (names != null) {
                            names.add(field.getName());
                        }
                        if (values != null) {
                            Integer value = e.value();
                            values.add(value);
                        }
                        if (entries != null) {
                            entries.add(e);
                        }
                    }
                }
            }
            ++i;
        }
        if (!onlyPredefine && m_isCustom) {
            for (Map.Entry<Class<?>, ArrayList<Enum>> e : m_hashMap.entrySet()) {
                Class<?> tempClass = e.getKey();
                if (!tempClass.getName().equals(type.getName())) continue;
                ArrayList<Enum> customEnums = e.getValue();
                int j = 0;
                while (j < customEnums.size()) {
                    Enum customEnum = customEnums.get(j);
                    if (names != null) {
                        names.add(String.valueOf(customEnum.value()));
                    }
                    if (values != null) {
                        values.add(customEnum.value());
                    }
                    if (entries != null) {
                        entries.add(customEnum);
                    }
                    ++j;
                }
                break block4;
            }
        }
    }

    private static boolean isValidEnumClass(Class type) {
        if (type == null) {
            return false;
        }
        return type.getSuperclass().equals(Enum.class);
    }

    public final String name() {
        return Enum.getNameByValue(this.getClass(), this.value());
    }

    public final int value() {
        return this.m_value;
    }

    public String toString() {
        return String.valueOf(this.name());
    }

    public final boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        Enum eOther = (Enum)other;
        return this.value() == eOther.value();
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }

    final int getUGCValue() {
        return this.m_ugcValue;
    }

    protected void setCustom(boolean value) {
        m_isCustom = value;
    }
}

