/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.ParticleSystemNative;
import com.supermap.data.Point3D;
import java.awt.Color;

public class ParticleSystem
extends InternalHandleDisposable {
    private ParticleSystem() {
        long l = ParticleSystemNative.jni_New();
        this.setHandle(l, true);
    }

    private ParticleSystem(ParticleSystem particleSystem) {
        this(particleSystem, true);
    }

    protected void clearHandle() {
        this.setHandle(0L);
    }

    protected ParticleSystem(ParticleSystem particleSystem, boolean bl) {
        if (particleSystem == null) {
            String string = InternalResource.loadString("Material", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (particleSystem.getHandle() == 0L) {
            String string = InternalResource.loadString("Material", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ParticleSystemNative.jni_Clone(particleSystem.getHandle());
        this.setHandle(l, bl);
        InternalHandleDisposable.makeSureNativeObjectLive(particleSystem);
    }

    ParticleSystem(long l) {
        this.setHandle(l, false);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ParticleSystemNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public Point3D getLocalCenterPos() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLocalCenterPos", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        ParticleSystemNative.jni_GetLocalCenterPos(this.getHandle(), dArray);
        return new Point3D(dArray[0], dArray[1], dArray[2]);
    }

    public void setLocalCenterPos(Point3D point3D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLocalCenterPos", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        ParticleSystemNative.jni_SetLocalCenterPos(this.getHandle(), point3D.getX(), point3D.getY(), point3D.getZ());
    }

    public float getParticleWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getParticleWidth", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ParticleSystemNative.jni_GetParticleWidth(this.getHandle());
    }

    public void setParticleWidth(float f) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setParticleWidth", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        ParticleSystemNative.jni_SetParticleWidth(this.getHandle(), f);
    }

    public float getParticleHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getParticleHeight", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ParticleSystemNative.jni_GetParticleHeight(this.getHandle());
    }

    public void setParticleHeight(float f) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setParticleHeight", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        ParticleSystemNative.jni_SetParticleHeight(this.getHandle(), f);
    }

    public int getParticleLifeTime() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getParticleLifeTime", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ParticleSystemNative.jni_GetParticleLifeTime(this.getHandle());
    }

    public void setParticleLifeTime(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setParticleLifeTime", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        ParticleSystemNative.jni_SetParticleLifeTime(this.getHandle(), n);
    }

    public int getParticleCountPerSecond() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getParticleLifeTime", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ParticleSystemNative.jni_GetParticleCountPerSecond(this.getHandle());
    }

    public void setParticleCountPerSecond(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setParticleLifeTime", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        ParticleSystemNative.jni_SetParticleCountPerSecond(this.getHandle(), n);
    }

    public Color getColorRangeStart() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColorRangeStart", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(ParticleSystemNative.jni_GetColorRangeStart(this.getHandle()), true);
        return color;
    }

    public void setColorRangeStart(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setColorRangeStart", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (color == null) {
            String string = InternalResource.loadString("setColorRangeStart", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        ParticleSystemNative.jni_SetColorRangeStart(this.getHandle(), color.getRGB());
    }

    public Color getColorRangeEnd() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColorRangeEnd", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(ParticleSystemNative.jni_GetColorRangeEnd(this.getHandle()), true);
        return color;
    }

    public void setColorRangeEnd(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setColorRangeEnd", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (color == null) {
            String string = InternalResource.loadString("setColorRangeEnd", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        ParticleSystemNative.jni_SetColorRangeEnd(this.getHandle(), color.getRGB());
    }

    public String getTexturePath() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTexturePath", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ParticleSystemNative.jni_GetTexturePath(this.getHandle());
    }

    public void setTexturePath(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setTexturePath", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            String string3 = InternalResource.loadString("setTexturePath", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        ParticleSystemNative.jni_SetTexturePath(this.getHandle(), string);
    }

    public String getColorRangeImagePath() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColorRangeImagePath", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ParticleSystemNative.jni_GetColorRangeImagePath(this.getHandle());
    }

    public void setColorRangeImagePath(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setColorRangeImagePath", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            String string3 = InternalResource.loadString("setColorRangeImagePath", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        ParticleSystemNative.jni_SetColorRangeImagePath(this.getHandle(), string);
    }
}

