/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.AnalystType;
import com.supermap.analyst.networkanalyst.InternalHandleDisposable;
import com.supermap.analyst.networkanalyst.RouteType;
import com.supermap.analyst.networkanalyst.StopType;
import com.supermap.analyst.networkanalyst.TransportationAnalystParameterNative;
import com.supermap.analyst.networkanalyst.VehicleType;
import com.supermap.data.Point2Ds;

public class VRPAnalystParameter
extends InternalHandleDisposable {
    private String _$14 = "";
    private int[] _$13 = null;
    private int[] _$12 = null;
    private Point2Ds _$11 = null;
    private String _$10 = "";
    private boolean _$9 = false;
    private boolean _$8 = false;
    private boolean _$7 = false;
    private boolean _$6 = false;
    private boolean _$5 = false;
    private StopType _$4 = StopType.NONE;
    private AnalystType _$3 = AnalystType.LEASTCOST;
    private VehicleType _$2 = VehicleType.TYPE0;
    private RouteType _$1 = RouteType.ROUNDROUTE;

    public VRPAnalystParameter() {
        long l = TransportationAnalystParameterNative.jni_New();
        this.setHandle(l, true);
        this.reset();
    }

    void reset() {
        long l = super.getHandle();
        if (l != 0L) {
            TransportationAnalystParameterNative.jni_Reset(l);
        }
    }

    public VRPAnalystParameter(VRPAnalystParameter vRPAnalystParameter) {
        long l = TransportationAnalystParameterNative.jni_New();
        this.setHandle(l, true);
        this.reset();
        this.copyFrom(vRPAnalystParameter);
    }

    void copyFrom(VRPAnalystParameter vRPAnalystParameter) {
        if (vRPAnalystParameter != null) {
            this.setWeightName(vRPAnalystParameter.getWeightName());
            this.setBarrierNodes(vRPAnalystParameter.getBarrierNodes());
            this.setBarrierEdges(vRPAnalystParameter.getBarrierEdges());
            this.setBarrierPoints(vRPAnalystParameter.getBarrierPoints());
            this.setTurnWeightField(vRPAnalystParameter.getTurnWeightField());
            this.setNodesReturn(vRPAnalystParameter.isNodesReturn());
            this.setEdgesReturn(vRPAnalystParameter.isEdgesReturn());
            this.setPathGuidesReturn(vRPAnalystParameter.isPathGuidesReturn());
            this.setRoutesReturn(vRPAnalystParameter.isRoutesReturn());
            this.setStopIndexesReturn(vRPAnalystParameter.isStopIndexesReturn());
            this.setStopType(vRPAnalystParameter.getStopType());
            this.setAnalystType(vRPAnalystParameter.getAnalystType());
            this.setVehicleType(vRPAnalystParameter.getVehicleType());
            this.setRouteType(vRPAnalystParameter.getRouteType());
        }
    }

    protected long getHandle() {
        long l = super.getHandle();
        if (l != 0L) {
            TransportationAnalystParameterNative.jni_SetIsRoutesReturn(l, this._$9);
            TransportationAnalystParameterNative.jni_SetIsNodesReturn(l, this._$8);
            TransportationAnalystParameterNative.jni_SetIsEdgesReturn(l, this._$7);
            TransportationAnalystParameterNative.jni_SetIsPathGuidesReturn(l, this._$6);
            TransportationAnalystParameterNative.jni_SetIsStopsReturn(l, this._$5);
            TransportationAnalystParameterNative.jni_SetWeightName(l, this._$14);
            if (this._$13 != null) {
                TransportationAnalystParameterNative.jni_SetBarrierNodes(l, this._$13);
            } else {
                TransportationAnalystParameterNative.jni_SetBarrierNodes(l, new int[0]);
            }
            if (this._$12 != null) {
                TransportationAnalystParameterNative.jni_SetBarrierEdges(l, this._$12);
            } else {
                TransportationAnalystParameterNative.jni_SetBarrierEdges(l, new int[0]);
            }
            if (this._$11 != null && this._$11.getCount() != 0) {
                int n = this._$11.getCount();
                double[] dArray = new double[n];
                double[] dArray2 = new double[n];
                for (int i = 0; i < n; ++i) {
                    dArray[i] = this._$11.getItem(i).getX();
                    dArray2[i] = this._$11.getItem(i).getY();
                }
                TransportationAnalystParameterNative.jni_SetBarrierPoints(l, dArray, dArray2);
            }
            TransportationAnalystParameterNative.jni_SetTurnWeightField(l, this._$10);
        }
        return l;
    }

    public void dispose() {
        if (super.getHandle() != 0L) {
            TransportationAnalystParameterNative.jni_Delete(super.getHandle());
            this.setHandle(0L);
        }
    }

    public boolean isRoutesReturn() {
        return this._$9;
    }

    public void setRoutesReturn(boolean bl) {
        this._$9 = bl;
    }

    public boolean isNodesReturn() {
        return this._$8;
    }

    public void setNodesReturn(boolean bl) {
        this._$8 = bl;
    }

    public boolean isEdgesReturn() {
        return this._$7;
    }

    public void setEdgesReturn(boolean bl) {
        this._$7 = bl;
    }

    public boolean isPathGuidesReturn() {
        return this._$6;
    }

    public void setPathGuidesReturn(boolean bl) {
        this._$6 = bl;
    }

    public boolean isStopIndexesReturn() {
        return this._$5;
    }

    public void setStopIndexesReturn(boolean bl) {
        this._$5 = bl;
    }

    public String getWeightName() {
        return this._$14;
    }

    public void setWeightName(String string) {
        this._$14 = string;
    }

    public int[] getBarrierNodes() {
        if (this._$13 != null) {
            return this._$13;
        }
        return null;
    }

    public void setBarrierNodes(int[] nArray) {
        if (nArray == null) {
            this._$13 = null;
        } else {
            int n = nArray.length;
            this._$13 = new int[n];
            for (int i = 0; i < n; ++i) {
                this._$13[i] = nArray[i];
            }
        }
    }

    public int[] getBarrierEdges() {
        if (this._$12 != null) {
            return (int[])this._$12.clone();
        }
        return null;
    }

    public Point2Ds getBarrierPoints() {
        if (this._$11 != null) {
            return this._$11.clone();
        }
        return null;
    }

    public void setBarrierPoints(Point2Ds point2Ds) {
        if (point2Ds == null) {
            this._$11 = null;
        } else {
            if (this._$11 == null) {
                this._$11 = new Point2Ds();
            }
            this._$11.clear();
            this._$11.addRange(point2Ds.toArray());
        }
    }

    public void setBarrierEdges(int[] nArray) {
        if (nArray == null) {
            this._$12 = null;
        } else {
            int n = nArray.length;
            this._$12 = new int[n];
            for (int i = 0; i < n; ++i) {
                this._$12[i] = nArray[i];
            }
        }
    }

    public String getTurnWeightField() {
        return this._$10;
    }

    public void setTurnWeightField(String string) {
        this._$10 = string;
    }

    protected StopType getStopType() {
        return this._$4;
    }

    protected void setStopType(StopType stopType) {
        this._$4 = stopType;
    }

    public AnalystType getAnalystType() {
        return this._$3;
    }

    public void setAnalystType(AnalystType analystType) {
        this._$3 = analystType;
    }

    protected VehicleType getVehicleType() {
        return this._$2;
    }

    protected void setVehicleType(VehicleType vehicleType) {
        this._$2 = vehicleType;
    }

    protected RouteType getRouteType() {
        return this._$1;
    }

    protected void setRouteType(RouteType routeType) {
        this._$1 = routeType;
    }
}

