/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;
import org.springframework.scheduling.config.CronTask;
import org.springframework.scheduling.config.IntervalTask;
import org.springframework.scheduling.config.TriggerTask;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class ScheduledTaskRegistrar
implements InitializingBean,
DisposableBean {
    private TaskScheduler taskScheduler;
    private ScheduledExecutorService localExecutor;
    private List<TriggerTask> triggerTasks;
    private List<CronTask> cronTasks;
    private List<IntervalTask> fixedRateTasks;
    private List<IntervalTask> fixedDelayTasks;
    private final Set<ScheduledFuture<?>> scheduledFutures = new LinkedHashSet();

    public void setTaskScheduler(TaskScheduler taskScheduler) {
        Assert.notNull((Object)taskScheduler, (String)"TaskScheduler must not be null");
        this.taskScheduler = taskScheduler;
    }

    public void setScheduler(Object scheduler) {
        Assert.notNull((Object)scheduler, (String)"Scheduler object must not be null");
        if (scheduler instanceof TaskScheduler) {
            this.taskScheduler = (TaskScheduler)scheduler;
        } else if (scheduler instanceof ScheduledExecutorService) {
            this.taskScheduler = new ConcurrentTaskScheduler((ScheduledExecutorService)scheduler);
        } else {
            throw new IllegalArgumentException("Unsupported scheduler type: " + scheduler.getClass());
        }
    }

    public TaskScheduler getScheduler() {
        return this.taskScheduler;
    }

    public void setTriggerTasks(Map<Runnable, Trigger> triggerTasks) {
        this.triggerTasks = new ArrayList<TriggerTask>();
        for (Map.Entry<Runnable, Trigger> task : triggerTasks.entrySet()) {
            this.triggerTasks.add(new TriggerTask(task.getKey(), task.getValue()));
        }
    }

    public void setTriggerTasksList(List<TriggerTask> triggerTasks) {
        this.triggerTasks = triggerTasks;
    }

    public List<TriggerTask> getTriggerTaskList() {
        return Collections.unmodifiableList(this.triggerTasks);
    }

    public void setCronTasks(Map<Runnable, String> cronTasks) {
        this.cronTasks = new ArrayList<CronTask>();
        for (Map.Entry<Runnable, String> task : cronTasks.entrySet()) {
            this.addCronTask(task.getKey(), task.getValue());
        }
    }

    public void setCronTasksList(List<CronTask> cronTasks) {
        this.cronTasks = cronTasks;
    }

    public List<CronTask> getCronTaskList() {
        return Collections.unmodifiableList(this.cronTasks);
    }

    public void setFixedRateTasks(Map<Runnable, Long> fixedRateTasks) {
        this.fixedRateTasks = new ArrayList<IntervalTask>();
        for (Map.Entry<Runnable, Long> task : fixedRateTasks.entrySet()) {
            this.addFixedRateTask(task.getKey(), task.getValue());
        }
    }

    public void setFixedRateTasksList(List<IntervalTask> fixedRateTasks) {
        this.fixedRateTasks = fixedRateTasks;
    }

    public List<IntervalTask> getFixedRateTaskList() {
        return Collections.unmodifiableList(this.fixedRateTasks);
    }

    public void setFixedDelayTasks(Map<Runnable, Long> fixedDelayTasks) {
        this.fixedDelayTasks = new ArrayList<IntervalTask>();
        for (Map.Entry<Runnable, Long> task : fixedDelayTasks.entrySet()) {
            this.addFixedDelayTask(task.getKey(), task.getValue());
        }
    }

    public void setFixedDelayTasksList(List<IntervalTask> fixedDelayTasks) {
        this.fixedDelayTasks = fixedDelayTasks;
    }

    public List<IntervalTask> getFixedDelayTaskList() {
        return Collections.unmodifiableList(this.fixedDelayTasks);
    }

    public void addTriggerTask(Runnable task, Trigger trigger) {
        this.addTriggerTask(new TriggerTask(task, trigger));
    }

    public void addTriggerTask(TriggerTask task) {
        if (this.triggerTasks == null) {
            this.triggerTasks = new ArrayList<TriggerTask>();
        }
        this.triggerTasks.add(task);
    }

    public void addCronTask(Runnable task, String expression) {
        this.addCronTask(new CronTask(task, expression));
    }

    public void addCronTask(CronTask task) {
        if (this.cronTasks == null) {
            this.cronTasks = new ArrayList<CronTask>();
        }
        this.cronTasks.add(task);
    }

    public void addFixedRateTask(Runnable task, long interval) {
        this.addFixedRateTask(new IntervalTask(task, interval, 0L));
    }

    public void addFixedRateTask(IntervalTask task) {
        if (this.fixedRateTasks == null) {
            this.fixedRateTasks = new ArrayList<IntervalTask>();
        }
        this.fixedRateTasks.add(task);
    }

    public void addFixedDelayTask(Runnable task, long delay) {
        this.addFixedDelayTask(new IntervalTask(task, delay, 0L));
    }

    public void addFixedDelayTask(IntervalTask task) {
        if (this.fixedDelayTasks == null) {
            this.fixedDelayTasks = new ArrayList<IntervalTask>();
        }
        this.fixedDelayTasks.add(task);
    }

    public boolean hasTasks() {
        return !CollectionUtils.isEmpty(this.triggerTasks) || !CollectionUtils.isEmpty(this.cronTasks) || !CollectionUtils.isEmpty(this.fixedRateTasks) || !CollectionUtils.isEmpty(this.fixedDelayTasks);
    }

    public void afterPropertiesSet() {
        this.scheduleTasks();
    }

    protected void scheduleTasks() {
        Date startTime;
        long now = System.currentTimeMillis();
        if (this.taskScheduler == null) {
            this.localExecutor = Executors.newSingleThreadScheduledExecutor();
            this.taskScheduler = new ConcurrentTaskScheduler(this.localExecutor);
        }
        if (this.triggerTasks != null) {
            for (TriggerTask triggerTask : this.triggerTasks) {
                this.scheduledFutures.add(this.taskScheduler.schedule(triggerTask.getRunnable(), triggerTask.getTrigger()));
            }
        }
        if (this.cronTasks != null) {
            for (CronTask cronTask : this.cronTasks) {
                this.scheduledFutures.add(this.taskScheduler.schedule(cronTask.getRunnable(), cronTask.getTrigger()));
            }
        }
        if (this.fixedRateTasks != null) {
            for (IntervalTask intervalTask : this.fixedRateTasks) {
                if (intervalTask.getInitialDelay() > 0L) {
                    startTime = new Date(now + intervalTask.getInitialDelay());
                    this.scheduledFutures.add(this.taskScheduler.scheduleAtFixedRate(intervalTask.getRunnable(), startTime, intervalTask.getInterval()));
                    continue;
                }
                this.scheduledFutures.add(this.taskScheduler.scheduleAtFixedRate(intervalTask.getRunnable(), intervalTask.getInterval()));
            }
        }
        if (this.fixedDelayTasks != null) {
            for (IntervalTask intervalTask : this.fixedDelayTasks) {
                if (intervalTask.getInitialDelay() > 0L) {
                    startTime = new Date(now + intervalTask.getInitialDelay());
                    this.scheduledFutures.add(this.taskScheduler.scheduleWithFixedDelay(intervalTask.getRunnable(), startTime, intervalTask.getInterval()));
                    continue;
                }
                this.scheduledFutures.add(this.taskScheduler.scheduleWithFixedDelay(intervalTask.getRunnable(), intervalTask.getInterval()));
            }
        }
    }

    public void destroy() {
        for (ScheduledFuture<?> future : this.scheduledFutures) {
            future.cancel(true);
        }
        if (this.localExecutor != null) {
            this.localExecutor.shutdownNow();
        }
    }
}

