/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.ColorGradientType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Enum;
import com.supermap.data.GeoStyle3D;
import com.supermap.data.JoinItems;
import com.supermap.data.Toolkit;
import com.supermap.realspace.InternalEnum;
import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.RangeMode3D;
import com.supermap.realspace.Theme3D;
import com.supermap.realspace.Theme3DRangeItem;
import com.supermap.realspace.ThemeRange3DNative;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Theme3DRange
extends Theme3D {
    private ArrayList<Theme3DRangeItem> _$1;

    public Theme3DRange() {
        long l = ThemeRange3DNative.jni_New();
        this.setHandle(l, true);
        this._$1 = new ArrayList();
    }

    public Theme3DRange(Theme3DRange theme3DRange) {
        if (theme3DRange == null) {
            String string = InternalResource.loadString("themeRange3D", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (theme3DRange.getHandle() == 0L) {
            String string = InternalResource.loadString("themeRange3D", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ThemeRange3DNative.jni_Clone(theme3DRange.getHandle());
        this.setHandle(l, true);
        this._$1 = new ArrayList();
        int n = theme3DRange.getRangeItemsList().size();
        for (int i = 0; i < n; ++i) {
            Theme3DRangeItem theme3DRangeItem = new Theme3DRangeItem(this);
            this._$1.add(theme3DRangeItem);
        }
    }

    Theme3DRange(long l, boolean bl) {
        this.setHandle(l, bl);
        int n = ThemeRange3DNative.jni_GetValueCount(this.getHandle());
        this._$1 = new ArrayList();
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            Theme3DRangeItem theme3DRangeItem = new Theme3DRangeItem(this);
            this._$1.add(theme3DRangeItem);
        }
    }

    public Theme3DRangeItem get(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n2 = this.getCount();
        if (n < 0 || n >= n2) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        return this._$1.get(n);
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeRange3DNative.jni_GetValueCount(this.getHandle());
        int n2 = 0;
        n2 = n == 0 || n == 1 ? 0 : n - 1;
        return n2;
    }

    public String getRangeExpression() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRangeExpression()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return ThemeRange3DNative.jni_GetRangeExpression(this.getHandle());
    }

    public void setRangeExpression(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setRangeExpression(String value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        ThemeRange3DNative.jni_SetRangeExpression(this.getHandle(), string);
    }

    public boolean addToHead(Theme3DRangeItem theme3DRangeItem) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addToHead(ThemeRange3DItem item)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (theme3DRangeItem.getStart() >= theme3DRangeItem.getEnd()) {
            String string = InternalResource.loadString("item", "ThemeRange3D_TheEndShouldBeBiggerTheStart", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.getCount();
        if (n > 0) {
            double d = ThemeRange3DNative.jni_GetValueAt(this.getHandle(), 0);
            double d2 = theme3DRangeItem.getEnd();
            boolean bl = Toolkit.isZero((double)(d2 - d));
            if (!bl) {
                String string = InternalResource.loadString("item.getEnd()", "ThemeRange3D_InvalidEndOfItem", "realspace_resources");
                throw new IllegalArgumentException(string);
            }
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)theme3DRangeItem.getStyle());
        boolean bl = ThemeRange3DNative.jni_AddToHead(this.getHandle(), theme3DRangeItem.getCaption(), theme3DRangeItem.isVisible(), l, theme3DRangeItem.getStart(), theme3DRangeItem.getEnd());
        if (bl) {
            Theme3DRangeItem theme3DRangeItem2 = new Theme3DRangeItem(this);
            this._$1.add(0, theme3DRangeItem2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)theme3DRangeItem);
        return bl;
    }

    public boolean addToTail(Theme3DRangeItem theme3DRangeItem) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addToTail(ThemeRangeItem item)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (theme3DRangeItem.getStart() >= theme3DRangeItem.getEnd()) {
            String string = InternalResource.loadString("item", "ThemeRange3D_TheEndShouldBeBiggerTheStart", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.getCount();
        if (n > 0) {
            double d = ThemeRange3DNative.jni_GetValueAt(this.getHandle(), n);
            double d2 = theme3DRangeItem.getStart();
            boolean bl = Toolkit.isZero((double)(d2 - d));
            if (!bl) {
                String string = InternalResource.loadString("item.getStart()", "ThemeRange3D_InavlidStartOfItem", "realspace_resources");
                throw new IllegalArgumentException(string);
            }
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)theme3DRangeItem.getStyle());
        boolean bl = ThemeRange3DNative.jni_AddToTail(this.getHandle(), theme3DRangeItem.getCaption(), theme3DRangeItem.isVisible(), l, theme3DRangeItem.getStart(), theme3DRangeItem.getEnd());
        if (bl) {
            Theme3DRangeItem theme3DRangeItem2 = new Theme3DRangeItem(this);
            this._$1.add(theme3DRangeItem2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)theme3DRangeItem);
        return bl;
    }

    public boolean split(int n, double d, GeoStyle3D geoStyle3D, String string, GeoStyle3D geoStyle3D2, String string2) {
        if (this.getHandle() == 0L) {
            String string3 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string3);
        }
        int n2 = this.getCount();
        if (n < 0 || n >= n2) {
            String string4 = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string4);
        }
        if (geoStyle3D == null) {
            String string5 = InternalResource.loadString("style1", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string5);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle3D);
        if (l == 0L) {
            String string6 = InternalResource.loadString("style1", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string6);
        }
        if (geoStyle3D2 == null) {
            String string7 = InternalResource.loadString("style2", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string7);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle3D2);
        if (l2 == 0L) {
            String string8 = InternalResource.loadString("style2", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string8);
        }
        double d2 = ThemeRange3DNative.jni_GetValueAt(this.getHandle(), n);
        double d3 = ThemeRange3DNative.jni_GetValueAt(this.getHandle(), n + 1);
        if (d <= d2 || d >= d3) {
            String string9 = InternalResource.loadString("splitValue", "ThemeRange3D_InvalidSplitValue", "realspace_resources");
            throw new IllegalArgumentException(string9);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle3D.clone());
        long l4 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle3D2.clone());
        if (string == null || string.trim().length() == 0) {
            String string10 = InternalResource.loadString("caption1", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string10);
        }
        if (string2 == null || string2.trim().length() == 0) {
            String string11 = InternalResource.loadString("caption2", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string11);
        }
        boolean bl = ThemeRange3DNative.jni_Split(this.getHandle(), n, d, l3, string, l4, string2);
        if (bl) {
            Theme3DRangeItem theme3DRangeItem = new Theme3DRangeItem(this);
            this._$1.add(n + 1, theme3DRangeItem);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle3D);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle3D2);
        return bl;
    }

    public boolean merge(int n, int n2, GeoStyle3D geoStyle3D, String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("merge(int index, int count, GeoStyle3D style, String caption)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        int n3 = this.getCount();
        if (n < 0 || n >= n3) {
            String string3 = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string3);
        }
        if (n2 < 0 || n + n2 > n3) {
            String string4 = InternalResource.loadString("count", "ThemeRange3D_TheCountIsInvalid", "realspace_resources");
            throw new IllegalArgumentException(string4);
        }
        if (geoStyle3D == null) {
            String string5 = InternalResource.loadString("style", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string5);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle3D);
        if (l == 0L) {
            String string6 = InternalResource.loadString("style", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string6);
        }
        if (n2 == 0) {
            return true;
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle3D.clone());
        if (string == null || string.trim().length() == 0) {
            String string7 = InternalResource.loadString("caption", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string7);
        }
        boolean bl = ThemeRange3DNative.jni_Merge(this.getHandle(), n, n2, l2, string);
        if (bl) {
            Theme3DRangeItem theme3DRangeItem = this._$1.get(n);
            double d = ThemeRange3DNative.jni_GetValueAt(this.getHandle(), n + 1);
            theme3DRangeItem.setEnd(d);
            theme3DRangeItem.setCaption(string);
            theme3DRangeItem.setStyle(geoStyle3D.clone());
            for (int i = 0; i < n2 - 1; ++i) {
                Theme3DRangeItem theme3DRangeItem2 = this._$1.get(n + 1);
                theme3DRangeItem2.clearHandle();
                this._$1.remove(n + 1);
            }
            this._$3();
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle3D);
        return bl;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        ThemeRange3DNative.jni_Clear(this.getHandle());
        if (this._$1 != null) {
            int n = this._$1.size();
            for (int i = 0; i < n; ++i) {
                Theme3DRangeItem theme3DRangeItem = this._$1.get(i);
                theme3DRangeItem.clearHandle();
            }
            this._$1.clear();
        }
    }

    public static Theme3DRange makeDefault(DatasetVector datasetVector, String string, RangeMode3D rangeMode3D, double d) {
        return Theme3DRange.makeDefault(datasetVector, string, rangeMode3D, d, null, null);
    }

    public static Theme3DRange makeDefault(DatasetVector datasetVector, String string, RangeMode3D rangeMode3D, double d, ColorGradientType colorGradientType) {
        return Theme3DRange.makeDefault(datasetVector, string, rangeMode3D, d, colorGradientType, null);
    }

    public static Theme3DRange makeDefault(DatasetVector datasetVector, String string, RangeMode3D rangeMode3D, double d, ColorGradientType colorGradientType, JoinItems joinItems) {
        long l;
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        if (l2 == 0L) {
            String string2 = InternalResource.loadString("dataset", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("rangeExpression", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string3);
        }
        if (joinItems == null) {
            joinItems = new JoinItems();
        }
        if ((l = InternalHandle.getHandle((com.supermap.data.InternalHandle)joinItems)) == 0L) {
            String string4 = InternalResource.loadString("joinItems", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string4);
        }
        if (rangeMode3D == null) {
            String string5 = InternalResource.loadString("rangeMode", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string5);
        }
        if ((rangeMode3D.equals((Object)RangeMode3D.EQUALINTERVAL) || rangeMode3D.equals((Object)RangeMode3D.SQUAREROOT) || rangeMode3D.equals((Object)RangeMode3D.STDDEVIATION) || rangeMode3D.equals((Object)RangeMode3D.LOGARITHM) || rangeMode3D.equals((Object)RangeMode3D.QUANTILE)) && d < 1.0) {
            String string6 = InternalResource.loadString("rangeParameter", "ThemeRange3D_TheArgumentOfRangeParameterShouldNotBeLessThanOneRange", "realspace_resources");
            throw new IllegalArgumentException(string6);
        }
        if (rangeMode3D.equals((Object)RangeMode3D.CUSTOMINTERVAL) && d < 0.0) {
            String string7 = InternalResource.loadString("rangeParameter", "ThemeRange3D_TheArgumentOfRangeParameterShouldBePositive", "realspace_resources");
            throw new IllegalArgumentException(string7);
        }
        if (colorGradientType == null) {
            colorGradientType = ColorGradientType.YELLOWRED;
        }
        int n = InternalEnum.getUGCValue(rangeMode3D);
        int n2 = InternalEnum.getUGCValue((Enum)colorGradientType);
        long l3 = ThemeRange3DNative.jni_MakeDefault(l2, string, l, n, d, n2);
        Theme3DRange theme3DRange = null;
        if (l3 != 0L) {
            theme3DRange = new Theme3DRange(l3, true);
        }
        return theme3DRange;
    }

    public int indexOf(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeRange3DNative.jni_GetValueCount(this.getHandle());
        double[] dArray = new double[n];
        ThemeRange3DNative.jni_GetValues(this.getHandle(), dArray);
        int n2 = -1;
        for (int i = 0; i < n - 1; ++i) {
            if (!(dArray[i] <= d) || !(d < dArray[i + 1])) continue;
            n2 = i;
        }
        return n2;
    }

    public void reverseStyle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("reverseStyle()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        ThemeRange3DNative.jni_ReverseStyle(this.getHandle());
    }

    @Override
    public boolean fromXML(String string) {
        boolean bl = super.fromXML(string);
        if (bl) {
            this._$1();
        }
        return bl;
    }

    @Override
    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Count = ");
        stringBuffer.append(n);
        stringBuffer.append(",RangeExpression = ");
        stringBuffer.append(this.getRangeExpression());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "realspace_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ThemeRange3DNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public RangeMode3D getRangeMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRangeMode()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeRange3DNative.jni_GetRangeMode(this.getHandle());
        return (RangeMode3D)Enum.parse(RangeMode3D.class, (int)n);
    }

    ArrayList<Theme3DRangeItem> getRangeItemsList() {
        return this._$1;
    }

    @Override
    protected void clearHandle() {
        if (this._$1 != null) {
            this._$2();
            this._$1 = null;
        }
        this.setHandle(0L);
    }

    private void _$3() {
        int n = this.getCount();
        long[] lArray = new long[n];
        ThemeRange3DNative.jni_GetStylesHandle(this.getHandle(), lArray);
        for (int i = 0; i < n; ++i) {
            Theme3DRangeItem theme3DRangeItem = this.get(i);
            theme3DRangeItem.refreshStyle(lArray[i]);
        }
    }

    private void _$2() {
        int n = this._$1.size();
        for (int i = 0; i < n; ++i) {
            Theme3DRangeItem theme3DRangeItem = this._$1.get(i);
            theme3DRangeItem.clearHandle();
        }
        this._$1.clear();
    }

    private void _$1() {
        if (this._$1 != null) {
            this._$2();
        }
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            Theme3DRangeItem theme3DRangeItem = new Theme3DRangeItem(this);
            this._$1.add(theme3DRangeItem);
        }
    }
}

