/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.Rectangle2D;
import com.supermap.data.processing.CacheImageSize;
import com.supermap.data.processing.CacheImageType;
import com.supermap.data.processing.InternalEnum;
import com.supermap.data.processing.InternalHandleDisposable;
import com.supermap.data.processing.InternalResource;
import com.supermap.data.processing.TileFormat;
import com.supermap.data.processing.TileNative;
import com.supermap.data.processing.TileSize;

public class Tile
extends InternalHandleDisposable {
    protected Tile() {
        long l = TileNative.jni_New();
        this.setHandle(l, true);
    }

    Tile(long l, boolean bl) {
        this.setHandle(l, bl);
    }

    public int getRow() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRow()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return TileNative.jni_GetRow(this.getHandle());
    }

    public int getColumn() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColumn()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return TileNative.jni_GetColumn(this.getHandle());
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        TileNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    @Deprecated
    public CacheImageSize getSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSize()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = TileNative.jni_GetSize(this.getHandle());
        CacheImageSize cacheImageSize = CacheImageSize.SIZE256;
        switch (n) {
            case 64: {
                cacheImageSize = CacheImageSize.SIZE64;
                break;
            }
            case 128: {
                cacheImageSize = CacheImageSize.SIZE128;
                break;
            }
            case 256: {
                cacheImageSize = CacheImageSize.SIZE256;
                break;
            }
            case 512: {
                cacheImageSize = CacheImageSize.SIZE512;
                break;
            }
            case 1024: {
                cacheImageSize = CacheImageSize.SIZE1024;
                break;
            }
            case 2048: {
                cacheImageSize = CacheImageSize.SIZE2048;
                break;
            }
            default: {
                cacheImageSize = CacheImageSize.SIZE256;
            }
        }
        return cacheImageSize;
    }

    public double getScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScale()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return TileNative.jni_GetScale(this.getHandle());
    }

    @Deprecated
    public CacheImageType getTileFormat() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTileFormat()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = TileNative.jni_GetTileFormat(this.getHandle());
        CacheImageType cacheImageType = null;
        cacheImageType = (CacheImageType)InternalEnum.parseUGCValue(CacheImageType.class, n);
        return cacheImageType;
    }

    public byte[] getData() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getData()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        byte[] byArray = TileNative.jni_GetData(this.getHandle());
        this.getIsDisposable();
        return byArray;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            TileNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public TileSize getTileSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTileSize()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = TileNative.jni_GetSize(this.getHandle());
        TileSize tileSize = TileSize.SIZE256;
        switch (n) {
            case 64: {
                tileSize = TileSize.SIZE64;
                break;
            }
            case 128: {
                tileSize = TileSize.SIZE128;
                break;
            }
            case 256: {
                tileSize = TileSize.SIZE256;
                break;
            }
            case 512: {
                tileSize = TileSize.SIZE512;
                break;
            }
            case 1024: {
                tileSize = TileSize.SIZE1024;
                break;
            }
            default: {
                tileSize = TileSize.SIZE256;
            }
        }
        return tileSize;
    }

    public TileFormat getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = TileNative.jni_GetTileFormat(this.getHandle());
        TileFormat tileFormat = null;
        tileFormat = (TileFormat)InternalEnum.parseUGCValue(TileFormat.class, n);
        return tileFormat;
    }

    protected void setBounds(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBounds()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (rectangle2D == null) {
            String string = InternalResource.loadString("rect", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        if (rectangle2D.getHeight() < 0.0) {
            String string = InternalResource.loadString("rect", "Map_CacheBoundsHeightShouldBePositive", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        if (rectangle2D.getWidth() < 0.0) {
            String string = InternalResource.loadString("rect", "Map_CacheBoundsWidthShouldBePositive", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        TileNative.jni_SetBounds(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
    }

    protected void setColumn(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setColumn()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        TileNative.jni_SetColumn(this.getHandle(), n);
    }

    protected void setRow(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRow()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        TileNative.jni_SetRow(this.getHandle(), n);
    }

    protected void setScale(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScale()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        TileNative.jni_SetScale(this.getHandle(), d);
    }

    protected void setTileSize(TileSize tileSize) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTileSize()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(tileSize);
        TileNative.jni_setTileSize(this.getHandle(), n);
    }

    protected void setTileFormat(TileFormat tileFormat) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTileFormat()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(tileFormat);
        TileNative.jni_setTileFormat(this.getHandle(), n);
    }

    protected void setData(byte[] byArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setData()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        TileNative.jni_setData(this.getHandle(), byArray);
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = new String();
        string = string + "[";
        string = string + "Row=";
        string = string + new Integer(this.getRow()).toString();
        string = string + ",Column=";
        string = string + new Integer(this.getColumn()).toString();
        string = string + ",Scale=";
        string = string + new Double(this.getScale()).toString();
        string = string + ",";
        string = string + this.getBounds().toString();
        string = string + "]";
        return string;
    }
}

