/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.DatasetGrid;
import com.supermap.data.EncodeType;
import com.supermap.data.GeoRegion;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.PrjCoordSysType;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.processing.CacheBuilderSCTNative;
import com.supermap.data.processing.CompressType;
import com.supermap.data.processing.InternalEnum;
import com.supermap.data.processing.InternalGeoRegion;
import com.supermap.data.processing.InternalGeometry;
import com.supermap.data.processing.InternalHandle;
import com.supermap.data.processing.InternalResource;
import com.supermap.data.processing.InternalToolkitProcessing;
import com.supermap.data.processing.StorageType;
import com.supermap.data.processing.Tile;
import com.supermap.data.processing.Tiles;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerrainCacheBuilder
extends com.supermap.data.processing.InternalHandleDisposable {
    private DatasetGrid _$5;
    private GeoRegion _$4;
    private long _$3;
    transient Vector m_steppedListeners;
    private String _$2;
    private static String _$1;

    public TerrainCacheBuilder() {
        long l = CacheBuilderSCTNative.jni_New();
        this.setHandle(l, true);
        this._$3 = CacheBuilderSCTNative.jni_NewSelfEventHandle(this);
    }

    public TerrainCacheBuilder(DatasetGrid datasetGrid, String string) {
        this();
        this.setDataset(datasetGrid);
        this.setOutputFolder(string);
    }

    public TerrainCacheBuilder(DatasetGrid datasetGrid, String string, String string2) {
        this();
        this.setDataset(datasetGrid);
        this.setOutputFolder(string);
        this.setCacheName(string2);
    }

    public DatasetGrid getDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDataset()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this._$5;
    }

    public void setDataset(DatasetGrid datasetGrid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDataset(DatasetGrid datasetGrid)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (datasetGrid == null) {
            String string = InternalResource.loadString("datasetGrid", "Global_ArgumentNull", "processing_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        if (l == 0L) {
            String string = InternalResource.loadString("datasetGrid", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        this._$5 = datasetGrid;
        CacheBuilderSCTNative.jni_SetDataset(this.getHandle(), l);
    }

    public StorageType getStorageType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStorageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = CacheBuilderSCTNative.jni_GetStorageType(this.getHandle());
        return (StorageType)InternalEnum.parseUGCValue(StorageType.class, n);
    }

    public void setStorageType(StorageType storageType) {
        if (storageType == null) {
            String string = InternalResource.loadString("storageType", "CacheBuilderS_StorageTypeShouldNotBeNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStorageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderSCTNative.jni_SetStorageType(this.getHandle(), storageType.value());
    }

    @Deprecated
    public CompressType getCompressType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCompressType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = CacheBuilderSCTNative.jni_GetCompressType(this.getHandle());
        return (CompressType)InternalEnum.parseUGCValue(CompressType.class, n);
    }

    @Deprecated
    public void setCompressType(CompressType compressType) {
        if (compressType == null) {
            String string = InternalResource.loadString("compressType", "CacheBuilder_CompressTypeShouldNotBeNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCompressType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderSCTNative.jni_SetCompressType(this.getHandle(), compressType.value());
    }

    @Deprecated
    public EncodeType getEncodeType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getEncodeType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = CacheBuilderSCTNative.jni_GetEncodeType(this.getHandle());
        return (EncodeType)InternalEnum.parseUGCValue(EncodeType.class, n);
    }

    @Deprecated
    public void setEncodeType(EncodeType encodeType) {
        if (encodeType == null) {
            String string = InternalResource.loadString("encodeType", "CacheBuilder_CompressTypeShouldNotBeNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEncodeTypeType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderSCTNative.jni_SetEncodeType(this.getHandle(), encodeType.value());
    }

    public String getOutputFolder() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputFolder()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCTNative.jni_GetOutputFolder(this.getHandle());
    }

    public void setOutputFolder(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setOutputFolder(String value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        File file = new File(string);
        if (!file.exists()) {
            String string3 = InternalResource.loadString("value", "CacheBuilderSCT_OutputFolderNotExists", "processing_resources");
            throw new IllegalArgumentException(string3);
        }
        CacheBuilderSCTNative.jni_SetOutputFolder(this.getHandle(), string);
    }

    public String getCacheName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCacheName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCTNative.jni_GetCacheName(this.getHandle());
    }

    public void setCacheName(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setCacheName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "processing_resources");
            throw new IllegalArgumentException(string3);
        }
        CacheBuilderSCTNative.jni_SetCacheName(this.getHandle(), string);
    }

    public GeoRegion getClipRegion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getClipRegion()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this._$4 == null) {
            long l = CacheBuilderSCTNative.jni_GetClipRegion(this.getHandle());
            if (l != 0L) {
                this._$4 = (GeoRegion)InternalGeometry.createInstance(l);
                com.supermap.data.processing.InternalHandleDisposable.setIsDisposable((InternalHandleDisposable)this._$4, false);
                if (this._$4.isEmpty()) {
                    this._$4 = null;
                }
            }
        } else {
            long l = CacheBuilderSCTNative.jni_GetClipRegion(this.getHandle());
            InternalGeoRegion.clearHandle(this._$4);
            InternalGeoRegion.refreshHandle(this._$4, l);
        }
        return this._$4;
    }

    public void setClipRegion(GeoRegion geoRegion) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setClipRegion(GeoRegion geoRegion)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (geoRegion == null) {
            CacheBuilderSCTNative.jni_SetClipRegion(this.getHandle(), 0L);
            this._$4 = null;
        } else {
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
            if (l == 0L) {
                String string = InternalResource.loadString("geoRegion", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
                throw new IllegalArgumentException(string);
            }
            CacheBuilderSCTNative.jni_SetClipRegion(this.getHandle(), l);
        }
        com.supermap.data.processing.InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
    }

    @Deprecated
    public int getBeginLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBeginLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCTNative.jni_GetBeginLevel(this.getHandle());
    }

    @Deprecated
    public void setBeginLevel(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBeginLevel(int value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0) {
            String string = InternalResource.loadString("value", "CacheBuilderSCT_BeginLevelShouldNotBeNegative", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        CacheBuilderSCTNative.jni_SetBeginLevel(this.getHandle(), n);
    }

    @Deprecated
    public int getEndLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getEndLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCTNative.jni_GetEndLevel(this.getHandle());
    }

    @Deprecated
    public void setEndLevel(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEndLevel(int value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0) {
            String string = InternalResource.loadString("value", "CacheBuilderSCT_EndLevelShouldNotBeNegative", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        CacheBuilderSCTNative.jni_SetEndLevel(this.getHandle(), n);
    }

    @Deprecated
    public int getDefaultBeginLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDefaultBeginLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCTNative.jni_GetDefaultBeginLevel(this.getHandle());
    }

    @Deprecated
    public int getDefaultEndLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDefaultEndLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCTNative.jni_GetDefaultEndLevel(this.getHandle());
    }

    public int getSampleSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSampleSize()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCTNative.jni_GetSampleSize(this.getHandle());
    }

    public void setSampleSize(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("dispose()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0) {
            String string = InternalResource.loadString("value", "CacheBuilderSCT_SampleSizeShouldNotBeNegative", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        CacheBuilderSCTNative.jni_SetSampleSize(this.getHandle(), n);
    }

    public PrjCoordSysType getDynamicPrjCoordSysType() {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isDynamicProjection()", "Handle_ObjectHasBeenDisposed", "processing_resources");
        }
        PrjCoordSysType prjCoordSysType = (n = CacheBuilderSCTNative.jni_GetDynamicPrjCoordSysType(this.getHandle())) == 1 ? PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE : PrjCoordSysType.PCS_NON_EARTH;
        return prjCoordSysType;
    }

    public void setDynamicPrjCoordSysType(PrjCoordSysType prjCoordSysType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDynamicProjection(boolean dynamicProjection)", "Handle_ObjectHasBeenDisposed", "processing_resources");
        }
        int n = prjCoordSysType == PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE ? 1 : 0;
        CacheBuilderSCTNative.jni_SetDynamicPrjCoordSysType(this.getHandle(), n);
    }

    public String getPassword() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPassword()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this._$2;
    }

    public void setPassword(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setPassword()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        this._$2 = string;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            CacheBuilderSCTNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public boolean build() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this._$5 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5) == 0L) {
            String string = InternalResource.loadString("build()", "CacheBuilderSCT_DatasetGridIsNULLOrHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (!this._$5.isOpen()) {
            this._$5.open();
        }
        if (!this._$5.getHasPyramid()) {
            String string = InternalResource.loadString("build()", "CacheBuilderSCT_BuildDatasetGridShouldHasPyramid", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getOutputFolder() == null || this.getOutputFolder().trim().length() == 0) {
            String string = InternalResource.loadString("ouputFolder", "Global_StringIsNullOrEmpty", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.getEndLevel() - this.getBeginLevel();
        if (n < 0) {
            String string = InternalResource.loadString("build()", "CacheBuilderSCT_BuildEndLevelShouldNoLessThanBeginLevel", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this._$2 == null || this._$2.trim().length() == 0) {
            return CacheBuilderSCTNative.jni_Build(this.getHandle(), this._$3);
        }
        return CacheBuilderSCTNative.jni_BuildWithPassword(this.getHandle(), this._$3, this._$2);
    }

    public boolean buildWithoutConfigFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this._$5 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5) == 0L) {
            String string = InternalResource.loadString("build()", "CacheBuilderSCT_DatasetGridIsNULLOrHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (!this._$5.isOpen()) {
            this._$5.open();
        }
        if (!this._$5.getHasPyramid()) {
            String string = InternalResource.loadString("build()", "CacheBuilderSCT_BuildDatasetGridShouldHasPyramid", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getOutputFolder() == null || this.getOutputFolder().trim().length() == 0) {
            String string = InternalResource.loadString("ouputFolder", "Global_StringIsNullOrEmpty", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.getEndLevel() - this.getBeginLevel();
        if (n < 0) {
            String string = InternalResource.loadString("build()", "CacheBuilderSCT_BuildEndLevelShouldNoLessThanBeginLevel", "processing_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        bl = this._$2 == null || this._$2.trim().length() == 0 ? CacheBuilderSCTNative.jni_BuildWithoutConfigFile(this.getHandle(), this._$3) : CacheBuilderSCTNative.jni_BuildWithoutConfigFile(this.getHandle(), this._$3, this._$2);
        ((Object)((Object)this)).hashCode();
        return bl;
    }

    public boolean computeOutputScales() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeOutputScales()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = CacheBuilderSCTNative.jni_ComputeOutputScales(this.getHandle());
        return bl;
    }

    public double[] getDefaultOutputScales() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDefultOutputScales()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCTNative.jni_GetDefaultOutputScales(this.getHandle());
    }

    public HashMap<Double, String> getOutputScaleCaptions() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputScaleCaptions()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = CacheBuilderSCTNative.jni_GetOutputScalesCount(this.getHandle());
        double[] dArray = new double[n];
        String[] stringArray = new String[n];
        HashMap<Double, String> hashMap = new HashMap<Double, String>();
        CacheBuilderSCTNative.jni_GetOutputScaleCaptions(this.getHandle(), dArray, stringArray);
        for (int i = 0; i < n; ++i) {
            hashMap.put(dArray[i], stringArray[i]);
        }
        return hashMap;
    }

    public void setOutputScaleCaptions(HashMap<Double, String> hashMap) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutputScaleCaptions()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (hashMap == null) {
            String string = InternalResource.loadString("setOutputScaleCaptions()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = hashMap.size();
        double[] dArray = new double[n];
        String[] stringArray = new String[n];
        Set<Map.Entry<Double, String>> set = hashMap.entrySet();
        Iterator<Map.Entry<Double, String>> iterator = set.iterator();
        Map.Entry<Double, String> entry = null;
        for (int i = 0; i < n; ++i) {
            entry = iterator.next();
            dArray[i] = entry.getKey();
            stringArray[i] = entry.getValue();
        }
        CacheBuilderSCTNative.jni_SetOutputScaleCaptions(this.getHandle(), dArray, stringArray);
    }

    public double[] getOutputScales() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputScales()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCTNative.jni_GetOutputScales(this.getHandle());
    }

    public void setOutputScales(double[] dArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutputScales()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (!CacheBuilderSCTNative.jni_SetOutputScales(this.getHandle(), dArray)) {
            String string = InternalResource.loadString("setOutputScales()", "CacheBuilder_IllegalScales", "processing_resources");
            throw new IllegalArgumentException(string);
        }
    }

    @Deprecated
    public boolean computeLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this._$5 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5) == 0L) {
            String string = InternalResource.loadString("datasetGrid", "CacheBuilderSCT_DatasetGridIsNULLOrHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCTNative.jni_ComputeLevel(this.getHandle());
    }

    @Deprecated
    public String[] computeTerrainFileName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ComputeImageFileName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this._$5 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5) == 0L) {
            String string = InternalResource.loadString("datasetGrid", "CacheBuilderSCT_DatasetGridIsNULLOrHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = CacheBuilderSCTNative.jni_ComputeImageFileName(this.getHandle());
        return InternalToolkitProcessing.splitString(string, ";");
    }

    @Deprecated
    public String[] computeTerrainFileName(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ComputeImageFileName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this._$5 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5) == 0L) {
            String string = InternalResource.loadString("datasetGrid", "CacheBuilderSCT_DatasetGridIsNULLOrHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = CacheBuilderSCTNative.jni_ComputeImageFileName(this.getHandle(), n);
        return InternalToolkitProcessing.splitString(string, ";");
    }

    public boolean toConfigFile(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("ToFile(String path)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        return CacheBuilderSCTNative.jni_ToFile(this.getHandle(), string);
    }

    public boolean fromConfigFile(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("FromFile(String path)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        return CacheBuilderSCTNative.jni_FromFile(this.getHandle(), string);
    }

    public Tile[] getTiles(Rectangle2D rectangle2D, double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTiles()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Tiles tiles = null;
        long l = CacheBuilderSCTNative.jni_GetTiles(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getTop(), rectangle2D.getRight(), rectangle2D.getBottom(), d);
        tiles = new Tiles(l);
        Tile[] tileArray = new Tile[tiles.getCount()];
        for (int i = 0; i < tiles.getCount(); ++i) {
            tileArray[i] = tiles.get(i);
        }
        return tileArray;
    }

    public synchronized void addSteppedListener(SteppedListener steppedListener) {
        if (this.m_steppedListeners == null) {
            this.m_steppedListeners = new Vector();
        }
        if (!this.m_steppedListeners.contains(steppedListener)) {
            this.m_steppedListeners.add(steppedListener);
        }
    }

    public synchronized void removeSteppedListener(SteppedListener steppedListener) {
        if (this.m_steppedListeners != null && this.m_steppedListeners.contains(steppedListener)) {
            this.m_steppedListeners.remove(steppedListener);
        }
    }

    protected void fireStepped(SteppedEvent steppedEvent) {
        if (this.m_steppedListeners != null) {
            Vector vector = this.m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(steppedEvent);
            }
        }
    }

    static void steppedCallBack(TerrainCacheBuilder terrainCacheBuilder, int n, long l, String string, String string2, long l2) {
        if (terrainCacheBuilder != null) {
            _$1 = "build";
            boolean bl = InternalToolkitProcessing.getHandleBooleanValue(l2);
            SteppedEvent steppedEvent = new SteppedEvent((Object)terrainCacheBuilder, n, l, string, string2, _$1, bl);
            terrainCacheBuilder.fireStepped(steppedEvent);
            InternalToolkitProcessing.setHandleBooleanValue(l2, steppedEvent.getCancel());
        }
    }

    protected void clearHandle() {
        this._$5 = null;
        this._$1();
        if (this._$4 != null) {
            InternalGeoRegion.clearHandle(this._$4);
            this._$4 = null;
        }
        this.setHandle(0L);
    }

    private void _$1() {
        if (this._$3 != 0L) {
            CacheBuilderSCTNative.jni_DeleteSelfEventHandle(this._$3);
            this._$3 = 0L;
        }
    }
}

