/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.BlockSizeOption;
import com.supermap.data.ColorSpaceType;
import com.supermap.data.Colors;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGridNative;
import com.supermap.data.DatasetImageNative;
import com.supermap.data.Datasource;
import com.supermap.data.Enum;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.PixelFormat;
import com.supermap.data.Point2D;
import com.supermap.data.Rectangle2D;
import com.supermap.data.StatisticsResult;
import java.awt.Point;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasetImage
extends Dataset {
    private GeoRegion _$4 = null;
    private static Integer _$3 = new Integer(0);

    DatasetImage(long l, Datasource datasource) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasource == null) {
            String string = InternalResource.loadString("datasource", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("datasource", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(l);
        this.m_datasource = datasource;
    }

    private DatasetImage() {
        m_senderMethodName = "buildPyramid";
    }

    public int getWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageNative.jni_GetWidth(this.getHandle());
    }

    public int getHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageNative.jni_GetHeight(this.getHandle());
    }

    public BlockSizeOption getBlockSizeOption() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetImageNative.jni_GetBlockSize(this.getHandle());
        return (BlockSizeOption)Enum.parseUGCValue(BlockSizeOption.class, n);
    }

    public GeoRegion getClipRegion() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$4 == null && (l = DatasetImageNative.jni_GetClipRegion(this.getHandle())) != 0L) {
            this._$4 = (GeoRegion)Geometry.createInstance(l);
        }
        return this._$4;
    }

    public void setClipRegion(GeoRegion geoRegion) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoRegion == null) {
            if (this._$4 != null) {
                this._$4.clearHandle();
                this._$4 = null;
            }
            DatasetImageNative.jni_SetClipRegion(this.getHandle(), 0L);
        } else {
            if (geoRegion.getHandle() == 0L) {
                String string = InternalResource.loadString("value", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetImageNative.jni_SetClipRegion(this.getHandle(), geoRegion.getHandle());
            if (this._$4 != null) {
                this._$4.fromXML(geoRegion.toXML());
            }
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geoRegion);
    }

    public ColorSpaceType getColorSpace() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColorSpace()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetImageNative.jni_GetColorSpaceType(this.getHandle());
        return (ColorSpaceType)Enum.parseUGCValue(ColorSpaceType.class, n);
    }

    public void setColorSpace(ColorSpaceType colorSpaceType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setColorSpace(ColorSpaceType value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetImageNative.jni_SetColorSpaceType(this.getHandle(), colorSpaceType.getUGCValue());
    }

    public HashMap<Integer, StatisticsResult> getImageStatisticsResult() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("statictic(StatisticMode mode)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        HashMap<Integer, StatisticsResult> hashMap = new HashMap<Integer, StatisticsResult>();
        int n = this.getBandCount();
        int[] nArray = new int[n];
        long[] lArray = new long[n];
        boolean bl = DatasetImageNative.jni_GetRasterStatisticsResult(this.getHandle(), nArray, lArray);
        for (int i = 0; i < n; ++i) {
            StatisticsResult statisticsResult = new StatisticsResult(lArray[i]);
            hashMap.put(nArray[i], statisticsResult);
        }
        return hashMap;
    }

    public boolean getHasPyramid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageNative.jni_GetHasPyramid(this.getHandle());
    }

    public int getBandCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetBandCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageNative.jni_GetBandCount(this.getHandle());
    }

    public double getNoData(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getBandCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return DatasetImageNative.jni_GetNoData(this.getHandle(), n);
    }

    public void setNoData(double d, int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getBandCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        DatasetImageNative.jni_SetNoData(this.getHandle(), d, n);
    }

    public double getMinValue(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getBandCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return DatasetImageNative.jni_GetMinValue(this.getHandle(), n);
    }

    public double getMaxValue(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getBandCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return DatasetImageNative.jni_GetMaxValue(this.getHandle(), n);
    }

    public PixelFormat getPixelFormat(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getBandCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n2 = DatasetImageNative.jni_GetPixelFormat(this.getHandle(), n);
        return (PixelFormat)Enum.parseUGCValue(PixelFormat.class, n2);
    }

    public Colors getPalette(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getBandCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        long l = DatasetImageNative.jni_GetColorTable(this.getHandle(), n);
        if (l == 0L) {
            return null;
        }
        Colors colors = new Colors(l, false);
        colors.setIsDisposable(false);
        return colors;
    }

    public void setPalette(Colors colors, int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getBandCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (colors == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (colors.getHandle() == 0L) {
            String string = InternalResource.loadString("value", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Colors colors2 = this.getPalette(n);
        colors2.clear();
        int n2 = colors.getCount();
        for (int i = 0; i < n2; ++i) {
            colors2.add(colors.get(i));
        }
        InternalHandleDisposable.makeSureNativeObjectLive(colors);
    }

    public void setGeoReference(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (rectangle2D == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        DatasetImageNative.jni_SetBounds(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
    }

    public boolean calculateExtremum() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageNative.jni_CalculateExtremum(this.getHandle());
    }

    public boolean calculateExtremum(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageNative.jni_CalculateExtremumByIndex(this.getHandle(), n);
    }

    public double getValue(int n, int n2, int n3) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getWidth()) {
            String string = InternalResource.loadString("column", "DatasetGrid_ColumnIsOutOfRange", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0 || n2 >= this.getHeight()) {
            String string = InternalResource.loadString("row", "DatasetGrid_RowIsOutOfRange", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n3 < 0 || n3 >= this.getBandCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return DatasetImageNative.jni_GetValue(this.getHandle(), n, n2, n3);
    }

    public double setValue(int n, int n2, double d, int n3) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "DatasetGrid_TheDatasourceOrDatasetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getWidth()) {
            String string = InternalResource.loadString("column", "DatasetGrid_ColumnIsOutOfRange", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0 || n2 >= this.getHeight()) {
            String string = InternalResource.loadString("row", "DatasetGrid_RowIsOutOfRange", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n3 < 0 || n3 >= this.getBandCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return DatasetImageNative.jni_SetValue(this.getHandle(), n, n2, d, n3);
    }

    public Point2D imageToXY(Point point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        DatasetImageNative.jni_ImageToXY(this.getHandle(), point.x, point.y, dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public Point xyToImage(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = new int[2];
        DatasetImageNative.jni_XYToImage(this.getHandle(), point2D.getX(), point2D.getY(), nArray);
        return new Point(nArray[0], nArray[1]);
    }

    public HashMap<Integer, StatisticsResult> buildStatistics() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("statictic(StatisticMode mode)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        HashMap<Integer, StatisticsResult> hashMap = new HashMap<Integer, StatisticsResult>();
        int n = this.getBandCount();
        int[] nArray = new int[n];
        long[] lArray = new long[n];
        boolean bl = DatasetImageNative.jni_BuildStatistics(this.getHandle(), nArray, lArray);
        if (!bl) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            StatisticsResult statisticsResult = null;
            if (lArray[i] == 0L) continue;
            statisticsResult = new StatisticsResult(lArray[i]);
            hashMap.put(nArray[i], statisticsResult);
        }
        return hashMap;
    }

    public boolean buildPyramid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (this.getHasPyramid()) {
            bl = true;
        } else {
            this.m_selfEventHandle = DatasetImageNative.jni_NewSelfEventHandle(this);
            bl = DatasetImageNative.jni_BuildPyramid(this.getHandle(), this.m_selfEventHandle);
            this.clearSelfEventHandle();
        }
        return bl;
    }

    public boolean updatePyramid(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        bl = DatasetGridNative.jni_UpdatePyramid(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
        return bl;
    }

    public boolean removePyramid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageNative.jni_RemovePyramid(this.getHandle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addBand(DatasetImage datasetImage) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addBand(DatasetImage dataset)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!DatasetImageNative.jni_IsMultiBand(this.getHandle())) {
            String string = InternalResource.loadString("addBand(DatasetImage dataset)", "DatasetImage_ThisOperationIsAvailableForMultibandsDataOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (datasetImage == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(datasetImage);
        if (l == 0L) {
            String string = InternalResource.loadString("dataset", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Integer n = _$3;
        synchronized (n) {
            DatasetImageNative.jni_addBand(this.getHandle(), l);
            int n2 = this.getBandCount();
            return n2 - 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addBand(DatasetImage[] datasetImageArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addBand(DatasetImage[] datasets)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!DatasetImageNative.jni_IsMultiBand(this.getHandle())) {
            String string = InternalResource.loadString("addBand(DatasetImage[] datasets)", "DatasetImage_ThisOperationIsAvailableForMultibandsDataOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (datasetImageArray == null) {
            String string = InternalResource.loadString("datasets", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        for (int i = 0; i < datasetImageArray.length; ++i) {
            long l = InternalHandle.getHandle(datasetImageArray[i]);
            if (l != 0L) continue;
            String string = InternalResource.loadString("datasets", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Integer n = _$3;
        synchronized (n) {
            int n2;
            int n3 = this.getBandCount();
            for (n2 = 0; n2 < datasetImageArray.length; ++n2) {
                this.addBand(datasetImageArray[n2]);
            }
            n2 = this.getBandCount();
            return n2 - n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addBand(DatasetImage datasetImage, int[] nArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("AddBand(DatasetImage dataset, int[] indexes)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!DatasetImageNative.jni_IsMultiBand(this.getHandle())) {
            String string = InternalResource.loadString("addBand(DatasetImage dataset, int[] indexes)", "DatasetImage_ThisOperationIsAvailableForMultibandsDataOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (datasetImage == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(datasetImage);
        if (l == 0L) {
            String string = InternalResource.loadString("indexes", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!DatasetImageNative.jni_IsMultiBand(this.getHandle())) {
            String string = InternalResource.loadString("dataset", "DatasetImage_TheArgumentMustBeMultibandsData", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Integer n = _$3;
        synchronized (n) {
            int n2 = nArray.length;
            int n3 = datasetImage.getBandCount();
            for (int i = 0; i < n2; ++i) {
                if (0 <= nArray[i] && n3 > nArray[i]) continue;
                String string = InternalResource.loadString("indexes", "Global_IndexOutOfBounds", "data_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetImageNative.jni_addBandIndexs(this.getHandle(), l, nArray);
            return nArray.length;
        }
    }

    public String get(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Get(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getBandCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return DatasetImageNative.jni_getItem(this.getHandle(), n);
    }

    public void set(int n, String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("Set(int index, String value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string3 = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (n < 0 || n >= this.getBandCount()) {
            String string4 = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            String string5 = InternalResource.loadString("value", "DatasetImage_BandNameIsNotValid", "data_resources");
            throw new IllegalStateException(string5);
        }
        boolean bl = DatasetImageNative.jni_isContain(this.getHandle(), string);
        if (bl) {
            String string6 = InternalResource.loadString("value", "DatasetImage_BandNameIsNotValid", "data_resources");
            throw new IllegalStateException(string6);
        }
        DatasetImageNative.jni_setItem(this.getHandle(), n, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteBand(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("deleteBand(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!DatasetImageNative.jni_IsMultiBand(this.getHandle())) {
            String string = InternalResource.loadString("deleteBand(int index)", "DatasetImage_ThisOperationIsAvailableForMultibandsDataOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        Integer n2 = _$3;
        synchronized (n2) {
            if (n < 0 || n >= this.getBandCount()) {
                String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
                throw new IndexOutOfBoundsException(string);
            }
            return DatasetImageNative.jni_deleteBand(this.getHandle(), n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteBand(int n, int n2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("deleteBand(int startIndex, int count)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!DatasetImageNative.jni_IsMultiBand(this.getHandle())) {
            String string = InternalResource.loadString("deleteBand(int startIndex, int count)", "DatasetImage_ThisOperationIsAvailableForMultibandsDataOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        Integer n3 = _$3;
        synchronized (n3) {
            if (n < 0 || n >= this.getBandCount()) {
                String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
                throw new IndexOutOfBoundsException(string);
            }
            if (n + n2 < n || n + n2 > this.getBandCount()) {
                String string = InternalResource.loadString("satrtIndex\ufffd\ufffdcount", "DatasetImage_InvalidCount", "data_resources");
                throw new IndexOutOfBoundsException(string);
            }
            return DatasetImageNative.jni_deleteBands(this.getHandle(), n, n2);
        }
    }

    public int indexOf(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("IndexOf(String bandName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string3 = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("value", "DatasetImage_BandNameIsNotValid", "data_resources");
            throw new IllegalStateException(string4);
        }
        return DatasetImageNative.jni_indexOf(this.getHandle(), string);
    }

    public boolean update(DatasetImage datasetImage) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IndexOf(String bandName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (datasetImage.getHandle() == 0L) {
            String string = InternalResource.loadString("IndexOf(String bandName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageNative.jni_Update(this.getHandle(), datasetImage.getHandle());
    }

    @Override
    protected void clearHandle() {
        if (this._$4 != null) {
            this._$4.clearHandle();
            this._$4 = null;
        }
        this.setHandle(0L);
    }
}

