/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.CodeDomainNative;
import com.supermap.data.CodeInfo;
import com.supermap.data.Domain;
import com.supermap.data.FieldType;
import com.supermap.data.InternalResource;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeDomain
extends Domain {
    CodeDomain(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(l);
    }

    protected CodeDomain() {
        this.setHandle(CodeDomainNative.jni_New());
    }

    public CodeDomain(int n, String string, String string2, FieldType fieldType) {
        long l = CodeDomainNative.jni_New3(n, string, string2, fieldType.value());
        if (l == 0L) {
            String string3 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        this.setHandle(l);
    }

    public CodeDomain(int n, String string, String string2, FieldType fieldType, ArrayList<CodeInfo> arrayList) {
        long[] lArray = new long[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get(i).getHandle() == 0L) {
                String string3 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string3);
            }
            lArray[i] = arrayList.get(i).getHandle();
        }
        long l = CodeDomainNative.jni_New2(n, string, string2, fieldType.value(), lArray);
        if (l == 0L) {
            String string4 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string4);
        }
        this.setHandle(l);
    }

    public int getCodeCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getCodeInfos().length;
    }

    public CodeInfo[] getCodeInfos() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = CodeDomainNative.jni_GetCodeInfos(this.getHandle());
        CodeInfo[] codeInfoArray = new CodeInfo[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            codeInfoArray[i] = new CodeInfo(lArray[i]);
        }
        return codeInfoArray;
    }

    public CodeInfo get(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCodeCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        long l = CodeDomainNative.jni_Get(this.getHandle(), n);
        CodeInfo codeInfo = new CodeInfo(l);
        return codeInfo;
    }

    public boolean add(CodeInfo codeInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (null == codeInfo) {
            return false;
        }
        if (codeInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return CodeDomainNative.jni_Add(this.getHandle(), codeInfo.getHandle());
    }

    public void append(CodeInfo[] codeInfoArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (null == codeInfoArray) {
            return;
        }
        long[] lArray = new long[codeInfoArray.length];
        for (int i = 0; i < codeInfoArray.length; ++i) {
            if (codeInfoArray[i].getHandle() == 0L) {
                String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            lArray[i] = codeInfoArray[i].getHandle();
        }
        CodeDomainNative.jni_Append(this.getHandle(), lArray);
    }

    public boolean set(int n, CodeInfo codeInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (null == codeInfo) {
            return false;
        }
        if (n < 0 || n >= this.getCodeCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (codeInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return CodeDomainNative.jni_Set(this.getHandle(), n, codeInfo.getHandle());
    }

    public void remove(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCodeCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        CodeDomainNative.jni_Remove(this.getHandle(), n);
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        CodeDomainNative.jni_RemoveAll(this.getHandle());
    }
}

