/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.InternalHandle;
import com.supermap.data.SpatialIndexInfo;
import com.supermap.data.conversion.DataType;
import com.supermap.data.conversion.ImportSetting;
import com.supermap.data.conversion.ImportSettingDWGNative;
import com.supermap.data.conversion.ImportSettingDXFNative;
import com.supermap.data.conversion.InternalHandleDisposable;
import com.supermap.data.conversion.InternalResource;
import com.supermap.data.conversion.InternalSpatialIndexInfo;
import java.io.File;

public class ImportSettingDXF
extends ImportSetting {
    public ImportSettingDXF() {
        long l = ImportSettingDXFNative.jni_New();
        this.setHandle(l, true);
        super.setDataType(DataType.VECTOR);
    }

    public ImportSettingDXF(ImportSettingDXF importSettingDXF) {
        if (importSettingDXF == null) {
            String string = InternalResource.loadString("ImportSettingDXF", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)importSettingDXF);
        if (l == 0L) {
            String string = InternalResource.loadString("ImportSettingDXF", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ImportSettingDXFNative.jni_Clone(l);
        this.setHandle(l2, true);
        this.setTargetDatasourceConnectionInfo(importSettingDXF.getTargetDatasourceConnectionInfo());
        this.setTargetDatasource(importSettingDXF.getTargetDatasource());
        this.setTargetPrjCoordSys(importSettingDXF.getTargetPrjCoordSys());
        super.setDataType(DataType.VECTOR);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)importSettingDXF));
    }

    public ImportSettingDXF(String string, DatasourceConnectionInfo datasourceConnectionInfo) {
        this();
        this.setSourceFilePath(string);
        this.setTargetDatasourceConnectionInfo(datasourceConnectionInfo);
        super.setDataType(DataType.VECTOR);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)datasourceConnectionInfo);
    }

    public ImportSettingDXF(String string, Datasource datasource) {
        this();
        this.setSourceFilePath(string);
        this.setTargetDatasource(datasource);
        super.setDataType(DataType.VECTOR);
    }

    public ImportSettingDXF(String string, DatasourceConnectionInfo datasourceConnectionInfo, boolean bl) {
        this();
        this.setSourceFilePath(string);
        this.setTargetDatasourceConnectionInfo(datasourceConnectionInfo);
        this.setImportingAsCAD(bl);
        super.setDataType(DataType.VECTOR);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)datasourceConnectionInfo);
    }

    public boolean isImportingAsCAD() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isImportingAsCAD()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingDXFNative.jni_IsImportingAsCAD(this.getHandle());
    }

    public void setImportingAsCAD(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingAsCAD(boolean value)", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDXFNative.jni_SetImportingAsCAD(this.getHandle(), bl);
    }

    public SpatialIndexInfo getSpatialIndex() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSpatialIndex()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ImportSettingDXFNative.jni_GetSpatialIndex(this.getHandle());
        return InternalSpatialIndexInfo.createInstance(l);
    }

    public void setSpatialIndex(SpatialIndexInfo spatialIndexInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSpatialIndex(SpatialIndex value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDXFNative.jni_SetSpatialIndex(this.getHandle(), com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)spatialIndexInfo));
        InternalHandleDisposable.makeSureNativeObjectLive((Object)spatialIndexInfo);
    }

    @Deprecated
    public SpatialIndexInfo getSpatialIndexType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSpatialIndexType()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ImportSettingDXFNative.jni_GetSpatialIndex(this.getHandle());
        return InternalSpatialIndexInfo.createInstance(l);
    }

    @Deprecated
    public void setSpatialIndexType(SpatialIndexInfo spatialIndexInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSpatialIndexType(SpatialIndexType value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDXFNative.jni_SetSpatialIndex(this.getHandle(), com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)spatialIndexInfo));
    }

    public boolean isImportingBlockAsPoint() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isImportingSymbolBlockAsPoint()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingDXFNative.jni_IsImportingBlockAsPoint(this.getHandle());
    }

    public void setImportingBlockAsPoint(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingSymbolBlockAsPoint(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDXFNative.jni_SetImportingBlockAsPoint(this.getHandle(), bl);
    }

    public boolean isLWPLineWidthIgnored() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IsLWPLineWidthIgnored()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingDXFNative.jni_IsLWPLineWidthIgnored(this.getHandle());
    }

    public void setLWPLineWidthIgnored(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsLWPLineWidthIgnored(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDXFNative.jni_SetIsLWPLineWidthIgnored(this.getHandle(), bl);
    }

    public boolean isBlockAttributeIgnored() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IsLWPLineWidthIgnored()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingDWGNative.jni_IsBlockAttributeIgnored(this.getHandle());
    }

    public void setBlockAttributeIgnored(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsLWPLineWidthIgnored(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDWGNative.jni_SetIsBlockAttributeIgnored(this.getHandle(), bl);
    }

    @Deprecated
    public void setIsLWPLineWidthIgnored(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsLWPLineWidthIgnored(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDXFNative.jni_SetIsLWPLineWidthIgnored(this.getHandle(), bl);
    }

    public int getCurveSegment() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCurveSegment()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingDXFNative.jni_GetCurveSegment(this.getHandle());
    }

    public void setCurveSegment(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCurveSegment(int value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDXFNative.jni_SetCurveSegment(this.getHandle(), n);
    }

    public boolean isImportingExternalData() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isImportingExternalData()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingDXFNative.jni_IsImportingExternalData(this.getHandle());
    }

    public void setImportingExternalData(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingExternalData(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDXFNative.jni_SetImportingExternalData(this.getHandle(), bl);
    }

    public boolean isImportingXRecord() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isIgnoredXRecord()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingDXFNative.jni_IsImportingXRecord(this.getHandle());
    }

    public void setImportingXRecord(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIgnoredXRecord(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDXFNative.jni_SetImportingXRecord(this.getHandle(), bl);
    }

    public boolean isImportingByLayer() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isImportingByLayer()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingDXFNative.jni_IsImportingByLayer(this.getHandle());
    }

    public void setImportingByLayer(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingByLayer(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDXFNative.jni_SetImportingByLayer(this.getHandle(), bl);
    }

    public boolean isImportingInvisibleLayer() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isImportingInvisibleLayer()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingDXFNative.jni_IsImportingInvisibleLayer(this.getHandle());
    }

    public void setImportingInvisibleLayer(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingInvisibleLayer(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDXFNative.jni_SetImportingInvisibleLayer(this.getHandle(), bl);
    }

    public boolean isImporttingAs3D() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isImporttingAs3D()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingDXFNative.jni_IsImportingAs3D(this.getHandle());
    }

    public void setImporttingAs3D(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImporttingAs3D()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDXFNative.jni_SetImportingAs3D(this.getHandle(), bl);
    }

    public boolean isKeepingParametricPart() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IsKeepingParametricPart()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingDXFNative.jni_IsKeepingParametricPart(this.getHandle());
    }

    public void setKeepingParametricPart(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetKeepingParametricPart()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDXFNative.jni_SetKeepingParametricPart(this.getHandle(), bl);
    }

    public String getStyleMappingTableFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStyleMapFilePath()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return ImportSettingDXFNative.jni_GetStyleMapFilePath(this.getHandle());
    }

    public void setStyleMappingTableFile(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setStyleMapFilePath(String path)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("path", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string3);
        }
        File file = new File(string);
        if (!file.exists()) {
            String string4 = InternalResource.loadString(file.getAbsolutePath(), "Global_PathIsNotValid", "conversion_resources");
            throw new IllegalArgumentException(string4);
        }
        ImportSettingDXFNative.jni_SetStyleMapFilePath(this.getHandle(), string);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ImportSettingDXFNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        super.clearHandle();
    }

    public void setImportEmptyDataset(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportEmptyDataset()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDXFNative.jni_SetImportEmptyDT(this.getHandle(), bl);
    }

    public boolean isImportEmptyDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImportEmptyDataset()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingDXFNative.jni_IsImportEmptyDT(this.getHandle());
    }
}

