/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalHandleDisposable;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.SolarRadiationNative;
import com.supermap.analyst.spatialanalyst.SolarRadiationParameter;
import com.supermap.analyst.spatialanalyst.SolarRadiationResult;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.Datasource;
import com.supermap.data.License;
import com.supermap.data.ProductType;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Vector;

public class SolarRadiation {
    private static License _$2;
    private static transient Vector _$1;

    private SolarRadiation() {
    }

    public static SolarRadiationResult areaSolarRadiation(DatasetGrid datasetGrid, SolarRadiationParameter solarRadiationParameter, Datasource datasource, String string, String string2, String string3, String string4) {
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string5 = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string5);
        }
        if (solarRadiationParameter == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)solarRadiationParameter) == 0L) {
            String string6 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string6);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string7 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string7);
        }
        if (string == null) {
            String string8 = InternalResource.loadString("totalGridName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string8);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string9 = InternalResource.loadString("totalGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string9);
        }
        if (string2 != null && !string2.isEmpty() && !datasource.getDatasets().isAvailableDatasetName(string2)) {
            String string10 = InternalResource.loadString("directGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string10);
        }
        if (string3 != null && !string3.isEmpty() && !datasource.getDatasets().isAvailableDatasetName(string3)) {
            String string11 = InternalResource.loadString("diffuseGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string11);
        }
        if (string4 != null && !string4.isEmpty() && !datasource.getDatasets().isAvailableDatasetName(string4)) {
            String string12 = InternalResource.loadString("durationGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string12);
        }
        if (solarRadiationParameter.getHourStart() > solarRadiationParameter.getHourEnd()) {
            String string13 = InternalResource.loadString("parameter", "StartHourCannotGreaterThanEndHour", "spatialanalyst_resources");
            throw new IllegalArgumentException(string13);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)solarRadiationParameter);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long[] lArray = SolarRadiationNative.jni_AreaSolarRadiation(l2, l, l3, string, string2, string3, string4);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)solarRadiationParameter));
        SolarRadiationResult solarRadiationResult = null;
        if (lArray != null && lArray.length == 4 && lArray[0] != 0L) {
            DatasetGrid datasetGrid2 = InternalDatasetGrid.createInstance(lArray[0], datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid2);
            DatasetGrid datasetGrid3 = null;
            if (lArray[1] != 0L) {
                datasetGrid3 = InternalDatasetGrid.createInstance(lArray[1], datasource);
                InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid3);
            }
            DatasetGrid datasetGrid4 = null;
            if (lArray[2] != 0L) {
                datasetGrid4 = InternalDatasetGrid.createInstance(lArray[2], datasource);
                InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid4);
            }
            DatasetGrid datasetGrid5 = null;
            if (lArray[3] != 0L) {
                datasetGrid5 = InternalDatasetGrid.createInstance(lArray[3], datasource);
                InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid5);
            }
            solarRadiationResult = new SolarRadiationResult(datasetGrid2, datasetGrid3, datasetGrid4, datasetGrid5);
        }
        return solarRadiationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _$1() {
        int n = -1;
        Object object = _$2;
        synchronized (object) {
            n = _$2.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener steppedListener) {
        if (_$1 == null) {
            _$1 = new Vector();
        }
        if (!_$1.contains(steppedListener)) {
            _$1.add(steppedListener);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener steppedListener) {
        if (_$1 != null && _$1.contains(steppedListener)) {
            _$1.remove(steppedListener);
        }
    }

    protected static void fireStepped(SteppedEvent steppedEvent) {
        if (_$1 != null) {
            Vector vector = _$1;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(steppedEvent);
            }
        }
    }

    static void steppedCallBack(int n, long l, String string, String string2, long l2) {
        String string3 = "SolarRadiation";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(l2);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, n, l, string, string2, string3);
        SolarRadiation.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(l2, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        _$2 = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

