/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.CalibrateOptions;
import com.supermap.analyst.spatialanalyst.EventDissolveType;
import com.supermap.analyst.spatialanalyst.EventOverlayType;
import com.supermap.analyst.spatialanalyst.GenerateEventTableParameter;
import com.supermap.analyst.spatialanalyst.GenerateRoutesParameter;
import com.supermap.analyst.spatialanalyst.GenerateSpatialDataParameter;
import com.supermap.analyst.spatialanalyst.GenerateType;
import com.supermap.analyst.spatialanalyst.InternalDatasetVector;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.LinearReferencingNative;
import com.supermap.analyst.spatialanalyst.RouteEventsParameter;
import com.supermap.analyst.spatialanalyst.StatisticsType;
import com.supermap.data.CalibrateMode;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.DynamicSegmentInfo;
import com.supermap.data.DynamicSegmentManager;
import com.supermap.data.FieldType;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.Vector;

public class LinearReferencing {
    private static transient Vector _$1;

    private LinearReferencing() {
    }

    public static DatasetVector generateRoutes(DatasetVector datasetVector, GenerateRoutesParameter generateRoutesParameter) {
        String string;
        if (datasetVector == null) {
            String string2 = InternalResource.loadString("referenceLine", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (generateRoutesParameter == null) {
            String string3 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        Datasource datasource = null;
        datasource = generateRoutesParameter.getOutputDatasource() != null ? generateRoutesParameter.getOutputDatasource() : datasetVector.getDatasource();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        String string4 = generateRoutesParameter.getOutputDatasetName();
        if (!datasource.getDatasets().isAvailableDatasetName(string4)) {
            String string5 = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        double d = generateRoutesParameter.getMeasureOffset();
        double d2 = generateRoutesParameter.getRatio();
        boolean bl = generateRoutesParameter.getIgnoringGaps();
        boolean bl2 = LinearReferencing._$1();
        GenerateType generateType = generateRoutesParameter.getType();
        long l3 = 0L;
        if (generateType == GenerateType.BY_LENGTH) {
            l3 = LinearReferencingNative.jni_GenerateRoutesByLength(l2, l, string4, d, d2, bl, bl2);
        } else if (generateType == GenerateType.BY_SINGLE_FIELD) {
            string = generateRoutesParameter.getMeasureEndField();
            if (datasetVector.getFieldInfos().indexOf(string) == -1) {
                String string6 = InternalResource.loadString("measureEndField", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string6);
            }
            if (datasetVector.getFieldInfos().get(string).getType() == FieldType.BOOLEAN || datasetVector.getFieldInfos().get(string).getType() == FieldType.BYTE || datasetVector.getFieldInfos().get(string).getType() == FieldType.DATETIME || datasetVector.getFieldInfos().get(string).getType() == FieldType.LONGBINARY) {
                String string7 = InternalResource.loadString("measureEndField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string7);
            }
            l3 = LinearReferencingNative.jni_GenerateRoutesByField(l2, l, string4, string, null, d, d2, bl, bl2);
        } else if (generateType == GenerateType.BY_DOUBLE_FIELDS) {
            string = generateRoutesParameter.getMeasureStartField();
            String string8 = generateRoutesParameter.getMeasureEndField();
            if (datasetVector.getFieldInfos().indexOf(string) == -1) {
                String string9 = InternalResource.loadString("measureStartField", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string9);
            }
            if (datasetVector.getFieldInfos().indexOf(string8) == -1) {
                String string10 = InternalResource.loadString("measureEndField", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string10);
            }
            if (datasetVector.getFieldInfos().get(string).getType() == FieldType.BOOLEAN || datasetVector.getFieldInfos().get(string).getType() == FieldType.BYTE || datasetVector.getFieldInfos().get(string).getType() == FieldType.DATETIME || datasetVector.getFieldInfos().get(string).getType() == FieldType.LONGBINARY) {
                String string11 = InternalResource.loadString("measureStartField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string11);
            }
            if (datasetVector.getFieldInfos().get(string8).getType() == FieldType.BOOLEAN || datasetVector.getFieldInfos().get(string8).getType() == FieldType.BYTE || datasetVector.getFieldInfos().get(string8).getType() == FieldType.DATETIME || datasetVector.getFieldInfos().get(string8).getType() == FieldType.LONGBINARY) {
                String string12 = InternalResource.loadString("measureEndField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string12);
            }
            l3 = LinearReferencingNative.jni_GenerateRoutesByField(l2, l, string4, string, string8, d, d2, bl, bl2);
        } else if (generateType == GenerateType.BY_POINT) {
            string = generateRoutesParameter.getDatasetPoint();
            if (string == null) {
                String string13 = InternalResource.loadString("referencePoint", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string13);
            }
            String string14 = generateRoutesParameter.getMeasureField();
            if (string.getFieldInfos().indexOf(string14) == -1) {
                String string15 = InternalResource.loadString("measureField", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string15);
            }
            if (string.getFieldInfos().get(string14).getType() == FieldType.BOOLEAN || string.getFieldInfos().get(string14).getType() == FieldType.BYTE || string.getFieldInfos().get(string14).getType() == FieldType.DATETIME || string.getFieldInfos().get(string14).getType() == FieldType.LONGBINARY) {
                String string16 = InternalResource.loadString("measureField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string16);
            }
            String string17 = generateRoutesParameter.getLineRouteIDField();
            if (datasetVector.getFieldInfos().indexOf(string17) == -1) {
                String string18 = InternalResource.loadString("strFieldRoadRouteID", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string18);
            }
            if (datasetVector.getFieldInfos().get(string17).getType() == FieldType.BOOLEAN || datasetVector.getFieldInfos().get(string17).getType() == FieldType.BYTE || datasetVector.getFieldInfos().get(string17).getType() == FieldType.DATETIME || datasetVector.getFieldInfos().get(string17).getType() == FieldType.LONGBINARY || datasetVector.getFieldInfos().get(string17).getType() == FieldType.DOUBLE || datasetVector.getFieldInfos().get(string17).getType() == FieldType.SINGLE) {
                String string19 = InternalResource.loadString("strFieldRoadRouteID", "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string19);
            }
            String string20 = generateRoutesParameter.getPointRouteIDField();
            if (string.getFieldInfos().indexOf(string20) == -1) {
                String string21 = InternalResource.loadString("strFieldPointRouteID", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string21);
            }
            if (string.getFieldInfos().get(string20).getType() == FieldType.BOOLEAN || string.getFieldInfos().get(string20).getType() == FieldType.BYTE || string.getFieldInfos().get(string20).getType() == FieldType.DATETIME || string.getFieldInfos().get(string20).getType() == FieldType.LONGBINARY || string.getFieldInfos().get(string20).getType() == FieldType.DOUBLE || string.getFieldInfos().get(string20).getType() == FieldType.SINGLE) {
                String string22 = InternalResource.loadString("strFieldPointRouteID", "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string22);
            }
            long l4 = InternalHandle.getHandle((com.supermap.data.InternalHandle)string);
            String string23 = generateRoutesParameter.getErrorInfoField();
            double d3 = generateRoutesParameter.getTolerance();
            l3 = LinearReferencingNative.jni_GenerateRoutesByPoint(l2, string17, l4, string20, string14, string23, l, string4, d, d2, bl, d3, bl2);
            string.close();
            string.open();
        }
        string = null;
        if (l3 != 0L) {
            string = InternalDatasetVector.createInstance(l3, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)string);
        }
        return string;
    }

    public static DatasetVector calibrateRoutes(DatasetVector datasetVector, String string, DatasetVector datasetVector2, String string2, String string3, CalibrateOptions calibrateOptions, Datasource datasource, String string4) {
        if (datasetVector == null) {
            String string5 = InternalResource.loadString("referenceLineM", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string5);
        }
        if (datasetVector2 == null) {
            String string6 = InternalResource.loadString("calibratePointDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string6);
        }
        if (datasetVector.getFieldInfos().indexOf(string) == -1) {
            String string7 = InternalResource.loadString("routeIDField", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        if (datasetVector.getFieldInfos().get(string).getType() == FieldType.BOOLEAN || datasetVector.getFieldInfos().get(string).getType() == FieldType.BYTE || datasetVector.getFieldInfos().get(string).getType() == FieldType.DATETIME || datasetVector.getFieldInfos().get(string).getType() == FieldType.LONGBINARY || datasetVector.getFieldInfos().get(string).getType() == FieldType.DOUBLE || datasetVector.getFieldInfos().get(string).getType() == FieldType.SINGLE) {
            String string8 = InternalResource.loadString("routeIDField", "FieldInfos_Unsupported", "spatialanalyst_resources");
            throw new IllegalArgumentException(string8);
        }
        if (datasetVector2.getFieldInfos().indexOf(string2) == -1) {
            String string9 = InternalResource.loadString("calibrateRouteID", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
            throw new IllegalArgumentException(string9);
        }
        if (datasetVector2.getFieldInfos().get(string2).getType() == FieldType.BOOLEAN || datasetVector2.getFieldInfos().get(string2).getType() == FieldType.BYTE || datasetVector2.getFieldInfos().get(string2).getType() == FieldType.DATETIME || datasetVector2.getFieldInfos().get(string2).getType() == FieldType.LONGBINARY || datasetVector2.getFieldInfos().get(string2).getType() == FieldType.DOUBLE || datasetVector2.getFieldInfos().get(string2).getType() == FieldType.SINGLE) {
            String string10 = InternalResource.loadString("calibrateRouteID", "FieldInfos_Unsupported", "spatialanalyst_resources");
            throw new IllegalArgumentException(string10);
        }
        if (datasetVector2.getFieldInfos().indexOf(string3) == -1) {
            String string11 = InternalResource.loadString("measureField", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
            throw new IllegalArgumentException(string11);
        }
        if (datasetVector2.getFieldInfos().get(string3).getType() == FieldType.BOOLEAN || datasetVector2.getFieldInfos().get(string3).getType() == FieldType.BYTE || datasetVector2.getFieldInfos().get(string3).getType() == FieldType.DATETIME || datasetVector2.getFieldInfos().get(string3).getType() == FieldType.LONGBINARY) {
            String string12 = InternalResource.loadString("measureField", "FieldInfos_Unsupported", "spatialanalyst_resources");
            throw new IllegalArgumentException(string12);
        }
        if (datasource == null) {
            datasource = datasetVector.getDatasource();
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string4)) {
            String string13 = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string13);
        }
        CalibrateMode calibrateMode = calibrateOptions.getRouteCalibrationMode();
        int n = calibrateMode.value();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector2);
        if (datasource == null) {
            datasource = datasetVector.getDatasource();
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        double d = calibrateOptions.getTolerance();
        boolean bl = calibrateOptions.getRetainingAllRoutes();
        String string14 = calibrateOptions.getErrorInfoField();
        boolean bl2 = calibrateOptions.getIgnoringGaps();
        boolean bl3 = LinearReferencing._$1();
        if (calibrateOptions.getToleranceUnit() != null) {
            d = d * (double)calibrateOptions.getToleranceUnit().value() / (double)datasetVector.getPrjCoordSys().getCoordUnit().value();
        }
        long l4 = LinearReferencingNative.jni_CalibrateRoutes(l, string, l2, string2, string3, l3, string4, d, n, bl, true, true, true, string14, bl2, bl3);
        datasetVector2.close();
        datasetVector2.open();
        DatasetVector datasetVector3 = null;
        if (l4 != 0L) {
            datasetVector3 = InternalDatasetVector.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector3);
        }
        return datasetVector3;
    }

    public static DatasetVector generateEventTable(DatasetVector datasetVector, GenerateEventTableParameter generateEventTableParameter) {
        if (datasetVector == null) {
            String string = InternalResource.loadString("referenceLineM", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (generateEventTableParameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (datasetVector.getFieldInfos().indexOf(generateEventTableParameter.getRouteIDField()) == -1) {
            String string = InternalResource.loadString("routeIDField", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector.getFieldInfos().get(generateEventTableParameter.getRouteIDField()).getType() == FieldType.BOOLEAN || datasetVector.getFieldInfos().get(generateEventTableParameter.getRouteIDField()).getType() == FieldType.BYTE || datasetVector.getFieldInfos().get(generateEventTableParameter.getRouteIDField()).getType() == FieldType.DATETIME || datasetVector.getFieldInfos().get(generateEventTableParameter.getRouteIDField()).getType() == FieldType.LONGBINARY || datasetVector.getFieldInfos().get(generateEventTableParameter.getRouteIDField()).getType() == FieldType.DOUBLE || datasetVector.getFieldInfos().get(generateEventTableParameter.getRouteIDField()).getType() == FieldType.SINGLE) {
            String string = InternalResource.loadString("routeIDField", "FieldInfos_Unsupported", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        Datasource datasource = null;
        datasource = generateEventTableParameter.getOutputDatasource() != null ? generateEventTableParameter.getOutputDatasource() : datasetVector.getDatasource();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)generateEventTableParameter.getEventDataset());
        String string = generateEventTableParameter.getOutputDatasetName();
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string2 = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        String string3 = generateEventTableParameter.getOutputDatasetRouteField();
        String string4 = generateEventTableParameter.getMeasureStartField();
        String string5 = generateEventTableParameter.getMeasureEndField();
        String string6 = generateEventTableParameter.getMeasureField();
        String string7 = generateEventTableParameter.getRouteIDField();
        boolean bl = generateEventTableParameter.getRetainingAllFields();
        double d = generateEventTableParameter.getSearchRadius();
        boolean bl2 = generateEventTableParameter.hasDistanceField();
        boolean bl3 = generateEventTableParameter.getFindingClosestRoute();
        boolean bl4 = LinearReferencing._$1();
        int n = 0;
        if (generateEventTableParameter.getEventDataset().getType() == DatasetType.POINT) {
            n = 1;
        } else if (generateEventTableParameter.getEventDataset().getType() == DatasetType.LINE) {
            n = 2;
        }
        d = d * (double)generateEventTableParameter.getSearchRadiusUnit().value() / (double)datasetVector.getPrjCoordSys().getCoordUnit().value();
        if (n == 1) {
            // empty if block
        }
        if (n == 2) {
            // empty if block
        }
        long l4 = LinearReferencingNative.jni_GenerateEventTable(l, string7, l3, l2, string, n, string3, string4, string5, string6, bl, d, bl2, bl3, bl4);
        DatasetVector datasetVector2 = null;
        if (l4 != 0L) {
            datasetVector2 = InternalDatasetVector.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector2);
        }
        return datasetVector2;
    }

    public static DatasetVector generateSpatialData(GenerateSpatialDataParameter generateSpatialDataParameter) {
        if (generateSpatialDataParameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (generateSpatialDataParameter.getReferenceLineM() == null) {
            String string = InternalResource.loadString("referenceLineM", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        String string = generateSpatialDataParameter.getRouteIDField();
        if (generateSpatialDataParameter.getReferenceLineM().getFieldInfos().indexOf(string) == -1) {
            String string2 = InternalResource.loadString("RouteIDField", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        if (generateSpatialDataParameter.getReferenceLineM().getFieldInfos().get(string).getType() == FieldType.BOOLEAN || generateSpatialDataParameter.getReferenceLineM().getFieldInfos().get(string).getType() == FieldType.BYTE || generateSpatialDataParameter.getReferenceLineM().getFieldInfos().get(string).getType() == FieldType.DATETIME || generateSpatialDataParameter.getReferenceLineM().getFieldInfos().get(string).getType() == FieldType.LONGBINARY || generateSpatialDataParameter.getReferenceLineM().getFieldInfos().get(string).getType() == FieldType.DOUBLE || generateSpatialDataParameter.getReferenceLineM().getFieldInfos().get(string).getType() == FieldType.SINGLE) {
            String string3 = InternalResource.loadString("routeIDField", "FieldInfos_Unsupported", "spatialanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)generateSpatialDataParameter.getReferenceLineM());
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)generateSpatialDataParameter.getEventTable());
        if (generateSpatialDataParameter.getReferenceLineM().getDatasource() != generateSpatialDataParameter.getEventTable().getDatasource()) {
            String string4 = InternalResource.loadString("ReferenceLineM and EventTable", "Datasource_MustBe_Same", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        DynamicSegmentInfo[] dynamicSegmentInfoArray = DynamicSegmentManager.getDynamicSegmentInfos((DatasetVector)generateSpatialDataParameter.getEventTable());
        if (dynamicSegmentInfoArray != null) {
            String string5 = InternalResource.loadString("EventTable", "Relation_Has_Exist", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        String string6 = generateSpatialDataParameter.getErrorInfoField();
        Datasource datasource = null;
        datasource = generateSpatialDataParameter.getReferenceLineM().getDatasource();
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        String string7 = generateSpatialDataParameter.getOutputDatasetName();
        if (!datasource.getDatasets().isAvailableDatasetName(string7)) {
            String string8 = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string8);
        }
        String string9 = generateSpatialDataParameter.getEventRouteIDField();
        String string10 = generateSpatialDataParameter.getMeasureStartField();
        String string11 = generateSpatialDataParameter.getMeasureEndField();
        String string12 = generateSpatialDataParameter.getMeasureField();
        String string13 = generateSpatialDataParameter.getMeasureOffsetField();
        if (string13 != null && string13 != "" && (generateSpatialDataParameter.getEventTable().getFieldInfos().get(string13).getType() == FieldType.BOOLEAN || generateSpatialDataParameter.getEventTable().getFieldInfos().get(string13).getType() == FieldType.BYTE || generateSpatialDataParameter.getEventTable().getFieldInfos().get(string13).getType() == FieldType.DATETIME || generateSpatialDataParameter.getEventTable().getFieldInfos().get(string13).getType() == FieldType.LONGBINARY)) {
            String string14 = InternalResource.loadString("MeasureOffsetField", "FieldInfos_Unsupported", "spatialanalyst_resources");
            throw new IllegalArgumentException(string14);
        }
        boolean bl = true;
        if (string12 == null) {
            if (string10 == null || string11 == null) {
                String string15 = InternalResource.loadString("MeasureStartField or measureEndField", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string15);
            }
            if (generateSpatialDataParameter.getEventTable().getFieldInfos().get(string10).getType() == FieldType.BOOLEAN || generateSpatialDataParameter.getEventTable().getFieldInfos().get(string10).getType() == FieldType.BYTE || generateSpatialDataParameter.getEventTable().getFieldInfos().get(string10).getType() == FieldType.DATETIME || generateSpatialDataParameter.getEventTable().getFieldInfos().get(string10).getType() == FieldType.LONGBINARY) {
                String string16 = InternalResource.loadString("MeasureStartField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string16);
            }
            if (generateSpatialDataParameter.getEventTable().getFieldInfos().get(string11).getType() == FieldType.BOOLEAN || generateSpatialDataParameter.getEventTable().getFieldInfos().get(string11).getType() == FieldType.BYTE || generateSpatialDataParameter.getEventTable().getFieldInfos().get(string11).getType() == FieldType.DATETIME || generateSpatialDataParameter.getEventTable().getFieldInfos().get(string11).getType() == FieldType.LONGBINARY) {
                String string17 = InternalResource.loadString("MeasureEndField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string17);
            }
            bl = false;
        } else {
            if (generateSpatialDataParameter.getEventTable().getFieldInfos().get(string12).getType() == FieldType.BOOLEAN || generateSpatialDataParameter.getEventTable().getFieldInfos().get(string12).getType() == FieldType.BYTE || generateSpatialDataParameter.getEventTable().getFieldInfos().get(string12).getType() == FieldType.DATETIME || generateSpatialDataParameter.getEventTable().getFieldInfos().get(string12).getType() == FieldType.LONGBINARY) {
                String string18 = InternalResource.loadString("MeasureField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string18);
            }
            bl = true;
        }
        String[] stringArray = generateSpatialDataParameter.getRetainedFields();
        boolean bl2 = LinearReferencing._$1();
        long l4 = LinearReferencingNative.jni_GenerateSpatialData(l, l2, string6, l3, string7, string9, string10, string11, string12, string, string13, stringArray, bl2, bl);
        generateSpatialDataParameter.getEventTable().close();
        generateSpatialDataParameter.getEventTable().open();
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static DatasetVector dissolveRouteEvents(RouteEventsParameter routeEventsParameter, String[] stringArray, EventDissolveType eventDissolveType, Datasource datasource, String string, RouteEventsParameter routeEventsParameter2, String[] stringArray2, StatisticsType[] statisticsTypeArray, double d) {
        int n;
        int n2;
        if (routeEventsParameter == null) {
            String string2 = InternalResource.loadString("routeEventsParameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (routeEventsParameter.getEventDataset() == null) {
            String string3 = InternalResource.loadString("inputEventsParameter.getEventDataset()", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (datasource == null) {
            datasource = routeEventsParameter.getEventDataset().getDatasource();
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string4 = InternalResource.loadString("datasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (stringArray.length < 1) {
            String string5 = InternalResource.loadString("dissolveFields", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string5);
        }
        String[] stringArray3 = new String[4];
        String[] stringArray4 = new String[4];
        int n3 = routeEventsParameter.getType().value();
        stringArray3[0] = routeEventsParameter.getRouteIDField();
        stringArray3[1] = routeEventsParameter.getMeasureField();
        stringArray3[2] = routeEventsParameter.getMeasureStartField();
        stringArray3[3] = routeEventsParameter.getMeasureEndField();
        for (n2 = 0; n2 < 4; ++n2) {
            if (n3 == 1 && (n2 == 2 || n2 == 3) || n3 == 2 && n2 == 1) continue;
            if (stringArray3[n2] == null || stringArray3[n2].trim().length() == 0) {
                String string6 = InternalResource.loadString(stringArray3[n2], "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
                throw new IllegalArgumentException(string6);
            }
            if (routeEventsParameter.getEventDataset().getFieldInfos().indexOf(stringArray3[n2]) == -1) {
                String string7 = InternalResource.loadString(stringArray3[n2], "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string7);
            }
            if (n2 == 0) {
                if (routeEventsParameter.getEventDataset().getFieldInfos().get(stringArray3[n2]).getType() != FieldType.BOOLEAN && routeEventsParameter.getEventDataset().getFieldInfos().get(stringArray3[n2]).getType() != FieldType.BYTE && routeEventsParameter.getEventDataset().getFieldInfos().get(stringArray3[n2]).getType() != FieldType.DATETIME && routeEventsParameter.getEventDataset().getFieldInfos().get(stringArray3[n2]).getType() != FieldType.LONGBINARY && routeEventsParameter.getEventDataset().getFieldInfos().get(stringArray3[n2]).getType() != FieldType.DOUBLE && routeEventsParameter.getEventDataset().getFieldInfos().get(stringArray3[n2]).getType() != FieldType.SINGLE) continue;
                String string8 = InternalResource.loadString("routeIDField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string8);
            }
            if (routeEventsParameter.getEventDataset().getFieldInfos().get(stringArray3[n2]).getType() != FieldType.BOOLEAN && routeEventsParameter.getEventDataset().getFieldInfos().get(stringArray3[n2]).getType() != FieldType.BYTE && routeEventsParameter.getEventDataset().getFieldInfos().get(stringArray3[n2]).getType() != FieldType.DATETIME && routeEventsParameter.getEventDataset().getFieldInfos().get(stringArray3[n2]).getType() != FieldType.LONGBINARY) continue;
            String string9 = InternalResource.loadString(stringArray3[n2], "FieldInfos_Unsupported", "spatialanalyst_resources");
            throw new IllegalArgumentException(string9);
        }
        n2 = eventDissolveType.value();
        stringArray4[0] = routeEventsParameter2.getRouteIDField();
        stringArray4[1] = routeEventsParameter2.getMeasureField();
        stringArray4[2] = routeEventsParameter2.getMeasureStartField();
        stringArray4[3] = routeEventsParameter2.getMeasureEndField();
        if (stringArray4[0] == "") {
            stringArray4[0] = stringArray3[0];
        }
        if (stringArray4[1] == "") {
            stringArray4[1] = stringArray3[1];
        }
        if (stringArray4[2] == "") {
            stringArray4[2] = stringArray3[2];
        }
        if (stringArray4[3] == "") {
            stringArray4[3] = stringArray3[3];
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)routeEventsParameter.getEventDataset());
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        int n4 = statisticsTypeArray.length;
        int[] nArray = new int[n4];
        for (n = 0; n < n4; n += 1) {
            nArray[n] = statisticsTypeArray[n].value();
        }
        n = LinearReferencing._$1() ? 1 : 0;
        long l3 = LinearReferencingNative.jni_DissolveRouteEvents(l, stringArray, l2, string, stringArray3, stringArray4, stringArray2, nArray, n2, d, n3, n != 0);
        DatasetVector datasetVector = null;
        if (l3 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l3, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static DatasetVector overlayRouteEvents(RouteEventsParameter routeEventsParameter, RouteEventsParameter routeEventsParameter2, EventOverlayType eventOverlayType, Datasource datasource, String string, RouteEventsParameter routeEventsParameter3, double d, boolean bl, boolean bl2) {
        if (routeEventsParameter == null || routeEventsParameter2 == null) {
            return null;
        }
        if (routeEventsParameter.getEventDataset() == null) {
            String string2 = InternalResource.loadString("inputEventsParameter.getEventDataset()", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (routeEventsParameter2.getEventDataset() == null) {
            String string3 = InternalResource.loadString("overlayEventParameter.getEventDataset()", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (datasource == null) {
            datasource = routeEventsParameter.getEventDataset().getDatasource();
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string4 = InternalResource.loadString("datasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        String[] stringArray = new String[4];
        String[] stringArray2 = new String[4];
        String[] stringArray3 = new String[4];
        int n = 0;
        int n2 = eventOverlayType.value();
        int n3 = routeEventsParameter.getType().value();
        int n4 = routeEventsParameter2.getType().value();
        stringArray[0] = routeEventsParameter.getRouteIDField();
        stringArray[1] = routeEventsParameter.getMeasureField();
        stringArray[2] = routeEventsParameter.getMeasureStartField();
        stringArray[3] = routeEventsParameter.getMeasureEndField();
        for (n = 0; n < 4; ++n) {
            if (n3 == 1 && (n == 2 || n == 3) || n3 == 2 && n == 1) continue;
            if (stringArray[n] == null || stringArray[n].trim().length() == 0) {
                String string5 = InternalResource.loadString(stringArray[n], "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
                throw new IllegalArgumentException(string5);
            }
            if (routeEventsParameter.getEventDataset().getFieldInfos().indexOf(stringArray[n]) == -1) {
                String string6 = InternalResource.loadString(stringArray[n], "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string6);
            }
            if (n == 0) {
                if (routeEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n]).getType() != FieldType.BOOLEAN && routeEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n]).getType() != FieldType.BYTE && routeEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n]).getType() != FieldType.DATETIME && routeEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n]).getType() != FieldType.LONGBINARY && routeEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n]).getType() != FieldType.DOUBLE && routeEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n]).getType() != FieldType.SINGLE) continue;
                String string7 = InternalResource.loadString("routeIDField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string7);
            }
            if (routeEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n]).getType() != FieldType.BOOLEAN && routeEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n]).getType() != FieldType.BYTE && routeEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n]).getType() != FieldType.DATETIME && routeEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n]).getType() != FieldType.LONGBINARY) continue;
            String string8 = InternalResource.loadString(stringArray[n], "FieldInfos_Unsupported", "spatialanalyst_resources");
            throw new IllegalArgumentException(string8);
        }
        stringArray2[0] = routeEventsParameter2.getRouteIDField();
        stringArray2[1] = routeEventsParameter2.getMeasureField();
        stringArray2[2] = routeEventsParameter2.getMeasureStartField();
        stringArray2[3] = routeEventsParameter2.getMeasureEndField();
        for (n = 0; n < 4; ++n) {
            if (n4 == 1 && (n == 2 || n == 3) || n4 == 2 && n == 1) continue;
            if (stringArray2[n] == null || stringArray2[n].trim().length() == 0) {
                String string9 = InternalResource.loadString(stringArray2[n], "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
                throw new IllegalArgumentException(string9);
            }
            if (routeEventsParameter2.getEventDataset().getFieldInfos().indexOf(stringArray2[n]) == -1) {
                String string10 = InternalResource.loadString(stringArray2[n], "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string10);
            }
            if (n == 0) {
                if (routeEventsParameter2.getEventDataset().getFieldInfos().get(stringArray2[n]).getType() != FieldType.BOOLEAN && routeEventsParameter2.getEventDataset().getFieldInfos().get(stringArray2[n]).getType() != FieldType.BYTE && routeEventsParameter2.getEventDataset().getFieldInfos().get(stringArray2[n]).getType() != FieldType.DATETIME && routeEventsParameter2.getEventDataset().getFieldInfos().get(stringArray2[n]).getType() != FieldType.LONGBINARY && routeEventsParameter2.getEventDataset().getFieldInfos().get(stringArray2[n]).getType() != FieldType.DOUBLE && routeEventsParameter2.getEventDataset().getFieldInfos().get(stringArray2[n]).getType() != FieldType.SINGLE) continue;
                String string11 = InternalResource.loadString("routeIDField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string11);
            }
            if (routeEventsParameter2.getEventDataset().getFieldInfos().get(stringArray2[n]).getType() != FieldType.BOOLEAN && routeEventsParameter2.getEventDataset().getFieldInfos().get(stringArray2[n]).getType() != FieldType.BYTE && routeEventsParameter2.getEventDataset().getFieldInfos().get(stringArray2[n]).getType() != FieldType.DATETIME && routeEventsParameter2.getEventDataset().getFieldInfos().get(stringArray2[n]).getType() != FieldType.LONGBINARY) continue;
            String string12 = InternalResource.loadString(stringArray2[n], "FieldInfos_Unsupported", "spatialanalyst_resources");
            throw new IllegalArgumentException(string12);
        }
        stringArray3[0] = routeEventsParameter3.getRouteIDField();
        stringArray3[1] = routeEventsParameter3.getMeasureField();
        stringArray3[2] = routeEventsParameter3.getMeasureStartField();
        stringArray3[3] = routeEventsParameter3.getMeasureEndField();
        if (n3 == 1) {
            if (stringArray3[0] == "") {
                stringArray3[0] = stringArray2[0];
            }
            if (stringArray3[1] == "") {
                stringArray3[1] = stringArray2[1];
            }
            if (stringArray3[2] == "") {
                stringArray3[2] = stringArray2[2];
            }
            if (stringArray3[3] == "") {
                stringArray3[3] = stringArray2[3];
            }
        } else {
            if (stringArray3[0] == "") {
                stringArray3[0] = stringArray[0];
            }
            if (stringArray3[1] == "") {
                stringArray3[1] = stringArray[1];
            }
            if (stringArray3[2] == "") {
                stringArray3[2] = stringArray[2];
            }
            if (stringArray3[3] == "") {
                stringArray3[3] = stringArray[3];
            }
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)routeEventsParameter.getEventDataset());
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)routeEventsParameter2.getEventDataset());
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        boolean bl3 = LinearReferencing._$1();
        long l4 = LinearReferencingNative.jni_OverlayRouteEvents(l, l2, n2, l3, string, stringArray, stringArray2, stringArray3, d, bl, n3, n4, bl2, bl3);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static boolean rebuildSpatialData(DatasetVector datasetVector) {
        if (datasetVector == null) {
            String string = InternalResource.loadString("eventTable", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        DynamicSegmentInfo[] dynamicSegmentInfoArray = DynamicSegmentManager.getDynamicSegmentInfos((DatasetVector)datasetVector);
        if (dynamicSegmentInfoArray == null) {
            String string = InternalResource.loadString("EventTable", "Relation_Has_Not_Exist", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = LinearReferencing._$1();
        boolean bl2 = LinearReferencingNative.jni_RebuildSpatialData(l, null, bl);
        return bl2;
    }

    static boolean rebuildSpatialData(DatasetVector datasetVector, String string) {
        if (datasetVector == null) {
            String string2 = InternalResource.loadString("eventTable", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        DynamicSegmentInfo[] dynamicSegmentInfoArray = DynamicSegmentManager.getDynamicSegmentInfos((DatasetVector)datasetVector);
        if (dynamicSegmentInfoArray == null) {
            String string3 = InternalResource.loadString("EventTable", "Relation_Has_Not_Exist", "spatialanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        boolean bl = LinearReferencing._$1();
        boolean bl2 = LinearReferencingNative.jni_RebuildSpatialData(l, string, bl);
        return bl2;
    }

    public static synchronized void addSteppedListener(SteppedListener steppedListener) {
        if (_$1 == null) {
            _$1 = new Vector();
        }
        if (!_$1.contains(steppedListener)) {
            _$1.add(steppedListener);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener steppedListener) {
        if (_$1 != null && _$1.contains(steppedListener)) {
            _$1.remove(steppedListener);
        }
    }

    protected static void fireStepped(SteppedEvent steppedEvent) {
        if (_$1 != null) {
            Vector vector = _$1;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(steppedEvent);
            }
        }
    }

    static void steppedCallBack(int n, long l, String string, String string2, long l2) {
        String string3 = "LinearReferencing";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(l2);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, n, l, string, string2, string3);
        LinearReferencing.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(l2, steppedEvent.getCancel());
    }

    private static boolean _$1() {
        return _$1 != null;
    }
}

