/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.GridAnalystSetting;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalHandleDisposable;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.InterpolationAnalystNative;
import com.supermap.analyst.spatialanalyst.InterpolationParameter;
import com.supermap.data.CursorType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.Enum;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldType;
import com.supermap.data.License;
import com.supermap.data.PixelFormat;
import com.supermap.data.ProductType;
import com.supermap.data.Recordset;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.Toolkit;
import java.util.ArrayList;
import java.util.Vector;

public class Interpolator {
    private static License _$3;
    private static transient Vector _$2;
    private static GridAnalystSetting _$1;

    private Interpolator() {
        _$1 = null;
    }

    public static GridAnalystSetting getAnalystSetting() {
        return _$1;
    }

    public static void setAnalystSetting(GridAnalystSetting gridAnalystSetting) {
        if (gridAnalystSetting == null) {
            _$1 = null;
            return;
        }
        if (_$1 == null) {
            _$1 = new GridAnalystSetting();
        }
        _$1.setBounds(gridAnalystSetting.getBounds());
        _$1.setBoundsType(gridAnalystSetting.getBoundsType());
        _$1.setCellSizeType(gridAnalystSetting.getCellSizeType());
        _$1.setCellSize(gridAnalystSetting.getCellSize());
        _$1.setOutputDatasource(gridAnalystSetting.getOutputDatasource());
        _$1.setGridOutputNamePrefix(gridAnalystSetting.getGridOutputNamePrefix());
        _$1.setVectorOutputNamePrefix(gridAnalystSetting.getVectorOutputNamePrefix());
        _$1.setValidRegion(gridAnalystSetting.getValidRegion());
        _$1.setShowProgress(gridAnalystSetting.isShowProgress());
    }

    public static DatasetGrid interpolate(InterpolationParameter interpolationParameter, DatasetVector datasetVector, String string, double d, Datasource datasource, String string2, PixelFormat pixelFormat) {
        if (!datasetVector.getType().equals((Object)DatasetType.POINT)) {
            String string3 = InternalResource.loadString("interpolatedPoint", "Interpolator_UnsupportedDatasetType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        Recordset recordset = datasetVector.getRecordset(false, CursorType.STATIC);
        DatasetGrid datasetGrid = Interpolator.interpolate(interpolationParameter, recordset, string, d, datasource, string2, pixelFormat);
        recordset.dispose();
        return datasetGrid;
    }

    public static DatasetGrid interpolate(InterpolationParameter interpolationParameter, Recordset recordset, String string, double d, Datasource datasource, String string2, PixelFormat pixelFormat) {
        Interpolator._$1();
        if (recordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset) == 0L) {
            String string3 = InternalResource.loadString("interpolatedPoint", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        DatasetVector datasetVector = recordset.getDataset();
        if (!datasetVector.getType().equals((Object)DatasetType.POINT)) {
            String string4 = InternalResource.loadString("interpolatedPoint", "Interpolator_UnsupportedDatasetType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (pixelFormat.equals((Object)PixelFormat.BIT64)) {
            String string5 = InternalResource.loadString("pixelFormat", "InterPolator_UnsupportedPixelFormat", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (recordset.getFieldInfos().indexOf(string) == -1) {
            String string6 = InternalResource.loadString("zValueFieldName", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        FieldInfo fieldInfo = recordset.getFieldInfos().get(string);
        if (fieldInfo == null || fieldInfo.getType() != FieldType.DOUBLE && fieldInfo.getType() != FieldType.INT16 && fieldInfo.getType() != FieldType.INT32 && fieldInfo.getType() != FieldType.INT64 && fieldInfo.getType() != FieldType.SINGLE) {
            String string7 = InternalResource.loadString("zValueFieldName", "InterPolator_UnsupportedFieldType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            if (_$1 == null || _$1.getOutputDatasource() == null) {
                String string8 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string8);
            }
            datasource = _$1.getOutputDatasource();
        }
        if (string2 == null) {
            String string9 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string9);
        }
        if (_$1 != null && _$1.getGridOutputNamePrefix() != null) {
            string2 = _$1.getGridOutputNamePrefix() + string2;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string2)) {
            String string10 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string10);
        }
        boolean bl = interpolationParameter.getBounds().isEmpty();
        if (bl) {
            if (_$1 != null && !_$1.getBounds().isEmpty()) {
                interpolationParameter.setBounds(_$1.getBounds());
            } else {
                interpolationParameter.setBounds(datasetVector.getBounds());
            }
        }
        boolean bl2 = false;
        double d2 = interpolationParameter.getResolution();
        if (Toolkit.isZero((double)interpolationParameter.getResolution()) || interpolationParameter.getResolution() < 0.0) {
            bl2 = true;
            if (_$1 != null && !Toolkit.isZero((double)_$1.getCellSize())) {
                interpolationParameter.setResolution(_$1.getCellSize());
            } else {
                double d3 = Math.min(interpolationParameter.getBounds().getHeight(), interpolationParameter.getBounds().getWidth());
                interpolationParameter.setResolution(d3 / 500.0);
            }
        }
        boolean bl3 = false;
        if (_$1 != null) {
            bl3 = _$1.isShowProgress();
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)interpolationParameter);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long l4 = InterpolationAnalystNative.jni_Interpolate(l, l2, string, d, l3, string2, InternalEnum.getUGCValue((Enum)pixelFormat), bl3);
        if (bl) {
            interpolationParameter.setBounds(Rectangle2D.getEMPTY());
        }
        if (bl2) {
            interpolationParameter.setResolution(d2);
        }
        DatasetGrid datasetGrid = null;
        if (l4 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)interpolationParameter));
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        return datasetGrid;
    }

    public static synchronized void addSteppedListener(SteppedListener steppedListener) {
        if (_$2 == null) {
            _$2 = new Vector();
        }
        if (!_$2.contains(steppedListener)) {
            _$2.add(steppedListener);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener steppedListener) {
        if (_$2 != null && _$2.contains(steppedListener)) {
            _$2.remove(steppedListener);
        }
    }

    protected static void fireStepped(SteppedEvent steppedEvent) {
        if (_$2 != null) {
            Vector vector = _$2;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(steppedEvent);
            }
        }
    }

    static void steppedCallBack(int n, long l, String string, String string2, long l2) {
        String string3 = "Interpolate";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(l2);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, n, l, string, string2, string3);
        Interpolator.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(l2, steppedEvent.getCancel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _$1() {
        int n = -1;
        Object object = _$3;
        synchronized (object) {
            n = _$3.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        _$3 = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

