/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InterpolationAlgorithmType;
import com.supermap.analyst.spatialanalyst.InterpolationParameter;
import com.supermap.analyst.spatialanalyst.InterpolationParameterNative;
import com.supermap.analyst.spatialanalyst.SearchMode;

public class InterpolationRBFParameter
extends InterpolationParameter {
    public InterpolationRBFParameter() {
        super(InterpolationAlgorithmType.RBF);
    }

    public InterpolationRBFParameter(double d, double d2, double d3) {
        super(InterpolationAlgorithmType.RBF, d3);
        this.setTension(d);
        this.setSmooth(d2);
    }

    public InterpolationRBFParameter(double d, double d2, double d3, SearchMode searchMode, double d4, int n) {
        super(InterpolationAlgorithmType.RBF, d3, searchMode, d4, n);
        this.setTension(d);
        this.setSmooth(d2);
    }

    public double getTension() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTension()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationParameterNative.jni_GetTension(this.getHandle());
    }

    public void setTension(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTension(double value)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        InterpolationParameterNative.jni_SetTension(this.getHandle(), d);
    }

    public double getSmooth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSmooth()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationParameterNative.jni_GetSmooth(this.getHandle());
    }

    public void setSmooth(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSmooth(double value)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        InterpolationParameterNative.jni_SetSmooth(this.getHandle(), d);
    }

    public InterpolationAlgorithmType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getType()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationAlgorithmType.RBF;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(",Smooth=");
        stringBuffer.append(this.getSmooth());
        stringBuffer.append(",Tension=");
        stringBuffer.append(this.getTension());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

