/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.Exponent;
import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InterpolationAlgorithmType;
import com.supermap.analyst.spatialanalyst.InterpolationParameter;
import com.supermap.analyst.spatialanalyst.InterpolationParameterNative;
import com.supermap.analyst.spatialanalyst.SearchMode;
import com.supermap.analyst.spatialanalyst.VariogramMode;

public class InterpolationKrigingParameter
extends InterpolationParameter {
    private InterpolationAlgorithmType _$2;

    public InterpolationKrigingParameter() {
        super(InterpolationAlgorithmType.KRIGING);
        this._$2 = InterpolationAlgorithmType.KRIGING;
    }

    public InterpolationKrigingParameter(InterpolationAlgorithmType interpolationAlgorithmType) {
        super(interpolationAlgorithmType);
        this._$2 = interpolationAlgorithmType;
    }

    public InterpolationKrigingParameter(double d, SearchMode searchMode, double d2, int n, VariogramMode variogramMode) {
        super(InterpolationAlgorithmType.KRIGING, d, searchMode, d2, n);
        this._$2 = InterpolationAlgorithmType.KRIGING;
        this.setVariogramMode(variogramMode);
    }

    public InterpolationKrigingParameter(InterpolationAlgorithmType interpolationAlgorithmType, double d, SearchMode searchMode, double d2, int n, VariogramMode variogramMode) {
        super(interpolationAlgorithmType, d, searchMode, d2, n);
        this._$2 = interpolationAlgorithmType;
        this.setVariogramMode(variogramMode);
    }

    public VariogramMode getVariogramMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVariogramMode()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        int n = InterpolationParameterNative.jni_GetVariogramMode(this.getHandle());
        return (VariogramMode)InternalEnum.parseUGCValue(VariogramMode.class, n);
    }

    public void setVariogramMode(VariogramMode variogramMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVariogramMode(VariogramMode variogramMode)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        InterpolationParameterNative.jni_SetVariogramMode(this.getHandle(), InternalEnum.getUGCValue(variogramMode));
    }

    public double getRange() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRange()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationParameterNative.jni_GetRange(this.getHandle());
    }

    public void setRange(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRange(double value)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        InterpolationParameterNative.jni_SetRange(this.getHandle(), d);
    }

    public double getSill() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSill()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationParameterNative.jni_GetSill(this.getHandle());
    }

    public void setSill(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSill(double value)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        InterpolationParameterNative.jni_SetSill(this.getHandle(), d);
    }

    public double getAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAngle()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.getSearchMode() == SearchMode.QUADTREE) {
            String string = InternalResource.loadString("getAngle()", "InterpolationAlgorithmType_NotMatch", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationParameterNative.jni_GetAngle(this.getHandle());
    }

    public void setAngle(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAngle(double value)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.getSearchMode() == SearchMode.QUADTREE) {
            String string = InternalResource.loadString("setAngle()", "InterpolationAlgorithmType_NotMatch", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        InterpolationParameterNative.jni_SetAngle(this.getHandle(), d);
    }

    public double getNugget() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getNugget()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationParameterNative.jni_GetNugget(this.getHandle());
    }

    public void setNugget(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setNugget(double value)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        InterpolationParameterNative.jni_SetNugget(this.getHandle(), d);
    }

    public double getMean() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getNugget()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$2 != InterpolationAlgorithmType.SimpleKRIGING) {
            String string = InternalResource.loadString("getMean()", "InterpolationAlgorithmType_NotMatch", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationParameterNative.jni_GetMean(this.getHandle());
    }

    public void setMean(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setNugget(double value)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$2 != InterpolationAlgorithmType.SimpleKRIGING) {
            String string = InternalResource.loadString("setMean()", "InterpolationAlgorithmType_NotMatch", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        InterpolationParameterNative.jni_SetMean(this.getHandle(), d);
    }

    public Exponent getExponent() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getNugget()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$2 != InterpolationAlgorithmType.UniversalKRIGING) {
            String string = InternalResource.loadString("getExponent()", "InterpolationAlgorithmType_NotMatch", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        int n = InterpolationParameterNative.jni_GetExponent(this.getHandle());
        return (Exponent)InternalEnum.parse(Exponent.class, (int)n);
    }

    public void setExponent(Exponent exponent) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setNugget(double value)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$2 != InterpolationAlgorithmType.UniversalKRIGING) {
            String string = InternalResource.loadString("setExponent()", "InterpolationAlgorithmType_NotMatch", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        InterpolationParameterNative.jni_SetExponent(this.getHandle(), InternalEnum.getUGCValue(exponent));
    }

    public InterpolationAlgorithmType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getType()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this._$2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(",Range=");
        stringBuffer.append(this.getRange());
        stringBuffer.append(",Sill=");
        stringBuffer.append(this.getSill());
        if (this.getSearchMode() != SearchMode.QUADTREE) {
            stringBuffer.append(",Angle=");
            stringBuffer.append(this.getAngle());
        }
        stringBuffer.append(",Nugget=");
        stringBuffer.append(this.getNugget());
        if (this._$2 != InterpolationAlgorithmType.KRIGING) {
            if (this._$2 == InterpolationAlgorithmType.SimpleKRIGING) {
                stringBuffer.append(",Mean=");
                stringBuffer.append(this.getMean());
            } else if (this._$2 == InterpolationAlgorithmType.UniversalKRIGING) {
                stringBuffer.append(",Exponent=");
                stringBuffer.append((Object)this.getExponent());
            } else {
                String string = InternalResource.loadString("toString()", "InterpolationAlgorithmType_NotMatch", "spatialanalyst_resources");
                throw new IllegalStateException(string);
            }
        }
        stringBuffer.append(",VariogramMode=");
        stringBuffer.append(this.getVariogramMode().name());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

