/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.DensityAnalystParameterNative;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Rectangle2D;

public class DensityAnalystParameter
extends InternalHandleDisposable {
    public DensityAnalystParameter() {
        super.setHandle(DensityAnalystParameterNative.jni_New(), true);
        this.setBounds(Rectangle2D.getEMPTY());
    }

    public DensityAnalystParameter(double d, double d2) {
        super.setHandle(DensityAnalystParameterNative.jni_New(), true);
        this.setResolution(d);
        this.setSearchRadius(d2);
        this.setBounds(Rectangle2D.getEMPTY());
    }

    public double getResolution() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getResolution()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return DensityAnalystParameterNative.jni_GetResolution(this.getHandle());
    }

    public void setResolution(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setResolution(double value)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        DensityAnalystParameterNative.jni_SetResolution(this.getHandle(), d);
    }

    public double getSearchRadius() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSearchRadius()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return DensityAnalystParameterNative.jni_GetSearchRadius(this.getHandle());
    }

    public void setSearchRadius(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSearchRadius(double value)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        DensityAnalystParameterNative.jni_SetSearchRadius(this.getHandle(), d);
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        DensityAnalystParameterNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setBounds(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBounds(Rectangle2D rectangle2D)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (rectangle2D == null) {
            rectangle2D = Rectangle2D.getEMPTY();
        }
        double[] dArray = new double[]{rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop()};
        DensityAnalystParameterNative.jni_SetBounds(this.getHandle(), dArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Bounds={");
        stringBuffer.append(this.getBounds().toString());
        stringBuffer.append(",Resolution=");
        stringBuffer.append(this.getResolution());
        stringBuffer.append(",SearchRadius=");
        stringBuffer.append(this.getSearchRadius());
        return stringBuffer.toString();
    }

    public void dispose() {
        if (super.getHandle() != 0L) {
            DensityAnalystParameterNative.jni_Dispose(this.getHandle());
            this.setHandle(0L);
        }
    }
}

