/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.ext.servlet;

import com.noelios.restlet.ext.servlet.ServletWarEntity;
import com.noelios.restlet.local.Entity;
import com.noelios.restlet.local.EntityClientHelper;
import javax.servlet.ServletContext;
import org.restlet.Client;
import org.restlet.data.Protocol;
import org.restlet.data.Request;
import org.restlet.data.Response;

public class ServletWarClientHelper
extends EntityClientHelper {
    private volatile ServletContext servletContext;

    public ServletWarClientHelper(Client client, ServletContext servletContext) {
        super(client);
        this.getProtocols().clear();
        this.getProtocols().add(Protocol.WAR);
        this.servletContext = servletContext;
    }

    public Entity getEntity(String decodedPath) {
        return new ServletWarEntity(this.getServletContext(), decodedPath);
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void handle(Request request, Response response) {
        String scheme = request.getResourceRef().getScheme();
        if (!Protocol.WAR.getSchemeName().equalsIgnoreCase(scheme)) {
            throw new IllegalArgumentException("Protocol \"" + scheme + "\" not supported by the connector. Only WAR is supported.");
        }
        super.handle(request, response);
    }
}

