/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.optional.filter.attributes;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.sf.sojo.core.filter.ClassPropertyFilter;
import net.sf.sojo.core.filter.ClassPropertyFilterHandler;
import net.sf.sojo.core.reflect.ReflectionFieldHelper;
import net.sf.sojo.core.reflect.ReflectionMethodHelper;
import net.sf.sojo.optional.filter.attributes.ClassAttribute;
import net.sf.sojo.optional.filter.attributes.PropertyAttribute;
import net.sf.sojo.util.Util;
import org.apache.commons.attributes.Attributes;

public class ClassPropertyFilterHanlderForAttributes
implements ClassPropertyFilterHandler {
    private Map<Class<?>, ClassPropertyFilter> classCache = new HashMap();

    @Override
    public ClassPropertyFilter getClassPropertyFilterByClass(Class<?> pvClass) {
        ClassPropertyFilter lvFilter = null;
        lvFilter = this.classCache.containsKey(pvClass) ? this.classCache.get(pvClass) : this.createClassPropertyFilter(pvClass);
        return lvFilter;
    }

    private ClassPropertyFilter createClassPropertyFilter(Class<?> pvClass) {
        ClassPropertyFilter lvFilter = null;
        ClassAttribute lvClassAttribute = (ClassAttribute)Attributes.getAttribute(pvClass, ClassAttribute.class);
        if (lvClassAttribute != null) {
            lvFilter = new ClassPropertyFilter(pvClass);
            if (lvClassAttribute.getFilterUniqueId()) {
                lvFilter.addProperty("~unique-id~");
            }
            lvFilter.setSupport4AddClassProperty(lvClassAttribute.getFilter4ClassProperty());
            this.createPropertyFilterForFieldAnnotation(lvFilter, pvClass);
            this.createPropertyFilterForPropertyAnnotation(lvFilter, pvClass);
        }
        this.classCache.put(pvClass, lvFilter);
        return lvFilter;
    }

    private void createPropertyFilterForFieldAnnotation(ClassPropertyFilter pvFilter, Class<?> pvClass) {
        Field[] lvFields = ReflectionFieldHelper.getAllFieldsByClass(pvClass);
        for (int i = 0; i < lvFields.length; ++i) {
            Object lvPropertyAttribute = Attributes.getAttribute((Field)lvFields[i], PropertyAttribute.class);
            if (lvPropertyAttribute == null) continue;
            pvFilter.addProperty(lvFields[i].getName());
        }
    }

    private void createPropertyFilterForPropertyAnnotation(ClassPropertyFilter pvFilter, Class<?> pvClass) {
        Map<Object, Object> lvMethodMap = ReflectionMethodHelper.getAllGetterMethodWithCache(pvClass, null);
        for (Map.Entry<Object, Object> lvEntry : lvMethodMap.entrySet()) {
            String lvPropertyName = (String)lvEntry.getKey();
            if (!Util.getKeyWordClass().equals(lvPropertyName)) {
                Method lvMethod = (Method)lvEntry.getValue();
                Object lvPropertyAttribute = Attributes.getAttribute((Method)lvMethod, PropertyAttribute.class);
                if (lvPropertyAttribute == null) continue;
                pvFilter.addProperty(lvPropertyName);
                continue;
            }
            if (!pvFilter.getSupport4AddClassProperty()) continue;
            pvFilter.addProperty(lvPropertyName);
        }
    }
}

