/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.json.writer.xstream.io;

import com.thoughtworks.xstream.core.util.FastStack;
import com.thoughtworks.xstream.core.util.Primitives;
import com.thoughtworks.xstream.core.util.QuickWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import org.springframework.web.servlet.view.json.writer.xstream.io.CustomPathExtendedHierarchicalStreamWriter;
import org.springframework.web.servlet.view.path.CommonsBeanUtilsPathElement;
import org.springframework.web.servlet.view.path.CommonsBeanUtilslPathTracker;

public class JsonMapHierarchicalStreamWriter
implements CustomPathExtendedHierarchicalStreamWriter {
    private CommonsBeanUtilslPathTracker pathTracker = new CommonsBeanUtilslPathTracker();
    private final QuickWriter writer;
    private String keepValueTypesMode;
    private final FastStack elementStack = new FastStack(16);
    private final char[] lineIndenter;
    private int depth;
    private boolean readyForNewLine;
    private boolean tagIsEmpty;
    private String newLine;

    public JsonMapHierarchicalStreamWriter(Writer writer, String keepValueTypesMode, char[] lineIndenter, String newLine) {
        this.writer = new QuickWriter(writer);
        this.keepValueTypesMode = keepValueTypesMode;
        this.lineIndenter = lineIndenter;
        this.newLine = newLine;
    }

    public JsonMapHierarchicalStreamWriter(Writer writer, String keepValueTypesMode, String newLine) {
        this(writer, keepValueTypesMode, new char[]{' ', ' '}, newLine);
    }

    public JsonMapHierarchicalStreamWriter(Writer writer, String newLine) {
        this(writer, "NONE", new char[]{' ', ' '}, newLine);
    }

    public JsonMapHierarchicalStreamWriter(Writer writer) {
        this(writer, "NONE", new char[0], "");
    }

    public void startNode(String name) {
        this.startNode(name, null);
    }

    public void startNode(String name, Class clazz) {
        Node currNode = (Node)this.elementStack.peek();
        this.createPathElement(name, clazz, currNode);
        if (currNode == null) {
            this.writer.write("{");
        }
        if (currNode != null && currNode.fieldAlready) {
            this.writer.write(",");
            this.readyForNewLine = true;
        }
        this.tagIsEmpty = false;
        this.finishTag();
        if (currNode == null || currNode.clazz == null || currNode.clazz != null && !currNode.isCollection && !currNode.isMapEntry) {
            if (currNode != null && !currNode.fieldAlready) {
                this.writer.write("{");
                this.readyForNewLine = true;
                this.finishTag();
            }
            this.writer.write("\"");
            this.writer.write(name);
            this.writer.write("\": ");
        }
        if (this.isCollection(clazz)) {
            this.writer.write("[");
            this.readyForNewLine = true;
        }
        if (currNode != null) {
            currNode.fieldAlready = true;
        }
        this.elementStack.push((Object)new Node(name, clazz));
        ++this.depth;
        this.tagIsEmpty = true;
    }

    private void createPathElement(String name, Class clazz, Node currNode) {
        CommonsBeanUtilsPathElement element = null;
        element = currNode != null ? new CommonsBeanUtilsPathElement(name) : new CommonsBeanUtilsPathElement("map");
        if (this.isMap(clazz)) {
            element.setTyp(CommonsBeanUtilsPathElement.Typ.MAP);
        } else if (this.isCollection(clazz)) {
            element.setTyp(CommonsBeanUtilsPathElement.Typ.ARRAY);
        } else {
            element.setTyp(CommonsBeanUtilsPathElement.Typ.SIMPEL);
        }
        this.pathTracker.pushElement(name, element);
    }

    public void setValue(String text) {
        this.readyForNewLine = false;
        this.tagIsEmpty = false;
        this.finishTag();
        this.writeText(this.writer, text);
    }

    public void setValue(String text, boolean converted) {
        this.readyForNewLine = false;
        this.tagIsEmpty = false;
        this.finishTag();
        this.writeText(text, String.class);
    }

    public void addAttribute(String key, String value) {
        throw new UnsupportedOperationException("There is no need to add an Attribute!");
    }

    protected void writeAttributeValue(QuickWriter writer, String text) {
        throw new UnsupportedOperationException("There is no need to add an Attribute!");
    }

    private void writeText(QuickWriter writer, String text) {
        Node foo = (Node)this.elementStack.peek();
        this.writeText(text, foo.clazz);
    }

    protected void writeText(String text, Class clazz) {
        if (this.needsQuotes(clazz)) {
            this.writer.write("\"");
        }
        if ((clazz == Character.class || clazz == Character.TYPE) && "".equals(text)) {
            text = "\u0000";
        }
        int length = text.length();
        block4: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\"': {
                    this.writer.write("\\\"");
                    continue block4;
                }
                case '\\': {
                    this.writer.write("\\\\");
                    continue block4;
                }
                default: {
                    if (c > '\u001f') {
                        this.writer.write(c);
                        continue block4;
                    }
                    this.writer.write("\\u");
                    String hex = "000" + Integer.toHexString(c);
                    this.writer.write(hex.substring(hex.length() - 4));
                }
            }
        }
        if (this.needsQuotes(clazz)) {
            this.writer.write("\"");
        }
    }

    protected boolean isMapEntry(Class clazz) {
        return clazz != null && Map.Entry.class.isAssignableFrom(clazz);
    }

    protected boolean isMap(Class clazz) {
        return clazz != null && Map.class.isAssignableFrom(clazz);
    }

    protected boolean isCollection(Class clazz) {
        return clazz != null && (Collection.class.isAssignableFrom(clazz) || clazz.isArray());
    }

    private boolean needsQuotes(Class clazz) {
        if ("BOOLEANS".equals(this.keepValueTypesMode)) {
            Class clazz2 = clazz = clazz != null && clazz.isPrimitive() ? clazz : Primitives.unbox((Class)clazz);
            return !Boolean.class.equals((Object)clazz);
        }
        if ("ALL".equals(this.keepValueTypesMode)) {
            clazz = clazz != null && clazz.isPrimitive() ? clazz : Primitives.unbox((Class)clazz);
            return clazz == null || clazz == Character.TYPE;
        }
        return true;
    }

    public void endNode() {
        --this.depth;
        Node node = (Node)this.elementStack.pop();
        if (node.clazz != null && node.isCollection) {
            if (node.fieldAlready) {
                this.readyForNewLine = true;
            }
            this.finishTag();
            this.writer.write("]");
        } else if (node.clazz != null && node.isMapEntry) {
            if (node.fieldAlready) {
                this.readyForNewLine = true;
            }
            this.finishTag();
            this.writer.write("}");
        } else if (this.tagIsEmpty) {
            this.readyForNewLine = false;
            this.writer.write("null");
            this.finishTag();
        } else {
            this.finishTag();
            if (node.fieldAlready) {
                this.writer.write("}");
            }
        }
        this.readyForNewLine = true;
        if (this.depth == 0) {
            this.writer.write("}");
            this.writer.flush();
        }
        this.pathTracker.popElement();
    }

    private void finishTag() {
        if (this.readyForNewLine) {
            this.endOfLine();
        }
        this.readyForNewLine = false;
        this.tagIsEmpty = false;
    }

    protected void endOfLine() {
        this.writer.write(this.newLine);
        for (int i = 0; i < this.depth; ++i) {
            this.writer.write(this.lineIndenter);
        }
    }

    public void flush() {
        this.writer.flush();
    }

    public void close() {
        this.writer.close();
    }

    public HierarchicalStreamWriter underlyingWriter() {
        return this;
    }

    public CommonsBeanUtilslPathTracker getCommonsBeanUtilslPathTracker() {
        return this.pathTracker;
    }

    public void setCommonsBeanUtilslPathTracker(CommonsBeanUtilslPathTracker pathTracker) {
        this.pathTracker = pathTracker;
    }

    public char[] getLineIndenter() {
        return this.lineIndenter;
    }

    public String getNewLine() {
        return this.newLine;
    }

    public class Node {
        public final String name;
        public final Class clazz;
        public boolean fieldAlready;
        public boolean isCollection;
        public boolean isMap;
        public boolean isMapEntry;

        public Node(String name, Class clazz) {
            this.name = name;
            this.clazz = clazz;
            this.isCollection = JsonMapHierarchicalStreamWriter.this.isCollection(clazz);
            this.isMap = JsonMapHierarchicalStreamWriter.this.isMap(clazz);
            this.isMapEntry = JsonMapHierarchicalStreamWriter.this.isMapEntry(clazz);
        }
    }
}

