/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.json.writer.jsonlib;

import java.beans.PropertyEditor;
import java.util.Date;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;
import net.sf.json.processors.JsonVerifier;
import net.sf.json.util.JSONUtils;
import net.sf.json.util.JsonEventListener;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.web.servlet.view.path.CommonsBeanUtilsPathElement;
import org.springframework.web.servlet.view.path.CommonsBeanUtilslPathTracker;

public class PropertyEditorRegistryValueProcessor
implements JsonValueProcessor,
JsonEventListener {
    private PropertyEditorRegistry propertyEditorRegistry;
    private String objektName;
    private boolean convertAllMapValues;
    private CommonsBeanUtilslPathTracker pathTracker = new CommonsBeanUtilslPathTracker();
    private boolean inObject;
    int uniqueName = 0;

    public PropertyEditorRegistryValueProcessor(PropertyEditorRegistry propertyEditorRegistry) {
        this.pathTracker.pushElement("map", new CommonsBeanUtilsPathElement("", CommonsBeanUtilsPathElement.Typ.MAP));
        this.propertyEditorRegistry = propertyEditorRegistry;
    }

    public Object processArrayValue(Object value, JsonConfig jsonConfig) {
        JSONArray obj;
        if (!this.inObject) {
            this.pushElement(Integer.toString(this.uniqueName++), value);
        }
        PropertyEditor pe = null;
        if (this.propertyEditorRegistry != null) {
            String p;
            String path = this.pathTracker.getPath().toString();
            if (path.equals(p = path.replaceAll("^\\(" + this.objektName + "\\)\\.", "")) && this.convertAllMapValues) {
                pe = this.propertyEditorRegistry.findCustomEditor(value.getClass(), p);
            } else if (!path.equals(p)) {
                pe = this.propertyEditorRegistry.findCustomEditor(value.getClass(), p);
            }
        }
        if (pe == null && (Date.class.equals(value.getClass()) || java.sql.Date.class.equals(value.getClass()))) {
            this.pathTracker.popElement();
            return value.toString();
        }
        if (pe != null) {
            pe.setValue(value);
            if (!this.inObject) {
                this.pathTracker.popElement();
            }
            return pe.getAsText();
        }
        if (JsonVerifier.isValidJsonValue((Object)value)) {
            if (!this.inObject) {
                this.pathTracker.popElement();
            }
            return value;
        }
        if (value instanceof Enum) {
            obj = JSONArray.fromObject((Object)value);
            this.pathTracker.popElement();
            return obj;
        }
        if (JSONUtils.isArray((Object)value)) {
            obj = JSONArray.fromObject((Object)value, (JsonConfig)jsonConfig);
            this.pathTracker.popElement();
            return obj;
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        obj = JSONObject.fromObject((Object)value, (JsonConfig)jsonConfig);
        this.pathTracker.popElement();
        return obj;
    }

    public Object processObjectValue(String key, Object value, JsonConfig jsonConfig) {
        JSONArray obj;
        this.pushElement(key, value);
        PropertyEditor pe = null;
        if (this.propertyEditorRegistry != null && value != null) {
            String p;
            String path = this.pathTracker.getPath().toString();
            if (path.equals(p = path.replaceAll("^\\(" + this.objektName + "\\).", "")) && this.convertAllMapValues) {
                pe = this.propertyEditorRegistry.findCustomEditor(value.getClass(), p);
            } else if (!path.equals(p)) {
                pe = this.propertyEditorRegistry.findCustomEditor(value.getClass(), p);
            }
        }
        if (pe == null && value != null && (Date.class.equals(value.getClass()) || java.sql.Date.class.equals(value.getClass()))) {
            this.pathTracker.popElement();
            return value.toString();
        }
        if (pe != null) {
            pe.setValue(value);
            this.pathTracker.popElement();
            return pe.getAsText();
        }
        if (JsonVerifier.isValidJsonValue((Object)value)) {
            this.pathTracker.popElement();
            return value;
        }
        if (value instanceof Enum) {
            obj = JSONArray.fromObject((Object)value);
            this.pathTracker.popElement();
            return obj;
        }
        if (JSONUtils.isArray((Object)value)) {
            obj = JSONArray.fromObject((Object)value, (JsonConfig)jsonConfig);
            this.pathTracker.popElement();
            return obj;
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        obj = JSONObject.fromObject((Object)value, (JsonConfig)jsonConfig);
        this.pathTracker.popElement();
        return obj;
    }

    private void pushElement(String key, Object value) {
        CommonsBeanUtilsPathElement element = new CommonsBeanUtilsPathElement(key);
        if (JSONUtils.isArray((Object)value)) {
            element.setTyp(CommonsBeanUtilsPathElement.Typ.ARRAY);
        } else if (value instanceof Map) {
            element.setTyp(CommonsBeanUtilsPathElement.Typ.MAP);
        } else {
            element.setTyp(CommonsBeanUtilsPathElement.Typ.SIMPEL);
        }
        this.pathTracker.pushElement(key, element);
    }

    public void onArrayEnd() {
        this.inObject = false;
    }

    public void onArrayStart() {
        this.inObject = false;
    }

    public void onElementAdded(int index, Object element) {
    }

    public void onError(JSONException jsone) {
    }

    public void onObjectEnd() {
        this.inObject = false;
    }

    public void onObjectStart() {
        this.inObject = true;
    }

    public void onPropertySet(String key, Object value, boolean accumulated) {
    }

    public void onWarning(String warning) {
    }

    public PropertyEditorRegistry getPropertyEditorRegistry() {
        return this.propertyEditorRegistry;
    }

    public boolean isConvertAllMapValues() {
        return this.convertAllMapValues;
    }

    public void setConvertAllMapValues(boolean convertAllMapValues) {
        this.convertAllMapValues = convertAllMapValues;
    }

    public String getObjektName() {
        return this.objektName;
    }

    public void setObjektName(String objektName) {
        this.objektName = objektName;
    }

    protected CommonsBeanUtilslPathTracker getPathTracker() {
        return this.pathTracker;
    }

    protected void setPathTracker(CommonsBeanUtilslPathTracker pathTracker) {
        this.pathTracker = pathTracker;
    }
}

