/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.spring;

import org.restlet.Finder;
import org.restlet.Restlet;
import org.restlet.Router;
import org.restlet.ext.spring.SpringBeanFinder;
import org.restlet.resource.Resource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class SpringBeanRouter
extends Router
implements BeanFactoryPostProcessor {
    private volatile boolean findInAncestors = true;

    protected Finder createFinder(BeanFactory beanFactory, String beanName) {
        return new SpringBeanFinder(beanFactory, beanName);
    }

    public boolean isFindInAncestors() {
        return this.findInAncestors;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory factory) throws BeansException {
        String[] names;
        for (String name : names = this.isFindInAncestors() ? BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)factory, Resource.class, (boolean)true, (boolean)true) : factory.getBeanNamesForType(Resource.class, true, true)) {
            String uri = this.resolveUri(name, factory);
            if (uri == null) continue;
            this.attach(uri, (Restlet)this.createFinder((BeanFactory)factory, name));
        }
    }

    protected String resolveUri(String resourceName, ConfigurableListableBeanFactory factory) {
        for (String alias : factory.getAliases(resourceName)) {
            if (!alias.startsWith("/")) continue;
            return alias;
        }
        return null;
    }

    public void setFindInAncestors(boolean findInAncestors) {
        this.findInAncestors = findInAncestors;
    }
}

