/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml1.binding.artifact;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml1.binding.artifact.SAML1ArtifactBuilder;
import org.opensaml.saml1.binding.artifact.SAML1ArtifactType0001;
import org.opensaml.saml1.core.Assertion;
import org.opensaml.saml1.core.NameIdentifier;
import org.opensaml.saml1.core.RequestAbstractType;
import org.opensaml.saml1.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAML1ArtifactType0001Builder
implements SAML1ArtifactBuilder<SAML1ArtifactType0001> {
    private final Logger log = LoggerFactory.getLogger(SAML1ArtifactType0001Builder.class);

    @Override
    public SAML1ArtifactType0001 buildArtifact(byte[] artifact) {
        return SAML1ArtifactType0001.parseArtifact(artifact);
    }

    @Override
    public SAML1ArtifactType0001 buildArtifact(SAMLMessageContext<RequestAbstractType, Response, NameIdentifier> requestContext, Assertion assertion) {
        try {
            MessageDigest sha1Digester = MessageDigest.getInstance("SHA-1");
            byte[] source = sha1Digester.digest(requestContext.getLocalEntityId().getBytes());
            SecureRandom handleGenerator = SecureRandom.getInstance("SHA1PRNG");
            byte[] assertionHandle = new byte[20];
            handleGenerator.nextBytes(assertionHandle);
            return new SAML1ArtifactType0001(source, assertionHandle);
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error("JVM does not support required cryptography algorithms.", (Throwable)e);
            throw new InternalError("JVM does not support required cryptography algorithms: SHA-1 and/or SHA1PRNG.");
        }
    }
}

