/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.InternalHandle;
import com.supermap.data.Point3D;
import com.supermap.data.conversion.DataType;
import com.supermap.data.conversion.ImportSetting;
import com.supermap.data.conversion.ImportSettingModel3DSNative;
import com.supermap.data.conversion.InternalHandleDisposable;
import com.supermap.data.conversion.InternalResource;

public class ImportSettingModel3DS
extends ImportSetting {
    public ImportSettingModel3DS() {
        long l = ImportSettingModel3DSNative.jni_New();
        this.setHandle(l, true);
        super.setDataType(DataType.VECTOR);
    }

    public ImportSettingModel3DS(ImportSettingModel3DS importSettingModel3DS) {
        if (importSettingModel3DS == null) {
            String string = InternalResource.loadString("importSettingModel3DS", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)importSettingModel3DS);
        if (l == 0L) {
            String string = InternalResource.loadString("importSettingModel3DS", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ImportSettingModel3DSNative.jni_Clone(l);
        this.setHandle(l2, true);
        this.setTargetDatasourceConnectionInfo(importSettingModel3DS.getTargetDatasourceConnectionInfo());
        this.setTargetDatasource(importSettingModel3DS.getTargetDatasource());
        super.setDataType(DataType.VECTOR);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)importSettingModel3DS));
    }

    public ImportSettingModel3DS(String string, Datasource datasource) {
        this();
        this.setSourceFilePath(string);
        this.setTargetDatasource(datasource);
    }

    public ImportSettingModel3DS(String string, DatasourceConnectionInfo datasourceConnectionInfo) {
        this();
        this.setSourceFilePath(string);
        this.setTargetDatasourceConnectionInfo(datasourceConnectionInfo);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)datasourceConnectionInfo);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ImportSettingModel3DSNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public void setPosition(Point3D point3D) {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ImportSettingModel3DSNative.jni_SetPosition(this.getHandle(), point3D.getX(), point3D.getY(), point3D.getZ());
        }
    }

    public Point3D getPosition() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        double[] dArray = ImportSettingModel3DSNative.jni_GetPosition(this.getHandle());
        Point3D point3D = new Point3D(dArray[0], dArray[1], dArray[2]);
        return point3D;
    }

    public boolean isImportingAsCAD() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isImportingAsCAD()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingModel3DSNative.jni_IsImportingAsCAD(this.getHandle());
    }

    public void setImportingAsCAD(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingAsCAD(boolean value)", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingModel3DSNative.jni_SetImportingAsCAD(this.getHandle(), bl);
    }
}

