/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.conversion.CADVersion;
import com.supermap.data.conversion.ExportSetting;
import com.supermap.data.conversion.FileType;
import com.supermap.data.conversion.InternalResource;

public class ExportSettingDWG
extends ExportSetting {
    boolean m_isExportingExternalData;
    boolean m_isExpBorder;
    boolean m_isExportXrecord;
    String m_strStyleMappingPath;
    CADVersion m_version;

    public ExportSettingDWG() {
        this.m_isExportingExternalData = false;
        this.m_isExpBorder = true;
        this.m_version = CADVersion.CAD2004;
        this.m_type = FileType.DWG;
        this.m_strStyleMappingPath = "";
    }

    public ExportSettingDWG(ExportSettingDWG exportSettingDWG) {
        super(exportSettingDWG);
        this.setExportingExternalData(exportSettingDWG.isExportingExternalData());
        this.setExportingBorder(exportSettingDWG.m_isExpBorder);
        this.setStyleMappingTableFile(exportSettingDWG.m_strStyleMappingPath);
        this.setVersion(exportSettingDWG.getVersion());
        this.m_type = FileType.DWG;
    }

    public ExportSettingDWG(Object object, String string, FileType fileType) {
        super(object, string, fileType);
        this.m_type = FileType.DWG;
    }

    public CADVersion getVersion() {
        return this.m_version;
    }

    public void setVersion(CADVersion cADVersion) {
        this.m_version = cADVersion;
    }

    public boolean isExportingExternalData() {
        return this.m_isExportingExternalData;
    }

    public void setExportingExternalData(boolean bl) {
        this.m_isExportingExternalData = bl;
    }

    public boolean isExportingBorder() {
        return this.m_isExpBorder;
    }

    public void setExportingBorder(boolean bl) {
        this.m_isExpBorder = bl;
    }

    public boolean isExportingXRecord() {
        return this.m_isExportXrecord;
    }

    public void setExportingXRecord(boolean bl) {
        this.m_isExportXrecord = bl;
    }

    public FileType getTargetFileType() {
        return this.m_type;
    }

    public void setTargetFileType(FileType fileType) {
        if (FileType.DWG != fileType) {
            String string = InternalResource.loadString("setTargetFileType(FileType type)", "SetTargetFileTypeIsNotAllowed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        this.m_type = FileType.DWG;
    }

    public void setStyleMappingTableFile(String string) {
        this.m_strStyleMappingPath = string;
    }

    public String getStyleMappingTableFile() {
        return this.m_strStyleMappingPath;
    }
}

