/**
 * 字典维护详细画面
 * 
 * @author 袁晓冬
 */
$.namespace("userManage.org.detail");
/** 是否公用代码 */
userManage.org.detail.sfCodeArray = null;
userManage.org.detail.orgid=null;
userManage.org.detail.$leaf = null;
userManage.org.detail.$valid = null;
userManage.org.detail.$orgTree = null;
/** 初始化组件引用 */
userManage.org.detail.initComp = function() {
    userManage.org.detail.$leaf = $('#leaf');
    userManage.org.detail.$valid = $('#valid');
    userManage.org.detail.$orgTree = $('#orgTree');
}
/** 页面初始化 */
userManage.org.detail.init = function() {
    // 转换数据字符串为对象
    if (userManage.org.detail.data) {
        userManage.org.detail.data = $.parseJSON(userManage.org.detail.data);
    }
    userManage.org.detail.initComp();
    userManage.org.detail.initCombox();
    // 初始化字典树
    userManage.org.detail.$orgTree.tree({
        url : $.ctx + "/org/tree"+"?"+Math.random(),
        method : 'get',
        queryParams : {
            root : "false"
        },
        onLoadSuccess:function(node,data){  
            var n = $("#orgTree").tree("getRoots");  
            $.each(n,function(a,b){
                if(b.id == userManage.org.detail.orgid ){
                    $("#orgTree").tree("select",b.target);  
                }
            })
         },
        onClick : function(node) {
            user.main.refreshGrid(node);
        }
    });
}
/**
 * 初始化下拉框
 */
userManage.org.detail.initCombox = function() {
    // 初始化人员状态下拉框
    var dataArr = new Array();
    dataArr = dataArr.concat(userManage.org.detail.sfCodeArray);
    userManage.org.detail.$leaf.combobox({
        valueField : 'code',
        textField : 'text',
        data : dataArr,
        editable : false,
        onLoadSuccess : function() {
            // 默认选中可用
            if (userManage.org.detail.data["leaf"] === 'N') {
                userManage.org.detail.$leaf.combobox('select', consts.CODE_TY_SF_F);
            } else {
                userManage.org.detail.$leaf.combobox('select', consts.CODE_TY_SF_S);
            }
        }
    });
    userManage.org.detail.$valid.combobox({
        valueField : 'code',
        textField : 'text',
        data : dataArr,
        editable : false,
        onLoadSuccess : function() {
            // 默认选中可用
            if (userManage.org.detail.data["valid"] === 'N') {
                userManage.org.detail.$valid.combobox('select', consts.CODE_TY_SF_F);
            } else {
                userManage.org.detail.$valid.combobox('select', consts.CODE_TY_SF_S);
            }
        }
    });

};
/**
 * 判断是否为空
 * @param str
 * @returns {Boolean}
 */
function isEmpty(str){
    if(str!=""&&str!=null&&str.length!=0){
        return false;
    }else{
        return true;
    }
}

var isCommitted = false;//表单是否已经提交标识，默认为false
/**
 * 保存菜单
 */
userManage.org.detail.save = function() {
    if(isEmpty($('#name').val())){
        $.messager.alert('提示','部门名称不能为空！');
        return false;
    }
    if(isEmpty($('#sortno').val())){
        $.messager.alert('提示','排序号不能为空！');
        return false;
    }
    if(isCommitted==false){
        isCommitted = true;//提交表单后，将表单是否已经提交标识设置为true
        $("#sortno").val(Number($("#sortno").val())) ;
        $('#rform').form('submit', {
            url : $.ctx + '/orgManage/save',
            onSubmit : function() {
                return $(this).form('validate');
            },
            success : function(data, status) {
                if (data) {
                    data = $.parseJSON(data);
                }
                if (data.success) {
                    location.href=$.ctx + '/userManage/main?orgid='+userManage.org.detail.orgid;
                } else {
                    $.messager.showError(data.message);
                }
            }
        });
        return true;//返回true让表单正常提交
    }else{
        setTimeout(function() { isCommitted = false; }, 5000);
        return false;//返回false那么表单将不提交
    }
}

userManage.org.detail.back = function() {
    window.location=$.ctx + '/userManage/main?orgid='+userManage.org.detail.orgid;
}