<%@ page contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>  
<%@ include file="../include/header.jsp"%>
<script type="text/javascript">

$.extend($.fn.tree.methods, {
	/**
	 * 激活复选框
	 * @param {Object} jq
	 * @param {Object} target
	 */
	enableCheck : function(jq, target) { 
        return jq.each(function(){
            var realTarget;
            if(typeof target == "string" || typeof target == "number"){
                realTarget = $(this).tree("find",target).target;
            }else{
                realTarget = target;
            }
            var ckSpan = $(realTarget).find(">span.tree-checkbox");
            if(ckSpan.hasClass('tree-checkbox-disabled0')){
                ckSpan.removeClass('tree-checkbox-disabled0');
            }else if(ckSpan.hasClass('tree-checkbox-disabled1')){
                ckSpan.removeClass('tree-checkbox-disabled1');
            }else if(ckSpan.hasClass('tree-checkbox-disabled2')){
                ckSpan.removeClass('tree-checkbox-disabled2');
            }
        });
	},
	/**
	 * 禁用复选框
	 * @param {Object} jq
	 * @param {Object} target
	 */
	disableCheck : function(jq, target) {
		return jq.each(function() {
            var realTarget;
            var that = this;
            var state = $.data(this,'tree');
            var opts = state.options;
			if(typeof target == "string" || typeof target == "number"){
                realTarget = $(this).tree("find",target).target;
            }else{
                realTarget = target;
            }
            var ckSpan = $(realTarget).find(">span.tree-checkbox");
            ckSpan.removeClass("tree-checkbox-disabled0").removeClass("tree-checkbox-disabled1").removeClass("tree-checkbox-disabled2");
            if(ckSpan.hasClass('tree-checkbox0')){
                ckSpan.addClass('tree-checkbox-disabled0');
            }else if(ckSpan.hasClass('tree-checkbox1')){
                ckSpan.addClass('tree-checkbox-disabled1');
            }else{
                ckSpan.addClass('tree-checkbox-disabled2')
            }
            if(!state.resetClick){
                $(this).unbind('click').bind('click', function(e) {
                    var tt = $(e.target);
                    var node = tt.closest('div.tree-node');
                    if (!node.length){return;}
                    if (tt.hasClass('tree-hit')){
                        $(this).tree("toggle",node[0]);
                        return false;
                    } else if (tt.hasClass('tree-checkbox')){
                        if(tt.hasClass('tree-checkbox-disabled0') || tt.hasClass('tree-checkbox-disabled1') || tt.hasClass('tree-checkbox-disabled2')){
                            $(this).tree("select",node[0]);
                        }else{
                            if(tt.hasClass('tree-checkbox1')){
                                $(this).tree('uncheck',node[0]);
                            }else{
                                $(this).tree('check',node[0]);
                            }
                            return false;
                        }
                    } else {
                        $(this).tree("select",node[0]);
                        opts.onClick.call(this, $(this).tree("getNode",node[0]));
                    }
                    e.stopPropagation();
                });
            }
            
		});
	}
});

function zk(){
    $('#tt').tree('expandAll');
} 


function zd(){
    $('#tt').tree('collapseAll');
} 

function qx(flag){
    var roots = $('#tt').tree('getRoots');//返回tree的所有根节点数组  
    if(flag=="1"){
        $('#tt').tree('expandAll');
        for ( var i = 0; i < roots.length; i++) {  
            var parent = $('#tt').tree('find', roots[i].id);  
            var childs = $('#tt').tree('getChildren',parent.target);
            for ( var j = 0; j < childs.length; j++) { 
                var node = $('#tt').tree('find', childs[j].id);
                if("disabled"==node.attributes.disabled){
                    $('#tt').tree('disableCheck',childs[j].id);//禁用  
                }else{
                    $('#tt').tree('check', node.target);//将得到的节点选中  
                }
            }
        }  
    }else if (flag=="2"){
        for ( var i = 0; i < roots.length; i++) {  
            var parent = $('#tt').tree('find', roots[i].id);  
            var childs = $('#tt').tree('getChildren',parent.target);
            for ( var j = 0; j < childs.length; j++) { 
                var node = $('#tt').tree('find', childs[j].id);
                $('#tt').tree('uncheck', node.target);//将得到的节点取消选中  
            }
        }  
    }else{
    }
} 
$(function(){
    $('#tt').tree({
    	onClick: function(node){
    		if(node.checked){  // 在用户点击的时候提示
    			$('#tt').tree('uncheck', node.target);
    		}else{
    			$('#tt').tree('check', node.target);
    		}
    		
    	},
        onLoadSuccess:function(){
            var roots = $('#tt').tree('getRoots');//返回tree的所有根节点数组  
            for ( var i = 0; i < roots.length; i++) {  
                var parent = $('#tt').tree('find', roots[i].id);  
                var childs = $('#tt').tree('getChildren',parent.target);
                for ( var j = 0; j < childs.length; j++) { 
                    var node = $('#tt').tree('find', childs[j].id);
                    if("disabled"==node.attributes.disabled){
                        $('#tt').tree('disableCheck',childs[j].id);//禁用  
                    }
                }
            }  
        }
    });
});
</script>

<form id="f1" method="post">
	 <table id="stepTable" style="margin: auto; margin-top: 5px;border: 1px;">
        <tbody>
        <tr>
        	<td width="400px;">

    <button type="button" class="grsw_mail_browse" onclick="qx('1')"><span>全选</span></button>
    <button type="button" class="grsw_mail_browse" onclick="qx('2')"><span>全不选</span></button>
        	</td>
        	</tr>
        
        	<tr>
        	<td width="400px;">
        	<%-- <select class="easyui-combotree"   id="xr"
                           data-options="url:'${ctx}/wf/task/showUserTree?stepId=${stepId}',required:false,value:'${hIds }',checkbox:true,onlyLeafCheck:true,multiple:true"  style="width:156px;"/> --%>
                    <ul id="tt" class="easyui-tree" data-options="url:'${ctx}/wf/task/showUserTree?stepId=${stepId}&ids=${hIds }&businesskey=${businesskey }&taskId=${taskId }',animate:true,checkbox:true,onlyLeafCheck:true"></ul>
        	</td>
        	</tr>
        </tbody>
    </table>
</form>