// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom.html;

import org.w3c.dom.*;

/**

  <P>Parameters fed to the 
    <code>OBJECT</code> element. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#edef-PARAM">PARAM element definition</A>
 in HTML 4.0.
  
</P>

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-name><CODE>&nbsp;name</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getName()'>getName</a>
<a href='#setName(java.lang.String)'>setName</a>
</TD>
<TD>
  <P>The name of a run-time parameter. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-name-PARAM">name attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-type><CODE>&nbsp;type</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getType()'>getType</a>
<a href='#setType(java.lang.String)'>setType</a>
</TD>
<TD>
  <P>Content type for the 
    <code>value</code> attribute when 
    <code>valuetype</code> has the value "ref". See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-type-PARAM">type attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-value><CODE>&nbsp;value</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getValue()'>getValue</a>
<a href='#setValue(java.lang.String)'>setValue</a>
</TD>
<TD>
  <P>The value of a run-time parameter. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-value-PARAM">value attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-valueType><CODE>&nbsp;valueType</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getValueType()'>getValueType</a>
<a href='#setValueType(java.lang.String)'>setValueType</a>
</TD>
<TD>
  <P>Information about the meaning of the 
    <code>value</code> attribute value. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-valuetype">valuetype attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface HTMLParamElement
extends HTMLElement
{
	/** Assigns the value of the <code><a href=#att-name>name</a></code> property.
	 */
	void setName (String name);

	/**
	 * Returns the value of the <code><a href=#att-name>name</a></code> property.
	*/
	String getName ();


	/** Assigns the value of the <code><a href=#att-type>type</a></code> property.
	 */
	void setType (String type);

	/**
	 * Returns the value of the <code><a href=#att-type>type</a></code> property.
	*/
	String getType ();


	/** Assigns the value of the <code><a href=#att-value>value</a></code> property.
	 */
	void setValue (String value);

	/**
	 * Returns the value of the <code><a href=#att-value>value</a></code> property.
	*/
	String getValue ();


	/** Assigns the value of the <code><a href=#att-valueType>valueType</a></code> property.
	 */
	void setValueType (String valueType);

	/**
	 * Returns the value of the <code><a href=#att-valueType>valueType</a></code> property.
	*/
	String getValueType ();


}
