/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.standard.processors;

import java.text.Collator;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.document.DateField;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.queryParser.core.QueryNodeException;
import org.apache.lucene.queryParser.core.config.FieldConfig;
import org.apache.lucene.queryParser.core.nodes.ParametricQueryNode;
import org.apache.lucene.queryParser.core.nodes.ParametricRangeQueryNode;
import org.apache.lucene.queryParser.core.nodes.QueryNode;
import org.apache.lucene.queryParser.core.processors.QueryNodeProcessorImpl;
import org.apache.lucene.queryParser.standard.config.StandardQueryConfigHandler;
import org.apache.lucene.queryParser.standard.nodes.RangeQueryNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametricRangeQueryNodeProcessor
extends QueryNodeProcessorImpl {
    @Override
    protected QueryNode postProcessNode(QueryNode node) throws QueryNodeException {
        if (node instanceof ParametricRangeQueryNode) {
            FieldConfig fieldConfig;
            ParametricRangeQueryNode parametricRangeNode = (ParametricRangeQueryNode)node;
            ParametricQueryNode upper = parametricRangeNode.getUpperBound();
            ParametricQueryNode lower = parametricRangeNode.getLowerBound();
            DateTools.Resolution dateRes = null;
            boolean inclusive = false;
            Locale locale = this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.LOCALE, Locale.getDefault());
            Collator collator = this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.RANGE_COLLATOR);
            CharSequence field = parametricRangeNode.getField();
            String fieldStr = null;
            if (field != null) {
                fieldStr = ((Object)field).toString();
            }
            if ((fieldConfig = this.getQueryConfigHandler().getFieldConfig(fieldStr)) != null) {
                dateRes = fieldConfig.get(StandardQueryConfigHandler.ConfigurationKeys.DATE_RESOLUTION);
            }
            if (upper.getOperator() == ParametricQueryNode.CompareOperator.LE) {
                inclusive = true;
            } else if (lower.getOperator() == ParametricQueryNode.CompareOperator.GE) {
                inclusive = true;
            }
            String part1 = lower.getTextAsString();
            String part2 = upper.getTextAsString();
            try {
                DateFormat df = DateFormat.getDateInstance(3, locale);
                df.setLenient(true);
                Date d1 = df.parse(part1);
                Date d2 = df.parse(part2);
                if (inclusive) {
                    Calendar cal = Calendar.getInstance(locale);
                    cal.setTime(d2);
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    d2 = cal.getTime();
                }
                if (dateRes == null) {
                    part1 = DateField.dateToString((Date)d1);
                    part2 = DateField.dateToString((Date)d2);
                } else {
                    part1 = DateTools.dateToString((Date)d1, (DateTools.Resolution)dateRes);
                    part2 = DateTools.dateToString((Date)d2, (DateTools.Resolution)dateRes);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            lower.setText(part1);
            upper.setText(part2);
            return new RangeQueryNode(lower, upper, collator);
        }
        return node;
    }

    @Override
    protected QueryNode preProcessNode(QueryNode node) throws QueryNodeException {
        return node;
    }

    @Override
    protected List<QueryNode> setChildrenOrder(List<QueryNode> children) throws QueryNodeException {
        return children;
    }
}

