/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.store.BufferedIndexInput;

public class MockIndexInput
extends BufferedIndexInput {
    private byte[] buffer;
    private int pointer = 0;
    private long length;

    public MockIndexInput(byte[] bytes) {
        super("MockIndexInput", 1024);
        this.buffer = bytes;
        this.length = bytes.length;
    }

    protected void readInternal(byte[] dest, int destOffset, int len) {
        int bytesToCopy;
        int start = this.pointer;
        for (int remainder = len; remainder != 0; remainder -= bytesToCopy) {
            int bufferOffset = start % this.buffer.length;
            int bytesInBuffer = this.buffer.length - bufferOffset;
            bytesToCopy = bytesInBuffer >= remainder ? remainder : bytesInBuffer;
            System.arraycopy(this.buffer, bufferOffset, dest, destOffset, bytesToCopy);
            destOffset += bytesToCopy;
            start += bytesToCopy;
        }
        this.pointer += len;
    }

    public void close() {
    }

    protected void seekInternal(long pos) {
        this.pointer = (int)pos;
    }

    public long length() {
        return this.length;
    }
}

