/*
 * Decompiled with CFR 0.152.
 */
package com.xtframe.wf.support;

import com.xtframe.core.support.SecurityMgr;
import com.xtframe.core.utils.Assert;
import com.xtframe.wf.engine.ActService;
import com.xtframe.wf.engine.impl.ActProcessEngineImpl;
import com.xtframe.wf.engine.impl.ActServiceImpl;
import com.xtframe.wf.support.ActWorkFlowEngineClient;
import com.xtframe.wf.support.MyGroupEntityManager;
import com.xtframe.wf.support.MyGroupEntityManagerFactory;
import com.xtframe.wf.support.MyUserEntityManager;
import com.xtframe.wf.support.MyUserEntityManagerFactory;
import com.xtframe.wf.support.ProcessDefinitionCache;
import com.xtframe.wf.support.UUIDGenerator;
import com.xtframe.wf.support.WorkflowTraceService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.zip.ZipInputStream;
import javax.sql.DataSource;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngineConfiguration;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.cfg.StandaloneProcessEngineConfiguration;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.el.ReadOnlyMapELResolver;
import org.activiti.engine.impl.el.VariableScopeElResolver;
import org.activiti.engine.impl.interceptor.CommandConfig;
import org.activiti.engine.impl.interceptor.CommandInterceptor;
import org.activiti.engine.impl.javax.el.ArrayELResolver;
import org.activiti.engine.impl.javax.el.BeanELResolver;
import org.activiti.engine.impl.javax.el.CompositeELResolver;
import org.activiti.engine.impl.javax.el.ELResolver;
import org.activiti.engine.impl.javax.el.ListELResolver;
import org.activiti.engine.impl.javax.el.MapELResolver;
import org.activiti.engine.impl.variable.EntityManagerSession;
import org.activiti.engine.repository.DeploymentBuilder;
import org.activiti.spring.ApplicationContextElResolver;
import org.activiti.spring.SpringEntityManagerSessionFactory;
import org.activiti.spring.SpringTransactionContextFactory;
import org.activiti.spring.SpringTransactionInterceptor;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ContextResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.PlatformTransactionManager;

public class XtWorkflowProcessEngineConfiguration
extends ProcessEngineConfigurationImpl
implements ApplicationContextAware {
    protected PlatformTransactionManager transactionManager;
    protected String deploymentName = "SpringAutoDeployment";
    protected Resource[] deploymentResources = new Resource[0];
    protected ApplicationContext applicationContext;
    protected Integer transactionSynchronizationAdapterOrder = null;
    protected ActService actService = new ActServiceImpl();
    protected SecurityMgr securityMgr;
    protected IdGenerator idGenerator = new UUIDGenerator();

    public void setSecurityMgr(SecurityMgr securityMgr) {
        this.securityMgr = securityMgr;
    }

    public XtWorkflowProcessEngineConfiguration() {
        this.transactionsExternallyManaged = true;
        this.setActivityFontName("\u5b8b\u4f53");
        this.setLabelFontName("\u5b8b\u4f53");
        this.setIdGenerator(this.idGenerator);
    }

    public ProcessEngine buildProcessEngine() {
        Assert.notNull((Object)this.securityMgr);
        MyUserEntityManagerFactory uemf = new MyUserEntityManagerFactory();
        uemf.setUserEntityManager(new MyUserEntityManager());
        MyGroupEntityManagerFactory gemf = new MyGroupEntityManagerFactory();
        MyGroupEntityManager gem = new MyGroupEntityManager();
        gem.setRoleService(this.securityMgr.roleService());
        gem.setUserService(this.securityMgr.userService());
        gemf.setGroupEntityManager(gem);
        if (this.customSessionFactories == null) {
            this.customSessionFactories = new ArrayList();
            this.customSessionFactories.add(uemf);
            this.customSessionFactories.add(gemf);
        }
        this.init();
        this.initService(this.actService);
        this.expressionManager = new WfExpressionManager(this.applicationContext, this.getBeans());
        ActProcessEngineImpl processEngine = new ActProcessEngineImpl(this);
        this.autoDeployResources(processEngine);
        ActWorkFlowEngineClient client = new ActWorkFlowEngineClient();
        client.setBeans(this.getBeans());
        client.setProcessEngine(processEngine);
        client.setSecurityMgr(this.securityMgr);
        WorkflowTraceService traceService = new WorkflowTraceService();
        traceService.processEngine = processEngine;
        traceService.securityMgr = this.securityMgr;
        client.traceService = traceService;
        client.init();
        processEngine.setWorkFlowEngineClient(client);
        ProcessDefinitionCache.setRepositoryService(processEngine.getRepositoryService());
        return processEngine;
    }

    public void setTransactionSynchronizationAdapterOrder(Integer transactionSynchronizationAdapterOrder) {
        this.transactionSynchronizationAdapterOrder = transactionSynchronizationAdapterOrder;
    }

    protected void initDefaultCommandConfig() {
        if (this.defaultCommandConfig == null) {
            this.defaultCommandConfig = new CommandConfig().setContextReusePossible(true);
        }
    }

    protected CommandInterceptor createTransactionInterceptor() {
        if (this.transactionManager == null) {
            throw new ActivitiException("transactionManager is required property for SpringProcessEngineConfiguration, use " + StandaloneProcessEngineConfiguration.class.getName() + " otherwise");
        }
        return new SpringTransactionInterceptor(this.transactionManager);
    }

    protected void initTransactionContextFactory() {
        if (this.transactionContextFactory == null && this.transactionManager != null) {
            this.transactionContextFactory = new SpringTransactionContextFactory(this.transactionManager, this.transactionSynchronizationAdapterOrder);
        }
    }

    protected void initJpa() {
        super.initJpa();
        if (this.jpaEntityManagerFactory != null) {
            this.sessionFactories.put(EntityManagerSession.class, new SpringEntityManagerSessionFactory(this.jpaEntityManagerFactory, this.jpaHandleTransaction, this.jpaCloseEntityManager));
        }
    }

    protected void autoDeployResources(ProcessEngine processEngine) {
        if (this.deploymentResources != null && this.deploymentResources.length > 0) {
            RepositoryService repositoryService = processEngine.getRepositoryService();
            DeploymentBuilder deploymentBuilder = repositoryService.createDeployment().enableDuplicateFiltering().name(this.deploymentName);
            Resource[] resourceArray = this.deploymentResources;
            int n = this.deploymentResources.length;
            int n2 = 0;
            while (n2 < n) {
                Resource resource = resourceArray[n2];
                String resourceName = null;
                if (resource instanceof ContextResource) {
                    resourceName = ((ContextResource)resource).getPathWithinContext();
                } else if (resource instanceof ByteArrayResource) {
                    resourceName = resource.getDescription();
                } else {
                    try {
                        resourceName = resource.getFile().getAbsolutePath();
                    }
                    catch (IOException e) {
                        resourceName = resource.getFilename();
                    }
                }
                try {
                    if (resourceName.endsWith(".bar") || resourceName.endsWith(".zip") || resourceName.endsWith(".jar")) {
                        deploymentBuilder.addZipInputStream(new ZipInputStream(resource.getInputStream()));
                    } else {
                        deploymentBuilder.addInputStream(resourceName, resource.getInputStream());
                    }
                }
                catch (IOException e) {
                    throw new ActivitiException("couldn't auto deploy resource '" + resource + "': " + e.getMessage(), (Throwable)e);
                }
                ++n2;
            }
            deploymentBuilder.deploy();
        }
    }

    public ProcessEngineConfiguration setDataSource(DataSource dataSource) {
        if (dataSource instanceof TransactionAwareDataSourceProxy) {
            return super.setDataSource(dataSource);
        }
        TransactionAwareDataSourceProxy proxiedDataSource = new TransactionAwareDataSourceProxy(dataSource);
        return super.setDataSource((DataSource)proxiedDataSource);
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public void setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public Resource[] getDeploymentResources() {
        return this.deploymentResources;
    }

    public void setDeploymentResources(Resource[] deploymentResources) {
        this.deploymentResources = deploymentResources;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private static class WfExpressionManager
    extends ExpressionManager {
        protected ApplicationContext applicationContext;

        public WfExpressionManager(ApplicationContext applicationContext, Map<Object, Object> beans) {
            super(beans);
            this.applicationContext = applicationContext;
        }

        protected ELResolver createElResolver(VariableScope variableScope) {
            CompositeELResolver compositeElResolver = new CompositeELResolver();
            compositeElResolver.add((ELResolver)new VariableScopeElResolver(variableScope));
            if (this.beans != null) {
                compositeElResolver.add((ELResolver)new ReadOnlyMapELResolver(this.beans));
            } else {
                compositeElResolver.add((ELResolver)new ApplicationContextElResolver(this.applicationContext));
            }
            compositeElResolver.add((ELResolver)new ArrayELResolver());
            compositeElResolver.add((ELResolver)new ListELResolver());
            compositeElResolver.add((ELResolver)new MapELResolver());
            compositeElResolver.add((ELResolver)new BeanELResolver());
            return compositeElResolver;
        }
    }
}

