/*
 * Decompiled with CFR 0.152.
 */
package com.xtframe.sec.wf.service.impl;

import com.xtframe.core.utils.Assert;
import com.xtframe.sec.common.BaseSecurityService;
import com.xtframe.sec.wf.dao.WfConfigStepDao;
import com.xtframe.sec.wf.entity.WfConfigEntity;
import com.xtframe.sec.wf.entity.WfConfigStepEntity;
import com.xtframe.sec.wf.service.WfConfigStepService;
import com.xtframe.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.json.JSONArray;

public class WfConfigStepServiceImpl
extends BaseSecurityService
implements WfConfigStepService {
    private WfConfigStepDao dao;

    @Override
    public List<WfConfigStepEntity> findByProcessKeyAndTaskKey(String processKey, String taskKey) {
        return this.dao.findByProcessKeyAndTaskKey(processKey, taskKey);
    }

    public void init() {
        this.dao = (WfConfigStepDao)this.getBeans().get("wfConfigStepDao");
        Assert.notNull((Object)this.dao);
    }

    @Override
    public List<WfConfigStepEntity> findByProcessKeyAndTaskKeyAndNextTaskKey(String processKey, String taskKey, String nextTaskKey) {
        return this.dao.findByProcessKeyAndTaskKeyAndNextTaskKey(processKey, taskKey, nextTaskKey);
    }

    @Override
    public WfConfigStepEntity findOne(String id) {
        return (WfConfigStepEntity)((Object)this.dao.findOne((Serializable)((Object)id)));
    }

    @Override
    public void saveWfConfigStepMap(WfConfigEntity config, String jsonSteps) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processKey", config.getProcessKey());
        params.put("taskKey", config.getTaskKey());
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("delete from T_XTFRAME_WF_CONFIG_STEP WHERE PROCESS_KEY=:processKey and TASK_KEY=:taskKey");
        this.dao.nativeUpdate(sqlBuilder.toString(), params);
        if (StringUtils.hasText((String)jsonSteps)) {
            JSONArray stepArr = JSONArray.fromObject((Object)jsonSteps);
            ArrayList<WfConfigStepEntity> stepEntities = new ArrayList<WfConfigStepEntity>();
            int i = 0;
            while (i < stepArr.size()) {
                String[] infos = stepArr.getString(i).split(",");
                WfConfigStepEntity e = new WfConfigStepEntity();
                e.setProcessKey(config.getProcessKey());
                e.setSortno(i);
                e.setTaskKey(config.getTaskKey());
                e.setValid(true);
                e.setNextTaskKey(infos[0]);
                e.setNextTaskName(infos[1]);
                e.setSfmr("Y".equals(infos[2]));
                stepEntities.add(e);
                ++i;
            }
            this.dao.save(stepEntities);
        }
    }
}

