/*
 * Decompiled with CFR 0.152.
 */
package com.xtframe.sec.realm;

import com.xtframe.core.menu.entity.Function;
import com.xtframe.core.menu.entity.Menu;
import com.xtframe.core.role.entity.Role;
import com.xtframe.core.support.SecurityMgr;
import com.xtframe.core.support.aware.SecurityMgrAware;
import com.xtframe.core.user.entity.User;
import com.xtframe.core.utils.SystemParam;
import com.xtframe.sec.user.entity.UserEntity;
import java.util.ArrayList;
import java.util.List;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;

public class CustomRealm
extends AuthorizingRealm
implements SecurityMgrAware {
    private SecurityMgr securityMgr;

    public void clearAllCachedAuthorizationInfo() {
        Cache cache = this.getAuthorizationCache();
        if (cache != null) {
            for (Object key : cache.keys()) {
                cache.remove(key);
            }
        }
    }

    public void clearCachedAuthorizationInfo(User user) {
        SimplePrincipalCollection principals = new SimplePrincipalCollection((Object)user, this.getName());
        this.clearCachedAuthorizationInfo((PrincipalCollection)principals);
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authcToken) throws AuthenticationException {
        UsernamePasswordToken token = (UsernamePasswordToken)authcToken;
        User user = this.securityMgr.userService().findByUname(token.getUsername());
        if (user != null) {
            return new SimpleAuthenticationInfo((Object)user, (Object)user.getPassword(), this.getName());
        }
        return null;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        UserEntity loginUser = (UserEntity)((Object)principals.fromRealm(this.getName()).iterator().next());
        Session s = SecurityUtils.getSubject().getSession();
        User user = this.securityMgr.userService().findById(loginUser.getId());
        if (user != null) {
            SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
            List roles = this.securityMgr.roleService().findByUserId(user.getId());
            for (Role role : roles) {
                info.addRole(role.getCode());
            }
            List userFuncs = this.securityMgr.menuService().findValidFunctionByUserId(user.getId());
            List orgFuncs = this.securityMgr.menuService().findValidFunctionByOrgId(user.getOrg());
            userFuncs.addAll(orgFuncs);
            List userRoles = this.securityMgr.roleService().findByUserId(user.getId());
            for (Role r : userRoles) {
                List roleFuncs = this.securityMgr.menuService().findValidFunctionByRoleId(r.getId());
                userFuncs.addAll(roleFuncs);
            }
            ArrayList<String> perms = new ArrayList<String>();
            for (Function f : userFuncs) {
                Menu m = this.securityMgr.menuService().findMenu(f.getMenu().getId());
                String perm = String.valueOf(m.getCode()) + ":" + f.getCode();
                if (perms.contains(perm)) continue;
                perms.add(perm);
            }
            for (String p : perms) {
                info.addStringPermission(String.valueOf(SystemParam.getAppName()) + ":" + p);
            }
            s.setAttribute((Object)"_AUTH", (Object)info);
            return info;
        }
        return null;
    }

    public void setSecurityMgr(SecurityMgr securityMgr) {
        this.securityMgr = securityMgr;
    }
}

