/*
 * Decompiled with CFR 0.152.
 */
package com.xtframe.sec.common;

import com.xtframe.core.user.entity.User;
import com.xtframe.util.StringUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationListener;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SystemAuthenticationListener
implements AuthenticationListener {
    private static final Logger LOG = LoggerFactory.getLogger(SystemAuthenticationListener.class);
    private Map<PrincipalCollection, Session> authSubjectMap = new HashMap<PrincipalCollection, Session>();
    private static final String SESSION_FLG = "session_outTime_flg";

    public void onSuccess(AuthenticationToken token, AuthenticationInfo info) {
        Session session = SecurityUtils.getSubject().getSession();
        session.setAttribute((Object)SESSION_FLG, (Object)"");
        this.authSubjectMap.put(info.getPrincipals(), session);
        LOG.debug("use login:" + token.getPrincipal());
        this.cleanCache();
    }

    public void onFailure(AuthenticationToken token, AuthenticationException ae) {
    }

    public void onLogout(PrincipalCollection principals) {
        PrincipalCollection principal = SecurityUtils.getSubject().getPrincipals();
        if (this.authSubjectMap.containsKey(principal)) {
            this.authSubjectMap.remove(principal);
            LOG.debug("use logout:" + principal);
        }
    }

    private void cleanCache() {
        Iterator<Map.Entry<PrincipalCollection, Session>> it = this.authSubjectMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<PrincipalCollection, Session> entry = it.next();
            Session sessionOld = entry.getValue();
            try {
                Object flg = sessionOld.getAttribute((Object)SESSION_FLG);
                if (flg != null) continue;
                it.remove();
                LOG.debug("use timeout:" + entry.getKey());
            }
            catch (InvalidSessionException e) {
                it.remove();
                LOG.debug("use timeout:" + entry.getKey());
            }
            catch (IllegalStateException e) {
                it.remove();
                LOG.debug("use timeout:" + entry.getKey());
            }
        }
    }

    public boolean isLogin(String userLoginName) {
        if (!StringUtils.hasLength((String)userLoginName)) {
            return false;
        }
        this.cleanCache();
        for (Map.Entry<PrincipalCollection, Session> entry : this.authSubjectMap.entrySet()) {
            Object principal = entry.getKey().getPrimaryPrincipal();
            if (!(principal instanceof User)) continue;
            User user = (User)principal;
            return user != null && userLoginName.equals(user.getUname());
        }
        return false;
    }
}

