/*
 * @(#)SheetRoot.java	1.8 98/11/20
 * 
 * Copyright (c) 1998 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 */


package com.sun.xml.xsl;

import org.w3c.dom.*;

import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

import com.sun.xml.tree.*;


/**
 * Instance of this class represent the root of an XSL stylesheet.
 */
final class SheetRoot extends ProcessChildren
{
    private String	strippingWhitespace;
    private String	indentingResult;
    
    
    /**
     * Constructs a XSL stylesheet document.
     */
    public SheetRoot () { }
    
    /**
     * Returns true if whitespace is normally stripped from documents
     * processed with this stylesheet.
     */
    // package private
    boolean isStrippingWhitespace ()
    {
    	if (strippingWhitespace == null) {
    	    strippingWhitespace = getAttribute (StyleSheet.uri,
			"default-space");
    	    if (strippingWhitespace == null)
    	        strippingWhitespace = "preserve";
    	}
    	return "strip".equals (strippingWhitespace);
    }
    
    /**
     * Returns true if the output tree is permitted to indent the
     * result
     */
    // package private
    boolean isIndentingResult ()
    {
    	if (indentingResult == null) {
    	    indentingResult = getAttribute (StyleSheet.uri, "indent-result");
    	    if (indentingResult == null)
    	        indentingResult = "no";
    	}
    	return "yes".equals (indentingResult);
    }
    
    /**
     * Discards all child nodes except those allowed to be children
     * of XSL <em>stylesheet</em> nodes; throws exceptions for illegal
     * element types.
     */
    public void doneChild (NodeEx newChild, ParseContext context)
    throws SAXException
    {
	ElementNode	child;

    	switch (newChild.getNodeType ()) {
    	  case ELEMENT_NODE:
	    child = (ElementNode)newChild;
	    if (StyleSheet.uri.equals (child.getNamespace ())) {
		String name = child.getLocalName ();
		// XXX enforce "imports up front" rule
		if ("template".equals (name)
			    || "import".equals (name)
			    || "include".equals (name)
			    || "id".equals (name)
			    || "skip-space".equals (name)
			    || "preserve-space".equals (name)
			    || "define-macro".equals (name)
			    || "define-attribute-set".equals (name)
			    || "define-constant".equals (name)
			    ) {
		    return;
		}
    	    }
    	    // Illegal input -- but DOM provides no really nice
    	    // way to report that, due to private DOMException
    	    context.getErrorHandler ().fatalError (new SAXParseException (
    	    	"Disallowed child element type: " + child.getNodeName (),
		context.getLocator ()));
    	    
    	  default:
    	    // ignore whitespace etc
	    removeChild (newChild);
    	}
    }
}
