/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.util.AttributeSource;
import org.junit.internal.AssumptionViolatedException;

public class MockTokenizer
extends Tokenizer {
    public static final int WHITESPACE = 0;
    public static final int KEYWORD = 1;
    public static final int SIMPLE = 2;
    private final int pattern;
    private final boolean lowerCase;
    private final int maxTokenLength;
    public static final int DEFAULT_MAX_TOKEN_LENGTH = Integer.MAX_VALUE;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    int off = 0;
    private State streamState = State.CLOSE;
    private int lastOffset = 0;
    private boolean enableChecks = true;

    public MockTokenizer(AttributeSource.AttributeFactory factory, Reader input, int pattern, boolean lowerCase, int maxTokenLength) {
        super(factory, input);
        this.pattern = pattern;
        this.lowerCase = lowerCase;
        this.streamState = State.SETREADER;
        this.maxTokenLength = maxTokenLength;
    }

    public MockTokenizer(Reader input, int pattern, boolean lowerCase, int maxTokenLength) {
        this(AttributeSource.AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY, input, pattern, lowerCase, maxTokenLength);
    }

    public MockTokenizer(Reader input, int pattern, boolean lowerCase) {
        this(input, pattern, lowerCase, Integer.MAX_VALUE);
    }

    public final boolean incrementToken() throws IOException {
        block8: {
            int endOffset;
            int startOffset;
            int cp;
            assert (!this.enableChecks || this.streamState == State.RESET || this.streamState == State.INCREMENT) : "incrementToken() called while in wrong state: " + (Object)((Object)this.streamState);
            this.clearAttributes();
            do {
                startOffset = this.off;
                cp = this.readCodePoint();
                if (cp < 0) break block8;
            } while (!this.isTokenChar(cp));
            do {
                char[] chars = Character.toChars(this.normalize(cp));
                for (int i = 0; i < chars.length; ++i) {
                    this.termAtt.append(chars[i]);
                }
                endOffset = this.off;
            } while (this.termAtt.length() < this.maxTokenLength && (cp = this.readCodePoint()) >= 0 && this.isTokenChar(cp));
            int correctedStartOffset = this.correctOffset(startOffset);
            int correctedEndOffset = this.correctOffset(endOffset);
            assert (correctedStartOffset >= 0);
            assert (correctedEndOffset >= 0);
            assert (correctedStartOffset >= this.lastOffset);
            this.lastOffset = correctedStartOffset;
            assert (correctedEndOffset >= correctedStartOffset);
            this.offsetAtt.setOffset(correctedStartOffset, correctedEndOffset);
            this.streamState = State.INCREMENT;
            return true;
        }
        this.streamState = State.INCREMENT_FALSE;
        return false;
    }

    protected int readCodePoint() throws IOException {
        int ch2;
        int ch = this.input.read();
        if (ch < 0) {
            return ch;
        }
        if (ch == 65535) {
            throw new AssumptionViolatedException("Test data cannot contain '\\uFFFF' (Lucene 3.x only)");
        }
        assert (!Character.isLowSurrogate((char)ch));
        ++this.off;
        if (Character.isHighSurrogate((char)ch) && (ch2 = this.input.read()) >= 0) {
            ++this.off;
            assert (Character.isLowSurrogate((char)ch2));
            return Character.toCodePoint((char)ch, (char)ch2);
        }
        return ch;
    }

    protected boolean isTokenChar(int c) {
        switch (this.pattern) {
            case 0: {
                return !Character.isWhitespace(c);
            }
            case 1: {
                return true;
            }
            case 2: {
                return Character.isLetter(c);
            }
        }
        throw new RuntimeException("invalid pattern constant:" + this.pattern);
    }

    protected int normalize(int c) {
        return this.lowerCase ? Character.toLowerCase(c) : c;
    }

    public void reset() throws IOException {
        super.reset();
        this.off = 0;
        this.lastOffset = 0;
        assert (!this.enableChecks || this.streamState != State.RESET) : "double reset()";
        this.streamState = State.RESET;
    }

    public void close() throws IOException {
        super.close();
        assert (!this.enableChecks || this.streamState == State.END || this.streamState == State.CLOSE) : "close() called in wrong state: " + (Object)((Object)this.streamState);
        this.streamState = State.CLOSE;
    }

    public void reset(Reader input) throws IOException {
        super.reset(input);
        assert (!this.enableChecks || this.streamState == State.CLOSE) : "setReader() called in wrong state: " + (Object)((Object)this.streamState);
        this.streamState = State.SETREADER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() throws IOException {
        int finalOffset = this.correctOffset(this.off);
        this.offsetAtt.setOffset(finalOffset, finalOffset);
        try {
            assert (!this.enableChecks || this.streamState == State.INCREMENT_FALSE) : "end() called before incrementToken() returned false!";
        }
        finally {
            this.streamState = State.END;
        }
    }

    public void setEnableChecks(boolean enableChecks) {
        this.enableChecks = enableChecks;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        SETREADER,
        RESET,
        INCREMENT,
        INCREMENT_FALSE,
        END,
        CLOSE;

    }
}

