/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.smsserver.interfaces;

import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import org.smslib.InboundMessage;
import org.smslib.Message;
import org.smslib.OutboundBinaryMessage;
import org.smslib.OutboundMessage;
import org.smslib.OutboundWapSIMessage;
import org.smslib.StatusReportMessage;
import org.smslib.helper.Logger;
import org.smslib.smsserver.SMSServer;
import org.smslib.smsserver.interfaces.Interface;

public class Database
extends Interface<Integer> {
    static final int SQL_DELAY = 1000;
    int sqlDelayMultiplier = 1;
    private Connection dbCon = null;

    public Database(String myInterfaceId, Properties myProps, SMSServer myServer, Interface.InterfaceTypes myType) {
        super(myInterfaceId, myProps, myServer, myType);
        this.setDescription("Default database interface.");
    }

    @Override
    public void start() throws Exception {
        Connection con = null;
        Class.forName(this.getProperty("driver"));
        while (true) {
            try {
                con = this.getDbConnection();
                Statement cmd = con.createStatement(1003, 1007);
                cmd.executeUpdate("update " + this.getProperty("tables.sms_out", "smsserver_out") + " set status = 'U' where status = 'Q'");
                con.commit();
                cmd.close();
            }
            catch (SQLException e) {
                try {
                    if (con != null) {
                        con.close();
                    }
                    this.closeDbConnection();
                }
                catch (Exception innerE) {
                    // empty catch block
                }
                if (this.getServer().getShutdown()) break;
                Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this.sqlDelayMultiplier * 1), e, null);
                Thread.sleep(this.sqlDelayMultiplier * 1000);
                this.sqlDelayMultiplier *= 2;
                continue;
            }
            break;
        }
        super.start();
    }

    @Override
    public void stop() throws Exception {
        Connection con = null;
        while (true) {
            try {
                con = this.getDbConnection();
                Statement cmd = con.createStatement(1003, 1007);
                cmd.executeUpdate("update " + this.getProperty("tables.sms_out", "smsserver_out") + " set status = 'U' where status = 'Q'");
                con.commit();
                cmd.close();
                this.closeDbConnection();
            }
            catch (SQLException e) {
                try {
                    if (con != null) {
                        con.close();
                    }
                    this.closeDbConnection();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.getServer().getShutdown()) break;
                Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this.sqlDelayMultiplier * 1), e, null);
                Thread.sleep(this.sqlDelayMultiplier * 1000);
                this.sqlDelayMultiplier *= 2;
                continue;
            }
            break;
        }
        super.stop();
    }

    @Override
    public void callReceived(String gtwId, String callerId) throws Exception {
        Connection con = null;
        while (true) {
            try {
                con = this.getDbConnection();
                PreparedStatement cmd = con.prepareStatement("insert into " + this.getProperty("tables.calls", "smsserver_calls") + " (call_date, gateway_id, caller_id) values (?,?,?) ");
                cmd.setTimestamp(1, new Timestamp(new Date().getTime()));
                cmd.setString(2, gtwId);
                cmd.setString(3, callerId);
                cmd.executeUpdate();
                con.commit();
                cmd.close();
            }
            catch (SQLException e) {
                try {
                    if (con != null) {
                        con.close();
                    }
                    this.closeDbConnection();
                }
                catch (Exception innerE) {
                    // empty catch block
                }
                Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this.sqlDelayMultiplier * 1), e, null);
                Thread.sleep(this.sqlDelayMultiplier * 1000);
                this.sqlDelayMultiplier *= 2;
                continue;
            }
            break;
        }
    }

    @Override
    public void messagesReceived(Collection<InboundMessage> msgList) throws Exception {
        Connection con = null;
        while (true) {
            try {
                con = this.getDbConnection();
                PreparedStatement pst = con.prepareStatement(" insert into " + this.getProperty("tables.sms_in", "smsserver_in") + " (process, originator, type, encoding, message_date, receive_date, text," + " original_ref_no, original_receive_date, gateway_id) " + " values(?,?,?,?,?,?,?,?,?,?)");
                for (InboundMessage msg : msgList) {
                    if (msg.getType() != Message.MessageTypes.INBOUND && msg.getType() != Message.MessageTypes.STATUSREPORT) continue;
                    pst.setInt(1, 0);
                    switch (msg.getEncoding()) {
                        case ENC7BIT: {
                            pst.setString(4, "7");
                            break;
                        }
                        case ENC8BIT: {
                            pst.setString(4, "8");
                            break;
                        }
                        case ENCUCS2: {
                            pst.setString(4, "U");
                            break;
                        }
                        case ENCCUSTOM: {
                            pst.setString(4, "C");
                        }
                    }
                    switch (msg.getType()) {
                        case INBOUND: {
                            pst.setString(3, "I");
                            pst.setString(2, msg.getOriginator());
                            if (msg.getDate() != null) {
                                pst.setTimestamp(5, new Timestamp(msg.getDate().getTime()));
                            }
                            pst.setString(8, null);
                            pst.setTimestamp(9, null);
                            break;
                        }
                        case STATUSREPORT: {
                            pst.setString(3, "S");
                            pst.setString(2, ((StatusReportMessage)msg).getRecipient());
                            if (((StatusReportMessage)msg).getSent() != null) {
                                pst.setTimestamp(5, new Timestamp(((StatusReportMessage)msg).getSent().getTime()));
                            }
                            pst.setString(8, ((StatusReportMessage)msg).getRefNo());
                            if (((StatusReportMessage)msg).getReceived() != null) {
                                pst.setTimestamp(9, new Timestamp(((StatusReportMessage)msg).getReceived().getTime()));
                            }
                            if (!this.getProperty("update_outbound_on_statusreport", "no").equalsIgnoreCase("yes")) break;
                            PreparedStatement cmd2 = con.prepareStatement(" update " + this.getProperty("tables.sms_out", "smsserver_out") + " set status = ? " + " where (recipient = ? or recipient = ?) and ref_no = ? and gateway_id = ?");
                            switch (((StatusReportMessage)msg).getStatus()) {
                                case DELIVERED: {
                                    cmd2.setString(1, "D");
                                    break;
                                }
                                case KEEPTRYING: {
                                    cmd2.setString(1, "P");
                                    break;
                                }
                                case ABORTED: {
                                    cmd2.setString(1, "A");
                                    break;
                                }
                            }
                            cmd2.setString(2, ((StatusReportMessage)msg).getRecipient());
                            if (((StatusReportMessage)msg).getRecipient().startsWith("+")) {
                                cmd2.setString(3, ((StatusReportMessage)msg).getRecipient().substring(1));
                            } else {
                                cmd2.setString(3, "+" + ((StatusReportMessage)msg).getRecipient());
                            }
                            cmd2.setString(4, ((StatusReportMessage)msg).getRefNo());
                            cmd2.setString(5, ((StatusReportMessage)msg).getGatewayId());
                            cmd2.executeUpdate();
                            cmd2.close();
                            break;
                        }
                    }
                    pst.setTimestamp(6, new Timestamp(new Date().getTime()));
                    if (msg.getEncoding() == Message.MessageEncodings.ENC8BIT) {
                        pst.setString(7, msg.getPduUserData());
                    } else {
                        pst.setString(7, msg.getText().length() == 0 ? "" : msg.getText());
                    }
                    pst.setString(10, msg.getGatewayId());
                    pst.executeUpdate();
                }
                pst.close();
                con.commit();
            }
            catch (SQLException e) {
                try {
                    if (con != null) {
                        con.close();
                    }
                    this.closeDbConnection();
                }
                catch (Exception innerE) {
                    // empty catch block
                }
                Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this.sqlDelayMultiplier * 1), e, null);
                Thread.sleep(this.sqlDelayMultiplier * 1000);
                this.sqlDelayMultiplier *= 2;
                continue;
            }
            break;
        }
    }

    @Override
    public Collection<OutboundMessage> getMessagesToSend() throws Exception {
        Connection con = null;
        ArrayList<OutboundMessage> msgList = new ArrayList<OutboundMessage>();
        while (true) {
            try {
                int msgCount = 1;
                con = this.getDbConnection();
                Statement cmd = con.createStatement(1005, 1008);
                PreparedStatement pst = con.prepareStatement("update " + this.getProperty("tables.sms_out", "smsserver_out") + " set status = 'Q' where id = ? ");
                ResultSet rs = cmd.executeQuery("select id, type, recipient, text, wap_url, wap_expiry_date, wap_signal, create_date, originator, encoding, status_report, flash_sms, src_port, dst_port, sent_date, ref_no, priority, status, errors, gateway_id from " + this.getProperty("tables.sms_out", "smsserver_out") + " where status = 'U' order by priority desc, id");
                while (rs.next() && msgCount <= Integer.parseInt(this.getProperty("batch_size"))) {
                    OutboundMessage msg;
                    if (!this.getServer().checkPriorityTimeFrame(rs.getInt("priority"))) continue;
                    switch (rs.getString("type").charAt(0)) {
                        case 'O': {
                            switch (rs.getString("encoding").charAt(0)) {
                                case '7': {
                                    msg = new OutboundMessage(rs.getString("recipient").trim(), rs.getString("text").trim());
                                    msg.setEncoding(Message.MessageEncodings.ENC7BIT);
                                    break;
                                }
                                case '8': {
                                    String text = rs.getString("text").trim();
                                    byte[] bytes = new byte[text.length() / 2];
                                    for (int i = 0; i < text.length(); i += 2) {
                                        int value = Integer.parseInt("" + text.charAt(i), 16) * 16 + Integer.parseInt("" + text.charAt(i + 1), 16);
                                        bytes[i / 2] = (byte)value;
                                    }
                                    msg = new OutboundBinaryMessage(rs.getString("recipient").trim(), bytes);
                                    break;
                                }
                                case 'U': {
                                    msg = new OutboundMessage(rs.getString("recipient").trim(), rs.getString("text").trim());
                                    msg.setEncoding(Message.MessageEncodings.ENCUCS2);
                                    break;
                                }
                                default: {
                                    msg = new OutboundMessage(rs.getString("recipient").trim(), rs.getString("text").trim());
                                    msg.setEncoding(Message.MessageEncodings.ENC7BIT);
                                }
                            }
                            if (rs.getInt("flash_sms") == 1) {
                                msg.setFlashSms(true);
                            }
                            if (rs.getInt("src_port") == -1) break;
                            msg.setSrcPort(rs.getInt("src_port"));
                            msg.setDstPort(rs.getInt("dst_port"));
                            break;
                        }
                        case 'W': {
                            OutboundWapSIMessage.WapSISignals wapSignal;
                            Date wapExpiryDate;
                            if (rs.getTime("wap_expiry_date") == null) {
                                Calendar cal = Calendar.getInstance();
                                cal.setTime(new Date());
                                cal.add(6, 7);
                                wapExpiryDate = cal.getTime();
                            } else {
                                wapExpiryDate = rs.getTimestamp("wap_expiry_date");
                            }
                            if (rs.getString("wap_signal") == null) {
                                wapSignal = OutboundWapSIMessage.WapSISignals.NONE;
                            } else {
                                switch (rs.getString("wap_signal").charAt(0)) {
                                    case 'N': {
                                        wapSignal = OutboundWapSIMessage.WapSISignals.NONE;
                                        break;
                                    }
                                    case 'L': {
                                        wapSignal = OutboundWapSIMessage.WapSISignals.LOW;
                                        break;
                                    }
                                    case 'M': {
                                        wapSignal = OutboundWapSIMessage.WapSISignals.MEDIUM;
                                        break;
                                    }
                                    case 'H': {
                                        wapSignal = OutboundWapSIMessage.WapSISignals.HIGH;
                                        break;
                                    }
                                    case 'D': {
                                        wapSignal = OutboundWapSIMessage.WapSISignals.DELETE;
                                        break;
                                    }
                                    default: {
                                        wapSignal = OutboundWapSIMessage.WapSISignals.NONE;
                                    }
                                }
                            }
                            msg = new OutboundWapSIMessage(rs.getString("recipient").trim(), new URL(rs.getString("wap_url").trim()), rs.getString("text").trim(), wapExpiryDate, wapSignal);
                            break;
                        }
                        default: {
                            throw new Exception("Message type '" + rs.getString("type") + "' is unknown!");
                        }
                    }
                    msg.setPriority(rs.getInt("priority"));
                    if (rs.getInt("status_report") == 1) {
                        msg.setStatusReport(true);
                    }
                    if (rs.getString("originator") != null && rs.getString("originator").length() > 0) {
                        msg.setFrom(rs.getString("originator").trim());
                    }
                    msg.setGatewayId(rs.getString("gateway_id").trim());
                    msgList.add(msg);
                    this.getMessageCache().put(msg.getMessageId(), rs.getInt("id"));
                    pst.setInt(1, rs.getInt("id"));
                    pst.executeUpdate();
                    con.commit();
                    ++msgCount;
                }
                con.commit();
                rs.close();
                cmd.close();
                pst.close();
            }
            catch (SQLException e) {
                try {
                    if (con != null) {
                        con.close();
                    }
                    this.closeDbConnection();
                }
                catch (Exception innerE) {
                    // empty catch block
                }
                Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this.sqlDelayMultiplier * 1), e, null);
                Thread.sleep(this.sqlDelayMultiplier * 1000);
                this.sqlDelayMultiplier *= 2;
                continue;
            }
            break;
        }
        return msgList;
    }

    @Override
    public int getPendingMessagesToSend() throws Exception {
        Connection con = null;
        int count = -1;
        while (true) {
            try {
                con = this.getDbConnection();
                Statement cmd = con.createStatement(1005, 1007);
                ResultSet rs = cmd.executeQuery("select count(*) as cnt from " + this.getProperty("tables.sms_out", "smsserver_out") + " where status in ('U', 'Q')");
                if (rs.next()) {
                    count = rs.getInt("cnt");
                }
                rs.close();
                cmd.close();
            }
            catch (SQLException e) {
                try {
                    if (con != null) {
                        con.close();
                    }
                    this.closeDbConnection();
                }
                catch (Exception innerE) {
                    // empty catch block
                }
                Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this.sqlDelayMultiplier * 1), e, null);
                Thread.sleep(this.sqlDelayMultiplier * 1000);
                this.sqlDelayMultiplier *= 2;
                continue;
            }
            break;
        }
        return count;
    }

    @Override
    public void markMessage(OutboundMessage msg) throws Exception {
        Connection con = null;
        if (this.getMessageCache().get(msg.getMessageId()) == null) {
            return;
        }
        while (true) {
            try {
                con = this.getDbConnection();
                PreparedStatement selectStatement = con.prepareStatement("select errors from " + this.getProperty("tables.sms_out", "smsserver_out") + " where id = ?");
                selectStatement.setInt(1, (Integer)this.getMessageCache().get(msg.getMessageId()));
                ResultSet rs = selectStatement.executeQuery();
                rs.next();
                int errors = rs.getInt("errors");
                rs.close();
                selectStatement.close();
                if (msg.getMessageStatus() == OutboundMessage.MessageStatuses.SENT) {
                    PreparedStatement updateStatement = con.prepareStatement("update " + this.getProperty("tables.sms_out", "smsserver_out") + " set status = ?, sent_date = ?, gateway_id = ?, ref_no = ? where id = ?");
                    updateStatement.setString(1, "S");
                    updateStatement.setTimestamp(2, new Timestamp(msg.getDispatchDate().getTime()));
                    updateStatement.setString(3, msg.getGatewayId());
                    updateStatement.setString(4, msg.getRefNo());
                    updateStatement.setInt(5, (Integer)this.getMessageCache().get(msg.getMessageId()));
                    updateStatement.executeUpdate();
                    con.commit();
                    updateStatement.close();
                    break;
                }
                if (msg.getMessageStatus() == OutboundMessage.MessageStatuses.UNSENT || msg.getMessageStatus() == OutboundMessage.MessageStatuses.FAILED && msg.getFailureCause() == OutboundMessage.FailureCauses.NO_ROUTE) {
                    PreparedStatement updateStatement = con.prepareStatement("update " + this.getProperty("tables.sms_out", "smsserver_out") + " set status = ? where id = ?");
                    updateStatement.setString(1, "U");
                    updateStatement.setInt(2, (Integer)this.getMessageCache().get(msg.getMessageId()));
                    updateStatement.executeUpdate();
                    con.commit();
                    updateStatement.close();
                    break;
                }
                PreparedStatement updateStatement = con.prepareStatement("update " + this.getProperty("tables.sms_out", "smsserver_out") + " set status = ?, errors = ? where id = ?");
                if (++errors > Integer.parseInt(this.getProperty("retries", "2"))) {
                    updateStatement.setString(1, "F");
                } else {
                    updateStatement.setString(1, "U");
                }
                updateStatement.setInt(2, errors);
                updateStatement.setInt(3, (Integer)this.getMessageCache().get(msg.getMessageId()));
                updateStatement.executeUpdate();
                con.commit();
                updateStatement.close();
            }
            catch (SQLException e) {
                try {
                    if (con != null) {
                        con.close();
                    }
                    this.closeDbConnection();
                }
                catch (Exception innerE) {
                    // empty catch block
                }
                Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this.sqlDelayMultiplier * 1), e, null);
                Thread.sleep(this.sqlDelayMultiplier * 1000);
                this.sqlDelayMultiplier *= 2;
                continue;
            }
            break;
        }
        this.getMessageCache().remove(msg.getMessageId());
    }

    private Connection getDbConnection() throws SQLException {
        if (this.dbCon == null) {
            this.dbCon = DriverManager.getConnection(this.getProperty("url"), this.getProperty("username", ""), this.getProperty("password", ""));
            this.dbCon.setAutoCommit(false);
            this.sqlDelayMultiplier = 1;
        }
        return this.dbCon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDbConnection() {
        try {
            if (this.dbCon != null) {
                this.dbCon.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.dbCon = null;
        }
    }
}

