/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.core.nodes;

import java.util.List;
import org.apache.lucene.queryParser.core.nodes.FieldableNode;
import org.apache.lucene.queryParser.core.nodes.QueryNode;
import org.apache.lucene.queryParser.core.nodes.QueryNodeImpl;
import org.apache.lucene.queryParser.core.parser.EscapeQuerySyntax;

public class TokenizedPhraseQueryNode
extends QueryNodeImpl
implements FieldableNode {
    private static final long serialVersionUID = -7185108320787917541L;

    public TokenizedPhraseQueryNode() {
        this.setLeaf(false);
        this.allocate();
    }

    public String toString() {
        if (this.getChildren() == null || this.getChildren().size() == 0) {
            return "<tokenizedphrase/>";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<tokenizedtphrase>");
        for (QueryNode child : this.getChildren()) {
            sb.append("\n");
            sb.append(((Object)child).toString());
        }
        sb.append("\n</tokenizedphrase>");
        return sb.toString();
    }

    public CharSequence toQueryString(EscapeQuerySyntax escapeSyntaxParser) {
        if (this.getChildren() == null || this.getChildren().size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String filler = "";
        for (QueryNode child : this.getChildren()) {
            sb.append(filler).append(child.toQueryString(escapeSyntaxParser));
            filler = ",";
        }
        return "[TP[" + sb.toString() + "]]";
    }

    public QueryNode cloneTree() throws CloneNotSupportedException {
        TokenizedPhraseQueryNode clone = (TokenizedPhraseQueryNode)super.cloneTree();
        return clone;
    }

    public CharSequence getField() {
        List<QueryNode> children = this.getChildren();
        if (children == null || children.size() == 0) {
            return null;
        }
        return ((FieldableNode)children.get(0)).getField();
    }

    public void setField(CharSequence fieldName) {
        List<QueryNode> children = this.getChildren();
        if (children != null) {
            for (QueryNode child : this.getChildren()) {
                if (!(child instanceof FieldableNode)) continue;
                ((FieldableNode)child).setField(fieldName);
            }
        }
    }
}

