/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.reflectionassert.util;

import org.unitils.core.UnitilsException;

public class HibernateUtil {
    protected static Class<?> hibernateProxyClass;

    public static boolean isHibernateProxy(Object object) {
        return hibernateProxyClass != null && hibernateProxyClass.isInstance(object);
    }

    public static boolean isUninitialized(Object object) {
        if (!HibernateUtil.isHibernateProxy(object)) {
            return false;
        }
        return (Boolean)HibernateUtil.invokeLazyInitializerMethod("isUninitialized", object);
    }

    public static String getEntitiyName(Object object) {
        if (!HibernateUtil.isHibernateProxy(object)) {
            return object == null ? null : object.getClass().getName();
        }
        return (String)HibernateUtil.invokeLazyInitializerMethod("getEntityName", object);
    }

    public static Object getIdentifier(Object object) {
        if (!HibernateUtil.isHibernateProxy(object)) {
            return null;
        }
        return HibernateUtil.invokeLazyInitializerMethod("getIdentifier", object);
    }

    public static Object getUnproxiedValue(Object object) {
        if (!HibernateUtil.isHibernateProxy(object)) {
            return object;
        }
        return HibernateUtil.invokeLazyInitializerMethod("getImplementation", object);
    }

    protected static Object invokeLazyInitializerMethod(String methodName, Object proxy) {
        try {
            Object lazyInitializer = hibernateProxyClass.getMethod("getHibernateLazyInitializer", new Class[0]).invoke(proxy, new Object[0]);
            return lazyInitializer.getClass().getMethod(methodName, new Class[0]).invoke(lazyInitializer, new Object[0]);
        }
        catch (Exception e) {
            throw new UnitilsException("Unable to invoke method on lazy initializer of Hibernate proxy. Method: " + methodName + ", proxy: " + proxy, e);
        }
    }

    static {
        try {
            hibernateProxyClass = Class.forName("org.hibernate.proxy.HibernateProxy");
        }
        catch (ClassNotFoundException e) {
            hibernateProxyClass = null;
        }
    }
}

