/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jtype;

import com.googlecode.jtype.ClassUtils;
import com.googlecode.jtype.DefaultGenericArrayType;
import com.googlecode.jtype.DefaultParameterizedType;
import com.googlecode.jtype.DefaultTypeVariable;
import com.googlecode.jtype.DefaultWildcardType;
import com.googlecode.jtype.TypeUtils;
import com.googlecode.jtype.Utils;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Types {
    private Types() {
        throw new AssertionError();
    }

    public static <D extends GenericDeclaration> TypeVariable<D> typeVariable(D declaration, String name, Type ... bounds) {
        return new DefaultTypeVariable<D>(declaration, name, bounds);
    }

    public static GenericArrayType genericArrayType(Type componentType) {
        return new DefaultGenericArrayType(componentType);
    }

    public static ParameterizedType parameterizedType(Class<?> rawType, Type ... actualTypeArguments) {
        return new DefaultParameterizedType(null, rawType, actualTypeArguments);
    }

    public static WildcardType unboundedWildcardType() {
        return Types.wildcardType(null, null);
    }

    public static WildcardType upperBoundedWildcardType(Type upperBound) {
        Utils.checkNotNull(upperBound, "upperBound");
        return Types.wildcardType(new Type[]{upperBound}, null);
    }

    public static WildcardType lowerBoundedWildcardType(Type lowerBound) {
        Utils.checkNotNull(lowerBound, "lowerBound");
        return Types.wildcardType(null, new Type[]{lowerBound});
    }

    public static Type valueOf(String typeName) {
        return Types.valueOf(typeName, Collections.<String>emptySet());
    }

    public static Type valueOf(String typeName, Set<String> imports) {
        HashMap<String, String> importMap = new HashMap<String, String>();
        for (String className : imports) {
            String unqualifiedClassName = ClassUtils.getUnqualifiedClassName(className);
            if (importMap.containsKey(unqualifiedClassName)) {
                throw new IllegalArgumentException("Duplicate imports: " + (String)importMap.get(unqualifiedClassName) + " and " + className);
            }
            importMap.put(unqualifiedClassName, className);
        }
        return Types.valueOf(typeName, importMap);
    }

    private static WildcardType wildcardType(Type[] upperBounds, Type[] lowerBounds) {
        return new DefaultWildcardType(upperBounds, lowerBounds);
    }

    private static Type valueOf(String typeName, Map<String, String> imports) {
        if (typeName.endsWith("[]")) {
            String componentName = typeName.substring(0, typeName.length() - "[]".length());
            Type componentType = Types.valueOf(componentName, imports);
            return TypeUtils.getArrayType(componentType);
        }
        if (typeName.startsWith("?")) {
            return Types.parseWildcardType(typeName, imports);
        }
        int argStart = typeName.indexOf(60);
        if (argStart == -1) {
            return Types.parseClass(typeName, imports);
        }
        int argEnd = typeName.lastIndexOf(62);
        if (argEnd == -1) {
            throw new IllegalArgumentException("Mismatched type argument delimiters: " + typeName);
        }
        String rawTypeName = typeName.substring(0, argStart);
        Class<?> rawType = Types.parseClass(rawTypeName, imports);
        String[] actualTypeArgumentNames = typeName.substring(argStart + 1, argEnd).split(",");
        Type[] actualTypeArguments = new Type[actualTypeArgumentNames.length];
        for (int i = 0; i < actualTypeArgumentNames.length; ++i) {
            actualTypeArguments[i] = Types.valueOf(actualTypeArgumentNames[i], imports);
        }
        return Types.parameterizedType(rawType, actualTypeArguments);
    }

    private static Class<?> parseClass(String className, Map<String, String> imports) {
        String qualifiedClassName;
        Class<?> klass = Types.parseClass(className);
        if (klass != null) {
            return klass;
        }
        if (!className.contains(".") && imports.containsKey(className) && (klass = Types.parseClass(qualifiedClassName = imports.get(className))) != null) {
            return klass;
        }
        throw new IllegalArgumentException("Class not found: " + className);
    }

    private static Class<?> parseClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException exception) {
            return null;
        }
    }

    private static WildcardType parseWildcardType(String typeName, Map<String, String> imports) {
        Type[] lowerBounds;
        Type[] upperBounds;
        if ("?".equals(typeName)) {
            upperBounds = null;
            lowerBounds = null;
        } else if (typeName.startsWith("? extends ")) {
            String upperBoundName = typeName.substring("? extends ".length());
            Type upperBound = Types.valueOf(upperBoundName, imports);
            upperBounds = new Type[]{upperBound};
            lowerBounds = null;
        } else if (typeName.startsWith("? super ")) {
            String lowerBoundName = typeName.substring("? super ".length());
            Type lowerBound = Types.valueOf(lowerBoundName, imports);
            upperBounds = null;
            lowerBounds = new Type[]{lowerBound};
        } else {
            throw new IllegalArgumentException("Invalid wildcard type: " + typeName);
        }
        return Types.wildcardType(upperBounds, lowerBounds);
    }
}

