/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.PayloadApplicationEvent;
import org.springframework.context.event.EventExpressionEvaluator;
import org.springframework.context.event.EventListener;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.context.expression.AnnotatedElementKey;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.expression.EvaluationContext;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class ApplicationListenerMethodAdapter
implements GenericApplicationListener {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final String beanName;
    private final Method method;
    private final Class<?> targetClass;
    private final Method bridgedMethod;
    private final ResolvableType declaredEventType;
    private final AnnotatedElementKey methodKey;
    private ApplicationContext applicationContext;
    private EventExpressionEvaluator evaluator;
    private String condition;

    public ApplicationListenerMethodAdapter(String beanName, Class<?> targetClass, Method method) {
        this.beanName = beanName;
        this.method = method;
        this.targetClass = targetClass;
        this.bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)method);
        this.declaredEventType = this.resolveDeclaredEventType();
        this.methodKey = new AnnotatedElementKey(this.method, this.targetClass);
    }

    void init(ApplicationContext applicationContext, EventExpressionEvaluator evaluator) {
        this.applicationContext = applicationContext;
        this.evaluator = evaluator;
    }

    @Override
    public void onApplicationEvent(ApplicationEvent event) {
        this.processEvent(event);
    }

    public void processEvent(ApplicationEvent event) {
        Object[] args = this.resolveArguments(event);
        if (this.shouldHandle(event, args)) {
            Object result = this.doInvoke(args);
            if (result != null) {
                this.handleResult(result);
            } else {
                this.logger.trace((Object)"No result object given - no result to handle");
            }
        }
    }

    protected Object[] resolveArguments(ApplicationEvent event) {
        if (!ApplicationEvent.class.isAssignableFrom(this.declaredEventType.getRawClass()) && event instanceof PayloadApplicationEvent) {
            Object payload = ((PayloadApplicationEvent)event).getPayload();
            if (this.declaredEventType.isAssignableFrom(ResolvableType.forClass(payload.getClass()))) {
                return new Object[]{payload};
            }
        } else {
            return new Object[]{event};
        }
        return null;
    }

    protected void handleResult(Object result) {
        Assert.notNull((Object)this.applicationContext, (String)"ApplicationContext must no be null.");
        if (result.getClass().isArray()) {
            Object[] events;
            for (Object event : events = ObjectUtils.toObjectArray((Object)result)) {
                this.publishEvent(event);
            }
        } else if (result instanceof Collection) {
            Collection events = (Collection)result;
            for (Object event : events) {
                this.publishEvent(event);
            }
        } else {
            this.publishEvent(result);
        }
    }

    private void publishEvent(Object event) {
        if (event != null) {
            this.applicationContext.publishEvent(event);
        }
    }

    private boolean shouldHandle(ApplicationEvent event, Object[] args) {
        if (args == null) {
            return false;
        }
        String condition = this.getCondition();
        if (StringUtils.hasText((String)condition)) {
            Assert.notNull((Object)this.evaluator, (String)"Evaluator must no be null.");
            EvaluationContext evaluationContext = this.evaluator.createEvaluationContext(event, this.targetClass, this.method, args);
            return this.evaluator.condition(condition, this.methodKey, evaluationContext);
        }
        return true;
    }

    @Override
    public boolean supportsEventType(ResolvableType eventType) {
        if (this.declaredEventType.isAssignableFrom(eventType)) {
            return true;
        }
        if (PayloadApplicationEvent.class.isAssignableFrom(eventType.getRawClass())) {
            ResolvableType payloadType = eventType.as(PayloadApplicationEvent.class).getGeneric(new int[0]);
            return eventType.hasUnresolvableGenerics() || this.declaredEventType.isAssignableFrom(payloadType);
        }
        return false;
    }

    @Override
    public boolean supportsSourceType(Class<?> sourceType) {
        return true;
    }

    public int getOrder() {
        Order order = this.getMethodAnnotation(Order.class);
        return order != null ? order.value() : 0;
    }

    protected <A extends Annotation> A getMethodAnnotation(Class<A> annotationType) {
        return (A)AnnotationUtils.findAnnotation((Method)this.method, annotationType);
    }

    protected Object doInvoke(Object ... args) {
        Object bean = this.getTargetBean();
        ReflectionUtils.makeAccessible((Method)this.bridgedMethod);
        try {
            return this.bridgedMethod.invoke(bean, args);
        }
        catch (IllegalArgumentException ex) {
            this.assertTargetBean(this.bridgedMethod, bean, args);
            throw new IllegalStateException(this.getInvocationErrorMessage(bean, ex.getMessage(), args), ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException(this.getInvocationErrorMessage(bean, ex.getMessage(), args), ex);
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            String msg = this.getInvocationErrorMessage(bean, "Failed to invoke event listener method", args);
            throw new UndeclaredThrowableException(targetException, msg);
        }
    }

    protected Object getTargetBean() {
        Assert.notNull((Object)this.applicationContext, (String)"ApplicationContext must no be null.");
        return this.applicationContext.getBean(this.beanName);
    }

    protected String getCondition() {
        AnnotationAttributes annotationAttributes;
        if (this.condition == null && (annotationAttributes = AnnotatedElementUtils.findAnnotationAttributes((AnnotatedElement)this.method, EventListener.class)) != null) {
            String value = annotationAttributes.getString("condition");
            this.condition = value != null ? value : "";
        }
        return this.condition;
    }

    protected String getDetailedErrorMessage(Object bean, String message) {
        StringBuilder sb = new StringBuilder(message).append("\n");
        sb.append("HandlerMethod details: \n");
        sb.append("Bean [").append(bean.getClass().getName()).append("]\n");
        sb.append("Method [").append(this.bridgedMethod.toGenericString()).append("]\n");
        return sb.toString();
    }

    private void assertTargetBean(Method method, Object targetBean, Object[] args) {
        Class<?> targetBeanClass;
        Class<?> methodDeclaringClass = method.getDeclaringClass();
        if (!methodDeclaringClass.isAssignableFrom(targetBeanClass = targetBean.getClass())) {
            String msg = "The event listener method class '" + methodDeclaringClass.getName() + "' is not an instance of the actual bean instance '" + targetBeanClass.getName() + "'. If the bean requires proxying " + "(e.g. due to @Transactional), please use class-based proxying.";
            throw new IllegalStateException(this.getInvocationErrorMessage(targetBean, msg, args));
        }
    }

    private String getInvocationErrorMessage(Object bean, String message, Object[] resolvedArgs) {
        StringBuilder sb = new StringBuilder(this.getDetailedErrorMessage(bean, message));
        sb.append("Resolved arguments: \n");
        for (int i = 0; i < resolvedArgs.length; ++i) {
            sb.append("[").append(i).append("] ");
            if (resolvedArgs[i] == null) {
                sb.append("[null] \n");
                continue;
            }
            sb.append("[type=").append(resolvedArgs[i].getClass().getName()).append("] ");
            sb.append("[value=").append(resolvedArgs[i]).append("]\n");
        }
        return sb.toString();
    }

    private ResolvableType resolveDeclaredEventType() {
        int count = this.method.getParameterTypes().length;
        if (count != 1) {
            throw new IllegalStateException("Only one parameter is allowed for event listener method: " + this.method);
        }
        return ResolvableType.forMethodParameter((Method)this.method, (int)0);
    }

    public String toString() {
        return this.method.toGenericString();
    }
}

