/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.HistoricProcessInstanceQueryImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;

public class HistoricProcessInstanceEntityManager
extends AbstractManager {
    public HistoricProcessInstanceEntity findHistoricProcessInstance(String processInstanceId) {
        if (this.getHistoryManager().isHistoryEnabled()) {
            return this.getDbSqlSession().selectById(HistoricProcessInstanceEntity.class, processInstanceId);
        }
        return null;
    }

    public void deleteHistoricProcessInstanceByProcessDefinitionId(String processDefinitionId) {
        if (this.getHistoryManager().isHistoryEnabled()) {
            List historicProcessInstanceIds = this.getDbSqlSession().selectList("selectHistoricProcessInstanceIdsByProcessDefinitionId", processDefinitionId);
            for (String historicProcessInstanceId : historicProcessInstanceIds) {
                this.deleteHistoricProcessInstanceById(historicProcessInstanceId);
            }
        }
    }

    public void deleteHistoricProcessInstanceById(String historicProcessInstanceId) {
        if (this.getHistoryManager().isHistoryEnabled()) {
            CommandContext commandContext = Context.getCommandContext();
            HistoricProcessInstanceEntity historicProcessInstance = this.findHistoricProcessInstance(historicProcessInstanceId);
            commandContext.getHistoricDetailEntityManager().deleteHistoricDetailsByProcessInstanceId(historicProcessInstanceId);
            commandContext.getHistoricVariableInstanceEntityManager().deleteHistoricVariableInstanceByProcessInstanceId(historicProcessInstanceId);
            commandContext.getHistoricActivityInstanceEntityManager().deleteHistoricActivityInstancesByProcessInstanceId(historicProcessInstanceId);
            commandContext.getHistoricTaskInstanceEntityManager().deleteHistoricTaskInstancesByProcessInstanceId(historicProcessInstanceId);
            commandContext.getHistoricIdentityLinkEntityManager().deleteHistoricIdentityLinksByProcInstance(historicProcessInstanceId);
            commandContext.getCommentEntityManager().deleteCommentsByProcessInstanceId(historicProcessInstanceId);
            this.getDbSqlSession().delete(historicProcessInstance);
            HistoricProcessInstanceQueryImpl subProcessesQueryImpl = new HistoricProcessInstanceQueryImpl();
            subProcessesQueryImpl.superProcessInstanceId(historicProcessInstanceId);
            List selectList = this.getDbSqlSession().selectList("selectHistoricProcessInstancesByQueryCriteria", subProcessesQueryImpl);
            for (HistoricProcessInstance child : selectList) {
                this.deleteHistoricProcessInstanceById(child.getId());
            }
        }
    }

    public long findHistoricProcessInstanceCountByQueryCriteria(HistoricProcessInstanceQueryImpl historicProcessInstanceQuery) {
        if (this.getHistoryManager().isHistoryEnabled()) {
            return (Long)this.getDbSqlSession().selectOne("selectHistoricProcessInstanceCountByQueryCriteria", historicProcessInstanceQuery);
        }
        return 0L;
    }

    public List<HistoricProcessInstance> findHistoricProcessInstancesByQueryCriteria(HistoricProcessInstanceQueryImpl historicProcessInstanceQuery) {
        if (this.getHistoryManager().isHistoryEnabled()) {
            return this.getDbSqlSession().selectList("selectHistoricProcessInstancesByQueryCriteria", historicProcessInstanceQuery);
        }
        return Collections.EMPTY_LIST;
    }

    public List<HistoricProcessInstance> findHistoricProcessInstancesAndVariablesByQueryCriteria(HistoricProcessInstanceQueryImpl historicProcessInstanceQuery) {
        if (this.getHistoryManager().isHistoryEnabled()) {
            if (historicProcessInstanceQuery.getFirstResult() < 0 || historicProcessInstanceQuery.getMaxResults() <= 0) {
                return Collections.EMPTY_LIST;
            }
            int firstResult = historicProcessInstanceQuery.getFirstResult();
            int maxResults = historicProcessInstanceQuery.getMaxResults();
            historicProcessInstanceQuery.setMaxResults(20000);
            historicProcessInstanceQuery.setFirstResult(0);
            List instanceList = this.getDbSqlSession().selectListWithRawParameterWithoutFilter("selectHistoricProcessInstancesWithVariablesByQueryCriteria", historicProcessInstanceQuery, historicProcessInstanceQuery.getFirstResult(), historicProcessInstanceQuery.getMaxResults());
            if (instanceList != null && instanceList.size() > 0) {
                if (firstResult > 0) {
                    if (firstResult <= instanceList.size()) {
                        int toIndex = firstResult + Math.min(maxResults, instanceList.size() - firstResult);
                        return instanceList.subList(firstResult, toIndex);
                    }
                    return Collections.EMPTY_LIST;
                }
                int toIndex = Math.min(maxResults, instanceList.size());
                return instanceList.subList(0, toIndex);
            }
        }
        return Collections.EMPTY_LIST;
    }

    public List<HistoricProcessInstance> findHistoricProcessInstancesByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbSqlSession().selectListWithRawParameter("selectHistoricProcessInstanceByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public long findHistoricProcessInstanceCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectHistoricProcessInstanceCountByNativeQuery", parameterMap);
    }
}

