/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.validation;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.client.util.AbstractCasFilter;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.util.ReflectUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;

public abstract class AbstractTicketValidationFilter
extends AbstractCasFilter {
    private TicketValidator ticketValidator;
    private boolean redirectAfterValidation = true;
    private boolean exceptionOnValidationFailure = false;
    private boolean useSession = true;

    protected TicketValidator getTicketValidator(FilterConfig filterConfig) {
        return this.ticketValidator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getSSLConfig(FilterConfig filterConfig) {
        Properties properties = new Properties();
        String fileName = this.getPropertyFromInitParams(filterConfig, "sslConfigFile", null);
        if (fileName != null) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(fileName);
                properties.load(fis);
                this.logger.trace("Loaded {} entries from {}", (Object)properties.size(), (Object)fileName);
            }
            catch (IOException ioe) {
                try {
                    this.logger.error(ioe.getMessage(), (Throwable)ioe);
                }
                catch (Throwable throwable) {
                    CommonUtils.closeQuietly(fis);
                    throw throwable;
                }
                CommonUtils.closeQuietly(fis);
            }
            CommonUtils.closeQuietly(fis);
        }
        return properties;
    }

    protected HostnameVerifier getHostnameVerifier(FilterConfig filterConfig) {
        String className = this.getPropertyFromInitParams(filterConfig, "hostnameVerifier", null);
        this.logger.trace("Using hostnameVerifier parameter: {}", (Object)className);
        String config = this.getPropertyFromInitParams(filterConfig, "hostnameVerifierConfig", null);
        this.logger.trace("Using hostnameVerifierConfig parameter: {}", (Object)config);
        if (className != null) {
            if (config != null) {
                return (HostnameVerifier)ReflectUtils.newInstance(className, config);
            }
            return (HostnameVerifier)ReflectUtils.newInstance(className, new Object[0]);
        }
        return null;
    }

    protected void initInternal(FilterConfig filterConfig) throws ServletException {
        this.setExceptionOnValidationFailure(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "exceptionOnValidationFailure", "false")));
        this.logger.trace("Setting exceptionOnValidationFailure parameter: {}", (Object)this.exceptionOnValidationFailure);
        this.setRedirectAfterValidation(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "redirectAfterValidation", "true")));
        this.logger.trace("Setting redirectAfterValidation parameter: {}", (Object)this.redirectAfterValidation);
        this.setUseSession(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "useSession", "true")));
        this.logger.trace("Setting useSession parameter: {}", (Object)this.useSession);
        if (!this.useSession && this.redirectAfterValidation) {
            this.logger.warn("redirectAfterValidation parameter may not be true when useSession parameter is false. Resetting it to false in order to prevent infinite redirects.");
            this.setRedirectAfterValidation(false);
        }
        this.setTicketValidator(this.getTicketValidator(filterConfig));
        super.initInternal(filterConfig);
    }

    public void init() {
        super.init();
        CommonUtils.assertNotNull(this.ticketValidator, "ticketValidator cannot be null.");
    }

    protected boolean preFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        return true;
    }

    protected void onSuccessfulValidation(HttpServletRequest request, HttpServletResponse response, Assertion assertion) {
    }

    protected void onFailedValidation(HttpServletRequest request, HttpServletResponse response) {
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!this.preFilter(servletRequest, servletResponse, filterChain)) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String ticket = this.retrieveTicketFromRequest(request);
        if (CommonUtils.isNotBlank(ticket)) {
            this.logger.debug("Attempting to validate ticket: {}", (Object)ticket);
            try {
                Assertion assertion = this.ticketValidator.validate(ticket, this.constructServiceUrl(request, response));
                this.logger.debug("Successfully authenticated user: {}", (Object)assertion.getPrincipal().getName());
                request.setAttribute("_const_cas_assertion_", (Object)assertion);
                if (this.useSession) {
                    request.getSession().setAttribute("_const_cas_assertion_", (Object)assertion);
                }
                this.onSuccessfulValidation(request, response, assertion);
                if (this.redirectAfterValidation) {
                    this.logger.debug("Redirecting after successful ticket validation.");
                    response.sendRedirect(this.constructServiceUrl(request, response));
                    return;
                }
            }
            catch (TicketValidationException e) {
                this.logger.debug(e.getMessage(), (Throwable)e);
                this.onFailedValidation(request, response);
                if (this.exceptionOnValidationFailure) {
                    throw new ServletException((Throwable)e);
                }
                response.sendError(403, e.getMessage());
                return;
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public final void setTicketValidator(TicketValidator ticketValidator) {
        this.ticketValidator = ticketValidator;
    }

    public final void setRedirectAfterValidation(boolean redirectAfterValidation) {
        this.redirectAfterValidation = redirectAfterValidation;
    }

    public final void setExceptionOnValidationFailure(boolean exceptionOnValidationFailure) {
        this.exceptionOnValidationFailure = exceptionOnValidationFailure;
    }

    public final void setUseSession(boolean useSession) {
        this.useSession = useSession;
    }
}

