/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.client.proxy.ProxyGrantingTicketStorage;
import org.jasig.cas.client.ssl.HttpURLConnectionFactory;
import org.jasig.cas.client.ssl.HttpsURLConnectionFactory;
import org.jasig.cas.client.validation.ProxyList;
import org.jasig.cas.client.validation.ProxyListEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommonUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonUtils.class);
    private static final String PARAM_PROXY_GRANTING_TICKET_IOU = "pgtIou";
    private static final String PARAM_PROXY_GRANTING_TICKET = "pgtId";
    private static final HttpURLConnectionFactory DEFAULT_URL_CONNECTION_FACTORY = new HttpsURLConnectionFactory();

    private CommonUtils() {
    }

    public static String formatForUtcTime(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(date);
    }

    public static void assertNotNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertNotEmpty(Collection<?> c, String message) {
        CommonUtils.assertNotNull(c, message);
        if (c.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertTrue(boolean cond, String message) {
        if (!cond) {
            throw new IllegalArgumentException(message);
        }
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isNotEmpty(String string) {
        return !CommonUtils.isEmpty(string);
    }

    public static boolean isBlank(String string) {
        return CommonUtils.isEmpty(string) || string.trim().length() == 0;
    }

    public static boolean isNotBlank(String string) {
        return !CommonUtils.isBlank(string);
    }

    public static String constructRedirectUrl(String casServerLoginUrl, String serviceParameterName, String serviceUrl, boolean renew, boolean gateway) {
        return casServerLoginUrl + (casServerLoginUrl.contains("?") ? "&" : "?") + serviceParameterName + "=" + CommonUtils.urlEncode(serviceUrl) + (renew ? "&renew=true" : "") + (gateway ? "&gateway=true" : "");
    }

    public static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void readAndRespondToProxyReceptorRequest(HttpServletRequest request, HttpServletResponse response, ProxyGrantingTicketStorage proxyGrantingTicketStorage) throws IOException {
        String proxyGrantingTicketIou = request.getParameter(PARAM_PROXY_GRANTING_TICKET_IOU);
        String proxyGrantingTicket = request.getParameter(PARAM_PROXY_GRANTING_TICKET);
        if (CommonUtils.isBlank(proxyGrantingTicket) || CommonUtils.isBlank(proxyGrantingTicketIou)) {
            response.getWriter().write("");
            return;
        }
        LOGGER.debug("Received proxyGrantingTicketId [{}] for proxyGrantingTicketIou [{}]", (Object)proxyGrantingTicket, (Object)proxyGrantingTicketIou);
        proxyGrantingTicketStorage.save(proxyGrantingTicketIou, proxyGrantingTicket);
        LOGGER.debug("Successfully saved proxyGrantingTicketId [{}] for proxyGrantingTicketIou [{}]", (Object)proxyGrantingTicket, (Object)proxyGrantingTicketIou);
        response.getWriter().write("<?xml version=\"1.0\"?>");
        response.getWriter().write("<casClient:proxySuccess xmlns:casClient=\"http://www.yale.edu/tp/casClient\" />");
    }

    protected static String findMatchingServerName(HttpServletRequest request, String serverName) {
        String[] serverNames = serverName.split(" ");
        if (serverNames == null || serverNames.length == 0 || serverNames.length == 1) {
            return serverName;
        }
        String host = request.getHeader("Host");
        String xHost = request.getHeader("X-Forwarded-Host");
        String comparisonHost = xHost != null && host == "localhost" ? xHost : host;
        if (comparisonHost == null) {
            return serverName;
        }
        for (String server : serverNames) {
            String lowerCaseServer = server.toLowerCase();
            if (!lowerCaseServer.contains(comparisonHost)) continue;
            return server;
        }
        return serverNames[0];
    }

    private static boolean serverNameContainsPort(boolean containsScheme, String serverName) {
        int portIndex;
        if (!containsScheme && serverName.contains(":")) {
            return true;
        }
        int schemeIndex = serverName.indexOf(":");
        return schemeIndex != (portIndex = serverName.lastIndexOf(":"));
    }

    private static boolean requestIsOnStandardPort(HttpServletRequest request) {
        int serverPort = request.getServerPort();
        return serverPort == 80 || serverPort == 443;
    }

    public static String constructServiceUrl(HttpServletRequest request, HttpServletResponse response, String service, String serverNames, String artifactParameterName, boolean encode) {
        if (CommonUtils.isNotBlank(service)) {
            return encode ? response.encodeURL(service) : service;
        }
        StringBuilder buffer = new StringBuilder();
        String serverName = CommonUtils.findMatchingServerName(request, serverNames);
        boolean containsScheme = true;
        if (!serverName.startsWith("https://") && !serverName.startsWith("http://")) {
            buffer.append(request.isSecure() ? "https://" : "http://");
            containsScheme = false;
        }
        buffer.append(serverName);
        if (!CommonUtils.serverNameContainsPort(containsScheme, serverName) && !CommonUtils.requestIsOnStandardPort(request)) {
            buffer.append(":");
            buffer.append(request.getServerPort());
        }
        buffer.append(request.getRequestURI());
        if (CommonUtils.isNotBlank(request.getQueryString())) {
            int location = request.getQueryString().indexOf(artifactParameterName + "=");
            if (location == 0) {
                String returnValue = encode ? response.encodeURL(buffer.toString()) : buffer.toString();
                LOGGER.debug("serviceUrl generated: {}", (Object)returnValue);
                return returnValue;
            }
            buffer.append("?");
            if (location == -1) {
                buffer.append(request.getQueryString());
            } else if (location > 0) {
                int actualLocation = request.getQueryString().indexOf("&" + artifactParameterName + "=");
                if (actualLocation == -1) {
                    buffer.append(request.getQueryString());
                } else if (actualLocation > 0) {
                    buffer.append(request.getQueryString().substring(0, actualLocation));
                }
            }
        }
        String returnValue = encode ? response.encodeURL(buffer.toString()) : buffer.toString();
        LOGGER.debug("serviceUrl generated: {}", (Object)returnValue);
        return returnValue;
    }

    public static String safeGetParameter(HttpServletRequest request, String parameter, List<String> parameters) {
        if ("POST".equals(request.getMethod()) && parameters.contains(parameter)) {
            LOGGER.debug("safeGetParameter called on a POST HttpServletRequest for Restricted Parameters.  Cannot complete check safely.  Reverting to standard behavior for this Parameter");
            return request.getParameter(parameter);
        }
        return request.getQueryString() == null || !request.getQueryString().contains(parameter) ? null : request.getParameter(parameter);
    }

    public static String safeGetParameter(HttpServletRequest request, String parameter) {
        return CommonUtils.safeGetParameter(request, parameter, Arrays.asList("logoutRequest"));
    }

    @Deprecated
    public static String getResponseFromServer(String constructedUrl, String encoding) {
        try {
            return CommonUtils.getResponseFromServer(new URL(constructedUrl), DEFAULT_URL_CONNECTION_FACTORY, encoding);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static String getResponseFromServer(URL constructedUrl, String encoding) {
        return CommonUtils.getResponseFromServer(constructedUrl, DEFAULT_URL_CONNECTION_FACTORY, encoding);
    }

    public static String getResponseFromServer(URL constructedUrl, HttpURLConnectionFactory factory, String encoding) {
        String string;
        HttpURLConnection conn = null;
        InputStreamReader in = null;
        try {
            int byteRead;
            conn = factory.buildHttpURLConnection(constructedUrl.openConnection());
            in = CommonUtils.isEmpty(encoding) ? new InputStreamReader(conn.getInputStream()) : new InputStreamReader(conn.getInputStream(), encoding);
            StringBuilder builder = new StringBuilder(255);
            while ((byteRead = in.read()) != -1) {
                builder.append((char)byteRead);
            }
            string = builder.toString();
        }
        catch (Exception e) {
            try {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonUtils.closeQuietly(in);
                if (conn != null) {
                    conn.disconnect();
                }
                throw throwable;
            }
        }
        CommonUtils.closeQuietly(in);
        if (conn != null) {
            conn.disconnect();
        }
        return string;
    }

    public static ProxyList createProxyList(String proxies) {
        if (CommonUtils.isBlank(proxies)) {
            return new ProxyList();
        }
        ProxyListEditor editor = new ProxyListEditor();
        editor.setAsText(proxies);
        return (ProxyList)editor.getValue();
    }

    public static void sendRedirect(HttpServletResponse response, String url) {
        try {
            response.sendRedirect(url);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    public static void closeQuietly(Closeable resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

