// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom;

/**
<P>The <A HREF='Document.html'><CODE>Document</CODE></A> interface represents the entire
      HTML or XML document. Conceptually, it is the root of the
      document tree, and provides the  primary access to the
      document's data.
<P>Since elements, text nodes, comments, processing instructions,
      etc. cannot exist outside the context of a
      <A HREF='Document.html'><CODE>Document</CODE></A>, the <A HREF='Document.html'><CODE>Document</CODE></A> interface also
      contains the factory methods needed to create these objects. 
      The <A HREF='Node.html'><CODE>Node</CODE></A> objects created have a <code>ownerDocument</code>
      attribute which associates them with the <A HREF='Document.html'><CODE>Document</CODE></A> within whose 
      context they were created.

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-doctype><CODE>&nbsp;doctype</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getDoctype()'>getDoctype</a>
</TD>
<TD><P>The Document Type Declaration (see <A HREF='DocumentType.html'><CODE>DocumentType</CODE></A>)
	associated with 
	this document. For HTML documents as well as XML documents without a
	document type declaration this returns <code>null</code>. The DOM Level
        1 does not support editing the Document Type Declaration, therefore
	<code>docType</code> cannot be altered in any way.
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-implementation><CODE>&nbsp;implementation</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getImplementation()'>getImplementation</a>
</TD>
<TD><P>The <A HREF='DOMImplementation.html'><CODE>DOMImplementation</CODE></A> object that handles this
	document. A DOM application may use objects from multiple 
        implementations.
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-documentElement><CODE>&nbsp;documentElement</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getDocumentElement()'>getDocumentElement</a>
</TD>
<TD><P>This is a convenience attribute that allows direct
	access to the child node that is the root element of  the
	document. For HTML documents, this is the element with
	the tagName "HTML".
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface Document
extends Node
{
	/**
	 * Returns the value of the <code><a href=#att-doctype>doctype</a></code> property.
	*/
	DocumentType getDoctype ();


	/**
	 * Returns the value of the <code><a href=#att-implementation>implementation</a></code> property.
	*/
	DOMImplementation getImplementation ();


	/**
	 * Returns the value of the <code><a href=#att-documentElement>documentElement</a></code> property.
	*/
	Element getDocumentElement ();


/**
<P>Creates an element of the type specified. Note that the
	instance returned implements the <xtermref href="ID-745549614">Element</xtermref> interface, so
	attributes can be specified directly  on the returned
	object.

@return A new <A HREF='Element.html'><CODE>Element</CODE></A> object.
@param tagName
The name of the element type to
	    instantiate. For XML, this is case-sensitive. For HTML, the 
            <code>tagName</code> parameter may be provided in any case, 
            but it must be mapped to the canonical uppercase form by 
            the DOM implementation.
        
@exception INVALID_CHARACTER_ERR: Raised if the specified name contains
	an invalid character.
*/
Element createElement (String tagName) throws DOMException;

/**
<P>Creates an empty <A HREF='DocumentFragment.html'><CODE>DocumentFragment</CODE></A> object.
      

@return A new <A HREF='DocumentFragment.html'><CODE>DocumentFragment</CODE></A>.
*/
DocumentFragment createDocumentFragment ();

/**
<P>Creates a <A HREF='Text.html'><CODE>Text</CODE></A> node given the specified
	string.

@return The new <A HREF='Text.html'><CODE>Text</CODE></A> object.
@param data
The data for the node.
*/
Text createTextNode (String data);

/**
<P>Creates a <A HREF='Comment.html'><CODE>Comment</CODE></A> node given the specified
	string.

@return The new <A HREF='Comment.html'><CODE>Comment</CODE></A> object.
@param data
The data for the node.
*/
Comment createComment (String data);

/**
<P>Creates a <A HREF='CDATASection.html'><CODE>CDATASection</CODE></A> node whose value  is
	the specified string.

@return The new <A HREF='CDATASection.html'><CODE>CDATASection</CODE></A> object.
@param data
The data for the <A HREF='CDATASection.html'><CODE>CDATASection</CODE></A> contents.
@exception NOT_SUPPORTED_ERR: Raised if this document is an HTML
	document.
*/
CDATASection createCDATASection (String data) throws DOMException;

/**
<P>Creates a <A HREF='ProcessingInstruction.html'><CODE>ProcessingInstruction</CODE></A> node given
	the specified name and data strings.

@return The new <A HREF='ProcessingInstruction.html'><CODE>ProcessingInstruction</CODE></A> object.
@param target
The target part of the processing instruction.
@param data
The data for the node.
@exception INVALID_CHARACTER_ERR: Raised if an invalid character is specified.<P>NOT_SUPPORTED_ERR: Raised if this document is an HTML document.

*/
ProcessingInstruction createProcessingInstruction (String target, String data) throws DOMException;

/**
<P>Creates an <A HREF='Attr.html'><CODE>Attr</CODE></A> of the given name.
	Note that the <A HREF='Attr.html'><CODE>Attr</CODE></A> instance
	can then be set on an <A HREF='Element.html'><CODE>Element</CODE></A> using the
	<code>setAttribute</code> method. 

@return A new <A HREF='Attr.html'><CODE>Attr</CODE></A> object.
@param name
The name of the attribute.
@exception INVALID_CHARACTER_ERR: Raised if the specified name contains
	an invalid character.
*/
Attr createAttribute (String name) throws DOMException;

/**
<P>Creates an EntityReference object.

@return The new <A HREF='EntityReference.html'><CODE>EntityReference</CODE></A> object.
@param name
The name of the entity to reference. 
@exception INVALID_CHARACTER_ERR: Raised if the specified name contains
	an invalid character.<P>NOT_SUPPORTED_ERR: Raised if this document is an HTML document. 

*/
EntityReference createEntityReference (String name) throws DOMException;

/**
<P>Returns a <A HREF='NodeList.html'><CODE>NodeList</CODE></A> of all the <A HREF='Element.html'><CODE>Element</CODE></A>s
	with a given tag name in the order in which they would be encountered
        in a preorder traversal of the <A HREF='Document.html'><CODE>Document</CODE></A> tree.
      

@return A new <A HREF='NodeList.html'><CODE>NodeList</CODE></A> object containing
	  all the matched <A HREF='Element.html'><CODE>Element</CODE></A>s.
@param tagname
The name of the tag to match on. The special value "*"
	    matches all tags.
*/
NodeList getElementsByTagName (String tagname);

}
