/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.addressmatching;

import com.supermap.analyst.addressmatching.AddressDictionaryNative;
import com.supermap.analyst.addressmatching.InternalHandleDisposable;
import com.supermap.analyst.addressmatching.InternalResource;
import com.supermap.analyst.addressmatching.InternalToolkitAddressMatching;
import java.io.File;

public class AddressDictionary
extends InternalHandleDisposable {
    private String _$1 = "";

    public AddressDictionary() {
        long l = AddressDictionaryNative.jni_New();
        this.setHandle(l, true);
    }

    public AddressDictionary(String string) {
        this();
        this.load(string);
    }

    public void dispose() {
        if (this.getHandle() != 0L) {
            AddressDictionaryNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        return AddressDictionaryNative.jni_GetCount(this.getHandle());
    }

    public String get(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int index)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("get(int index)", "Global_IndexOutOfBounds", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        return AddressDictionaryNative.jni_GetItem(this.getHandle(), n);
    }

    public boolean contains(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("contains(String word)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string2);
        }
        boolean bl = false;
        if (string != null && string.trim().length() > 0) {
            bl = AddressDictionaryNative.jni_Contains(this.getHandle(), string);
        }
        return bl;
    }

    public int indexOf(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("indexOf(String word)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string2);
        }
        int n = -1;
        if (string != null && string.trim().length() > 0) {
            n = AddressDictionaryNative.jni_IndexOf(this.getHandle(), string);
        }
        return n;
    }

    public int add(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("add(String word)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string2);
        }
        if (this.contains(string)) {
            String string3 = InternalResource.loadString("add(String word)", "AddressDictionary_WordAlreadyExist", "addressmatching_resources");
            throw new IllegalArgumentException(string3);
        }
        int n = -1;
        if (string != null && string.trim().length() > 0) {
            n = AddressDictionaryNative.jni_Add(this.getHandle(), string);
        }
        return n;
    }

    public boolean delete(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("delete(String word)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string2);
        }
        boolean bl = false;
        if (string != null && string.trim().length() > 0) {
            bl = AddressDictionaryNative.jni_DeleteWorld(this.getHandle(), string);
        }
        return bl;
    }

    public boolean delete(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("delete(int index)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (n < 0 || n > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.get(n);
        bl = this.delete(string);
        return bl;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        long l = AddressDictionaryNative.jni_New();
        if (l != 0L) {
            long l2 = this.getHandle();
            AddressDictionaryNative.jni_Delete(l2);
            this.setHandle(0L);
            this.setHandle(l, true);
        }
    }

    public boolean load(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("load(String dictionaryFile)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string2);
        }
        File file = new File(string);
        if (!file.exists()) {
            String string3 = InternalResource.loadString("textFile", "Global_FileNotFound", "addressmatching_resources");
            throw new IllegalArgumentException(string3);
        }
        boolean bl = false;
        if (string != null && string.trim().length() > 0) {
            bl = AddressDictionaryNative.jni_Load(this.getHandle(), string);
        }
        if (bl) {
            this._$1 = string;
        }
        return bl;
    }

    public boolean save() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("save()", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (this._$1.trim().length() > 0) {
            bl = AddressDictionaryNative.jni_SaveAs(this.getHandle(), this._$1);
        }
        return bl;
    }

    public boolean saveAs(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("saveAs(String dictionaryFile)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string2);
        }
        if (!InternalToolkitAddressMatching.isDirectoryExisted(string)) {
            String string3 = InternalResource.loadString("dictionaryFile", "GlobalDirectoryNotFound", "addressmatching_resources");
            throw new IllegalArgumentException(string3);
        }
        boolean bl = false;
        if (string != null && string.trim().length() > 0) {
            bl = AddressDictionaryNative.jni_SaveAs(this.getHandle(), string);
        }
        if (bl) {
            this._$1 = string;
        }
        return bl;
    }

    public static boolean textToDictionary(String string, String string2) {
        File file = new File(string);
        if (!file.exists()) {
            String string3 = InternalResource.loadString("textFile", "Global_FileNotFound", "addressmatching_resources");
            throw new IllegalArgumentException(string3);
        }
        if (!InternalToolkitAddressMatching.isDirectoryExisted(string2)) {
            String string4 = InternalResource.loadString("dictionaryFile", "GlobalDirectoryNotFound", "addressmatching_resources");
            throw new IllegalArgumentException(string4);
        }
        boolean bl = false;
        bl = AddressDictionaryNative.jni_TextToDictionary(string, string2);
        return bl;
    }

    public static boolean dictionaryToText(String string, String string2) {
        File file = new File(string);
        if (!file.exists()) {
            String string3 = InternalResource.loadString("dictionaryFile", "Global_FileNotFound", "addressmatching_resources");
            throw new IllegalArgumentException(string3);
        }
        if (!InternalToolkitAddressMatching.isDirectoryExisted(string2)) {
            String string4 = InternalResource.loadString("textFile", "GlobalDirectoryNotFound", "addressmatching_resources");
            throw new IllegalArgumentException(string4);
        }
        boolean bl = false;
        bl = AddressDictionaryNative.jni_DictionaryToText(string, string2);
        return bl;
    }

    public static boolean mergeDictionary(String string, String string2, String string3) {
        File file = new File(string);
        if (!file.exists()) {
            String string4 = InternalResource.loadString("dictionaryFile1", "Global_FileNotFound", "addressmatching_resources");
            throw new IllegalArgumentException(string4);
        }
        File file2 = new File(string2);
        if (!file2.exists()) {
            String string5 = InternalResource.loadString("dictionaryFile2", "Global_FileNotFound", "addressmatching_resources");
            throw new IllegalArgumentException(string5);
        }
        if (!InternalToolkitAddressMatching.isDirectoryExisted(string3)) {
            String string6 = InternalResource.loadString("dictionaryFileResult", "GlobalDirectoryNotFound", "addressmatching_resources");
            throw new IllegalArgumentException(string6);
        }
        boolean bl = false;
        bl = AddressDictionaryNative.jni_MergeDictionary(string, string2, string3);
        return bl;
    }
}

