/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleReturnResultSet;

class AutoKeyInfo
extends OracleResultSetMetaData {
    String originalSql;
    String newSql;
    String tableName;
    String[] columnNames;
    int[] columnIndexes;
    int numColumns;
    String[] tableColumnNames;
    int[] tableColumnTypes;
    int[] tableMaxLengths;
    boolean[] tableNullables;
    short[] tableFormOfUses;
    int[] tablePrecisions;
    int[] tableScales;
    String[] tableTypeNames;
    int autoKeyType;
    static final int KEYFLAG = 0;
    static final int COLUMNAME = 1;
    static final int COLUMNINDEX = 2;
    int[] returnTypes;
    Accessor[] returnAccessors;

    AutoKeyInfo(String string) {
        this.originalSql = string;
        this.autoKeyType = 0;
    }

    AutoKeyInfo(String string, String[] stringArray) {
        this.originalSql = string;
        this.columnNames = stringArray;
        this.autoKeyType = 1;
    }

    AutoKeyInfo(String string, int[] nArray) {
        this.originalSql = string;
        this.columnIndexes = nArray;
        this.autoKeyType = 2;
    }

    String getNewSql() throws SQLException {
        if (this.newSql != null) {
            return this.newSql;
        }
        switch (this.autoKeyType) {
            case 0: {
                this.newSql = this.originalSql + " RETURNING ROWID INTO ?";
                this.returnTypes = new int[1];
                this.returnTypes[0] = 104;
                return this.newSql;
            }
            case 1: {
                return this.getNewSqlByColumnName();
            }
            case 2: {
                return this.getNewSqlByColumnIndexes();
            }
        }
        DatabaseError.throwSqlException(89);
        return null;
    }

    private String getNewSqlByColumnName() throws SQLException {
        int n;
        this.returnTypes = new int[this.columnNames.length];
        this.columnIndexes = new int[this.columnNames.length];
        StringBuffer stringBuffer = new StringBuffer(this.originalSql);
        stringBuffer.append(" RETURNING ");
        for (n = 0; n < this.columnNames.length; ++n) {
            int n2;
            this.returnTypes[n] = n2 = this.getReturnParamTypeCode(n, this.columnNames[n], this.columnIndexes);
            stringBuffer.append(this.columnNames[n]);
            if (n >= this.columnNames.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" INTO ");
        for (n = 0; n < this.columnNames.length - 1; ++n) {
            stringBuffer.append("?, ");
        }
        stringBuffer.append("?");
        this.newSql = new String(stringBuffer);
        return this.newSql;
    }

    private String getNewSqlByColumnIndexes() throws SQLException {
        int n;
        this.returnTypes = new int[this.columnIndexes.length];
        StringBuffer stringBuffer = new StringBuffer(this.originalSql);
        stringBuffer.append(" RETURNING ");
        for (n = 0; n < this.columnIndexes.length; ++n) {
            int n2 = this.columnIndexes[n] - 1;
            if (n2 < 0 || n2 > this.tableColumnNames.length) {
                DatabaseError.throwSqlException(68);
            }
            int n3 = this.tableColumnTypes[n2];
            String string = this.tableColumnNames[n2];
            this.returnTypes[n] = n3;
            stringBuffer.append(string);
            if (n >= this.columnIndexes.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" INTO ");
        for (n = 0; n < this.columnIndexes.length - 1; ++n) {
            stringBuffer.append("?, ");
        }
        stringBuffer.append("?");
        this.newSql = new String(stringBuffer);
        return this.newSql;
    }

    private final int getReturnParamTypeCode(int n, String string, int[] nArray) throws SQLException {
        for (int i = 0; i < this.tableColumnNames.length; ++i) {
            if (!string.equalsIgnoreCase(this.tableColumnNames[i])) continue;
            nArray[n] = i + 1;
            return this.tableColumnTypes[i];
        }
        DatabaseError.throwSqlException(68);
        return -1;
    }

    static final boolean isInsertSqlStmt(String string) throws SQLException {
        if (string == null) {
            DatabaseError.throwSqlException(68);
        }
        return string.trim().toUpperCase().startsWith("INSERT");
    }

    String getTableName() throws SQLException {
        int n;
        int n2;
        if (this.tableName != null) {
            return this.tableName;
        }
        String string = this.originalSql.trim().toUpperCase();
        int n3 = string.indexOf("INSERT");
        if ((n3 = string.indexOf("INTO", n3)) < 0) {
            DatabaseError.throwSqlException(68);
        }
        int n4 = string.length();
        for (n2 = n3 + 5; n2 < n4 && string.charAt(n2) == ' '; ++n2) {
        }
        if (n2 >= n4) {
            DatabaseError.throwSqlException(68);
        }
        for (n = n2 + 1; n < n4 && string.charAt(n) != ' ' && string.charAt(n) != '('; ++n) {
        }
        if (n2 == n - 1) {
            DatabaseError.throwSqlException(68);
        }
        this.tableName = string.substring(n2, n);
        return this.tableName;
    }

    void allocateSpaceForDescribedData(int n) throws SQLException {
        this.numColumns = n;
        this.tableColumnNames = new String[n];
        this.tableColumnTypes = new int[n];
        this.tableMaxLengths = new int[n];
        this.tableNullables = new boolean[n];
        this.tableFormOfUses = new short[n];
        this.tablePrecisions = new int[n];
        this.tableScales = new int[n];
        this.tableTypeNames = new String[n];
    }

    void fillDescribedData(int n, String string, int n2, int n3, boolean bl, short s, int n4, int n5, String string2) throws SQLException {
        this.tableColumnNames[n] = string;
        this.tableColumnTypes[n] = n2;
        this.tableMaxLengths[n] = n3;
        this.tableNullables[n] = bl;
        this.tableFormOfUses[n] = s;
        this.tablePrecisions[n] = n4;
        this.tableScales[n] = n5;
        this.tableTypeNames[n] = string2;
    }

    void initMetaData(OracleReturnResultSet oracleReturnResultSet) throws SQLException {
        if (this.returnAccessors != null) {
            return;
        }
        this.returnAccessors = oracleReturnResultSet.returnAccessors;
        switch (this.autoKeyType) {
            case 0: {
                this.initMetaDataKeyFlag();
                break;
            }
            case 1: 
            case 2: {
                this.initMetaDataColumnIndexes();
            }
        }
    }

    void initMetaDataKeyFlag() throws SQLException {
        this.returnAccessors[0].columnName = "ROWID";
        this.returnAccessors[0].describeType = 104;
        this.returnAccessors[0].describeMaxLength = 4;
        this.returnAccessors[0].nullable = true;
        this.returnAccessors[0].precision = 0;
        this.returnAccessors[0].scale = 0;
        this.returnAccessors[0].formOfUse = 0;
    }

    void initMetaDataColumnIndexes() throws SQLException {
        for (int i = 0; i < this.returnAccessors.length; ++i) {
            Accessor accessor = this.returnAccessors[i];
            int n = this.columnIndexes[i] - 1;
            accessor.columnName = this.tableColumnNames[n];
            accessor.describeType = this.tableColumnTypes[n];
            accessor.describeMaxLength = this.tableMaxLengths[n];
            accessor.nullable = this.tableNullables[n];
            accessor.precision = this.tablePrecisions[n];
            accessor.scale = this.tablePrecisions[n];
            accessor.formOfUse = this.tableFormOfUses[n];
        }
    }

    int getValidColumnIndex(int n) throws SQLException {
        if (n <= 0 || n > this.returnAccessors.length) {
            DatabaseError.throwSqlException(3);
        }
        return n - 1;
    }

    public int getColumnCount() throws SQLException {
        return this.returnAccessors.length;
    }

    public String getColumnName(int n) throws SQLException {
        if (n <= 0 || n > this.returnAccessors.length) {
            DatabaseError.throwSqlException(3);
        }
        return this.returnAccessors[n - 1].columnName;
    }

    public String getTableName(int n) throws SQLException {
        if (n <= 0 || n > this.returnAccessors.length) {
            DatabaseError.throwSqlException(3);
        }
        return this.getTableName();
    }

    Accessor[] getDescription() throws SQLException {
        return this.returnAccessors;
    }
}

