/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.cors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.http.HttpMethod;

public class CorsConfiguration {
    private List<String> allowedOrigins;
    private List<String> allowedMethods;
    private List<String> allowedHeaders;
    private List<String> exposedHeaders;
    private Boolean allowCredentials;
    private Long maxAge;

    public CorsConfiguration() {
    }

    public CorsConfiguration(CorsConfiguration other) {
        this.allowedOrigins = other.allowedOrigins;
        this.allowedMethods = other.allowedMethods;
        this.allowedHeaders = other.allowedHeaders;
        this.exposedHeaders = other.exposedHeaders;
        this.allowCredentials = other.allowCredentials;
        this.maxAge = other.maxAge;
    }

    public CorsConfiguration combine(CorsConfiguration other) {
        Long maxAge;
        if (other == null) {
            return this;
        }
        CorsConfiguration config = new CorsConfiguration(this);
        config.setAllowedOrigins(this.combine(this.getAllowedOrigins(), other.getAllowedOrigins()));
        config.setAllowedMethods(this.combine(this.getAllowedMethods(), other.getAllowedMethods()));
        config.setAllowedHeaders(this.combine(this.getAllowedHeaders(), other.getAllowedHeaders()));
        config.setExposedHeaders(this.combine(this.getExposedHeaders(), other.getExposedHeaders()));
        Boolean allowCredentials = other.getAllowCredentials();
        if (allowCredentials != null) {
            config.setAllowCredentials(allowCredentials);
        }
        if ((maxAge = other.getMaxAge()) != null) {
            config.setMaxAge(maxAge);
        }
        return config;
    }

    private List<String> combine(List<String> source, List<String> other) {
        if (other == null) {
            return source;
        }
        if (source == null || source.contains("*")) {
            return other;
        }
        ArrayList<String> combined = new ArrayList<String>(source);
        combined.addAll(other);
        return combined;
    }

    public void setAllowedOrigins(List<String> origins) {
        this.allowedOrigins = origins;
    }

    public void addAllowedOrigin(String origin) {
        if (this.allowedOrigins == null) {
            this.allowedOrigins = new ArrayList<String>();
        }
        this.allowedOrigins.add(origin);
    }

    public List<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public void setAllowedMethods(List<String> methods) {
        this.allowedMethods = methods;
    }

    public void addAllowedMethod(String method) {
        if (this.allowedMethods == null) {
            this.allowedMethods = new ArrayList<String>();
        }
        this.allowedMethods.add(method);
    }

    public List<String> getAllowedMethods() {
        return this.allowedMethods;
    }

    public void setAllowedHeaders(List<String> allowedHeaders) {
        this.allowedHeaders = allowedHeaders;
    }

    public void addAllowedHeader(String allowedHeader) {
        if (this.allowedHeaders == null) {
            this.allowedHeaders = new ArrayList<String>();
        }
        this.allowedHeaders.add(allowedHeader);
    }

    public List<String> getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public void setExposedHeaders(List<String> exposedHeaders) {
        if (exposedHeaders != null && exposedHeaders.contains("*")) {
            throw new IllegalArgumentException("'*' is not a valid exposed header value");
        }
        this.exposedHeaders = exposedHeaders;
    }

    public void addExposedHeader(String exposedHeader) {
        if ("*".equals(exposedHeader)) {
            throw new IllegalArgumentException("'*' is not a valid exposed header value");
        }
        if (this.exposedHeaders == null) {
            this.exposedHeaders = new ArrayList<String>();
        }
        this.exposedHeaders.add(exposedHeader);
    }

    public List<String> getExposedHeaders() {
        return this.exposedHeaders;
    }

    public void setAllowCredentials(Boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
    }

    public Boolean getAllowCredentials() {
        return this.allowCredentials;
    }

    public void setMaxAge(Long maxAge) {
        this.maxAge = maxAge;
    }

    public Long getMaxAge() {
        return this.maxAge;
    }

    public String checkOrigin(String requestOrigin) {
        List<Object> allowedOrigins;
        if (requestOrigin == null) {
            return null;
        }
        List<Object> list = allowedOrigins = this.allowedOrigins == null ? new ArrayList() : this.allowedOrigins;
        if (allowedOrigins.contains("*")) {
            if (this.allowCredentials == null || !this.allowCredentials.booleanValue()) {
                return "*";
            }
            return requestOrigin;
        }
        for (String string : allowedOrigins) {
            if (!requestOrigin.equalsIgnoreCase(string)) continue;
            return requestOrigin;
        }
        return null;
    }

    public List<HttpMethod> checkHttpMethod(HttpMethod requestMethod) {
        List<Object> allowedMethods;
        if (requestMethod == null) {
            return null;
        }
        List<Object> list = allowedMethods = this.allowedMethods == null ? new ArrayList() : this.allowedMethods;
        if (allowedMethods.contains("*")) {
            return Arrays.asList(requestMethod);
        }
        if (allowedMethods.isEmpty()) {
            allowedMethods.add(HttpMethod.GET.name());
        }
        ArrayList<HttpMethod> result = new ArrayList<HttpMethod>(allowedMethods.size());
        boolean allowed = false;
        for (String string : allowedMethods) {
            if (string.equals(requestMethod.name())) {
                allowed = true;
            }
            result.add(HttpMethod.valueOf(string));
        }
        return allowed ? result : null;
    }

    public List<String> checkHeaders(List<String> requestHeaders) {
        if (requestHeaders == null) {
            return null;
        }
        if (requestHeaders.isEmpty()) {
            return Collections.emptyList();
        }
        List<Object> allowedHeaders = this.allowedHeaders == null ? new ArrayList() : this.allowedHeaders;
        boolean allowAnyHeader = allowedHeaders.contains("*");
        ArrayList<String> result = new ArrayList<String>();
        block0: for (String requestHeader : requestHeaders) {
            requestHeader = requestHeader.trim();
            for (String string : allowedHeaders) {
                if (!allowAnyHeader && !requestHeader.equalsIgnoreCase(string)) continue;
                result.add(requestHeader);
                continue block0;
            }
        }
        return result.isEmpty() ? null : result;
    }
}

