/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.annotation;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.jms.annotation.JmsListenerConfigurer;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerEndpointRegistrar;
import org.springframework.jms.config.JmsListenerEndpointRegistry;
import org.springframework.jms.config.MethodJmsListenerEndpoint;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class JmsListenerAnnotationBeanPostProcessor
implements BeanPostProcessor,
Ordered,
BeanFactoryAware,
SmartInitializingSingleton {
    static final String DEFAULT_JMS_LISTENER_CONTAINER_FACTORY_BEAN_NAME = "jmsListenerContainerFactory";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private JmsListenerEndpointRegistry endpointRegistry;
    private String containerFactoryBeanName = "jmsListenerContainerFactory";
    private BeanFactory beanFactory;
    private final MessageHandlerMethodFactoryAdapter messageHandlerMethodFactory = new MessageHandlerMethodFactoryAdapter();
    private final JmsListenerEndpointRegistrar registrar = new JmsListenerEndpointRegistrar();
    private final AtomicInteger counter = new AtomicInteger();
    private final Set<Class<?>> nonAnnotatedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void setEndpointRegistry(JmsListenerEndpointRegistry endpointRegistry) {
        this.endpointRegistry = endpointRegistry;
    }

    public void setContainerFactoryBeanName(String containerFactoryBeanName) {
        this.containerFactoryBeanName = containerFactoryBeanName;
    }

    public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory messageHandlerMethodFactory) {
        this.messageHandlerMethodFactory.setMessageHandlerMethodFactory(messageHandlerMethodFactory);
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void afterSingletonsInstantiated() {
        MessageHandlerMethodFactory handlerMethodFactory;
        this.registrar.setBeanFactory(this.beanFactory);
        if (this.beanFactory instanceof ListableBeanFactory) {
            Map instances = ((ListableBeanFactory)this.beanFactory).getBeansOfType(JmsListenerConfigurer.class);
            for (JmsListenerConfigurer configurer : instances.values()) {
                configurer.configureJmsListeners(this.registrar);
            }
        }
        if (this.registrar.getEndpointRegistry() == null) {
            if (this.endpointRegistry == null) {
                Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to find endpoint registry by bean name");
                this.endpointRegistry = (JmsListenerEndpointRegistry)this.beanFactory.getBean("org.springframework.jms.config.internalJmsListenerEndpointRegistry", JmsListenerEndpointRegistry.class);
            }
            this.registrar.setEndpointRegistry(this.endpointRegistry);
        }
        if (this.containerFactoryBeanName != null) {
            this.registrar.setContainerFactoryBeanName(this.containerFactoryBeanName);
        }
        if ((handlerMethodFactory = this.registrar.getMessageHandlerMethodFactory()) != null) {
            this.messageHandlerMethodFactory.setMessageHandlerMethodFactory(handlerMethodFactory);
        }
        this.registrar.afterPropertiesSet();
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(final Object bean, String beanName) throws BeansException {
        if (!this.nonAnnotatedClasses.contains(bean.getClass())) {
            final LinkedHashSet annotatedMethods = new LinkedHashSet(1);
            Class targetClass = AopUtils.getTargetClass((Object)bean);
            ReflectionUtils.doWithMethods((Class)targetClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                    JmsListener jmsListener = (JmsListener)AnnotationUtils.getAnnotation((Method)method, JmsListener.class);
                    if (jmsListener != null) {
                        JmsListenerAnnotationBeanPostProcessor.this.processJmsListener(jmsListener, method, bean);
                        annotatedMethods.add(method);
                    }
                }
            });
            if (annotatedMethods.isEmpty()) {
                this.nonAnnotatedClasses.add(bean.getClass());
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("No @JmsListener annotations found on bean class: " + bean.getClass()));
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(annotatedMethods.size() + " @JmsListener methods processed on bean '" + beanName + "': " + annotatedMethods));
            }
        }
        return bean;
    }

    protected void processJmsListener(JmsListener jmsListener, Method method, Object bean) {
        if (AopUtils.isJdkDynamicProxy((Object)bean)) {
            try {
                method = bean.getClass().getMethod(method.getName(), method.getParameterTypes());
            }
            catch (SecurityException ex) {
                ReflectionUtils.handleReflectionException((Exception)ex);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException(String.format("@JmsListener method '%s' found on bean target class '%s', but not found in any interface(s) for bean JDK proxy. Either pull the method up to an interface or switch to subclass (CGLIB) proxies by setting proxy-target-class/proxyTargetClass attribute to 'true'", method.getName(), method.getDeclaringClass().getSimpleName()));
            }
        }
        MethodJmsListenerEndpoint endpoint = new MethodJmsListenerEndpoint();
        endpoint.setBean(bean);
        endpoint.setMethod(method);
        endpoint.setMessageHandlerMethodFactory(this.messageHandlerMethodFactory);
        endpoint.setBeanFactory(this.beanFactory);
        endpoint.setId(this.getEndpointId(jmsListener));
        endpoint.setDestination(this.resolve(jmsListener.destination()));
        if (StringUtils.hasText((String)jmsListener.selector())) {
            endpoint.setSelector(this.resolve(jmsListener.selector()));
        }
        if (StringUtils.hasText((String)jmsListener.subscription())) {
            endpoint.setSubscription(this.resolve(jmsListener.subscription()));
        }
        if (StringUtils.hasText((String)jmsListener.concurrency())) {
            endpoint.setConcurrency(this.resolve(jmsListener.concurrency()));
        }
        JmsListenerContainerFactory factory = null;
        String containerFactoryBeanName = this.resolve(jmsListener.containerFactory());
        if (StringUtils.hasText((String)containerFactoryBeanName)) {
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to obtain container factory by bean name");
            try {
                factory = (JmsListenerContainerFactory)this.beanFactory.getBean(containerFactoryBeanName, JmsListenerContainerFactory.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw new BeanInitializationException("Could not register jms listener endpoint on [" + method + "], no " + JmsListenerContainerFactory.class.getSimpleName() + " with id '" + containerFactoryBeanName + "' was found in the application context", (Throwable)ex);
            }
        }
        this.registrar.registerEndpoint(endpoint, factory);
    }

    private String getEndpointId(JmsListener jmsListener) {
        if (StringUtils.hasText((String)jmsListener.id())) {
            return this.resolve(jmsListener.id());
        }
        return "org.springframework.jms.JmsListenerEndpointContainer#" + this.counter.getAndIncrement();
    }

    private String resolve(String value) {
        if (this.beanFactory instanceof ConfigurableBeanFactory) {
            return ((ConfigurableBeanFactory)this.beanFactory).resolveEmbeddedValue(value);
        }
        return value;
    }

    private class MessageHandlerMethodFactoryAdapter
    implements MessageHandlerMethodFactory {
        private MessageHandlerMethodFactory messageHandlerMethodFactory;

        private MessageHandlerMethodFactoryAdapter() {
        }

        public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory messageHandlerMethodFactory) {
            this.messageHandlerMethodFactory = messageHandlerMethodFactory;
        }

        public InvocableHandlerMethod createInvocableHandlerMethod(Object bean, Method method) {
            return this.getMessageHandlerMethodFactory().createInvocableHandlerMethod(bean, method);
        }

        private MessageHandlerMethodFactory getMessageHandlerMethodFactory() {
            if (this.messageHandlerMethodFactory == null) {
                this.messageHandlerMethodFactory = this.createDefaultJmsHandlerMethodFactory();
            }
            return this.messageHandlerMethodFactory;
        }

        private MessageHandlerMethodFactory createDefaultJmsHandlerMethodFactory() {
            DefaultMessageHandlerMethodFactory defaultFactory = new DefaultMessageHandlerMethodFactory();
            defaultFactory.setBeanFactory(JmsListenerAnnotationBeanPostProcessor.this.beanFactory);
            defaultFactory.afterPropertiesSet();
            return defaultFactory;
        }
    }
}

