/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.common;

import java.util.Map;
import java.util.TreeMap;
import net.sf.sojo.common.WalkerInterceptor;

public class PathRecordWalkerInterceptor
implements WalkerInterceptor {
    private Map<String, Object> paths = new TreeMap<String, Object>();
    private boolean filterUniqueIdProperty = false;
    private boolean onlySimpleProperties = false;

    public boolean getFilterUniqueIdProperty() {
        return this.filterUniqueIdProperty;
    }

    public void setFilterUniqueIdProperty(boolean pvFilterUniqueIdProperty) {
        this.filterUniqueIdProperty = pvFilterUniqueIdProperty;
    }

    public void setOnlySimpleProperties(boolean pvOnlySimpleProperties) {
        this.onlySimpleProperties = pvOnlySimpleProperties;
    }

    public boolean getOnlySimpleProperties() {
        return this.onlySimpleProperties;
    }

    public boolean addToPaths(int pvType, String pvPath) {
        boolean lvReturn = true;
        if (this.getFilterUniqueIdProperty() && pvPath.indexOf("~unique-id~") >= 0) {
            lvReturn = false;
        }
        if (this.getOnlySimpleProperties() && 1 != pvType) {
            lvReturn = false;
        }
        return lvReturn;
    }

    @Override
    public boolean visitElement(Object pvKey, int pvIndex, Object pvValue, int pvType, String pvPath, int pvNumberOfRecursion) {
        Object o;
        if (this.addToPaths(pvType, pvPath) && (o = this.paths.put(pvPath, pvValue)) != null) {
            throw new IllegalArgumentException("Path is not unique: " + pvPath + " - " + pvValue);
        }
        return false;
    }

    public Map<String, Object> getAllRecordedPaths() {
        return this.paths;
    }

    @Override
    public void endWalk() {
    }

    @Override
    public void startWalk(Object pvStartObject) {
        this.paths.clear();
    }

    @Override
    public void visitIterateableElement(Object pvValue, int pvType, String pvPath, int pvBeginEnd) {
    }
}

