/*
 * Decompiled with CFR 0.152.
 */
package com.supermap;

import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.supermap.License;
import com.supermap.LicenseFeatureInfo;
import com.supermap.LicenseVerifyFailedEvent;
import com.supermap.LicenseVerifyFailedListener;
import com.supermap.ProductType;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LicenseWrapInstance {
    private static String VERSION = "700";
    static transient Vector<LicenseVerifyFailedListener> m_licenseVerifyFailedListeners;
    static int SuperMap_License_Error_Code_Base;
    static int SuperMap_License_Error_LaterExpiredDate;
    static int SuperMap_License_Error_EarlyStartDate;
    static int SuperMap_License_Error_WrongLicenseData;
    static int SuperMap_License_Error_WrongProductVersion;
    static int SuperMap_License_Error_EncryptFailed;
    static int SuperMap_License_Error_ComputerNameError;
    static int SuperMap_License_Error_FeatrueNotFound;
    static int SuperMap_License_Error_SpecifyMACNotFound;
    static int SuperMap_License_Error_WrongFeatureInLicData;
    private static String g_currentUsedLicFile;
    private static String g_inputLicFilePath;
    private static List<String> g_MACList;
    private LicenseFeatureInfo m_featureInfo = null;
    private String m_user;
    private String m_company;

    static {
        SuperMap_License_Error_Code_Base = 5000;
        SuperMap_License_Error_LaterExpiredDate = SuperMap_License_Error_Code_Base + 1;
        SuperMap_License_Error_EarlyStartDate = SuperMap_License_Error_Code_Base + 2;
        SuperMap_License_Error_WrongLicenseData = SuperMap_License_Error_Code_Base + 3;
        SuperMap_License_Error_WrongProductVersion = SuperMap_License_Error_Code_Base + 4;
        SuperMap_License_Error_EncryptFailed = SuperMap_License_Error_Code_Base + 5;
        SuperMap_License_Error_ComputerNameError = SuperMap_License_Error_Code_Base + 6;
        SuperMap_License_Error_FeatrueNotFound = SuperMap_License_Error_Code_Base + 7;
        SuperMap_License_Error_SpecifyMACNotFound = SuperMap_License_Error_Code_Base + 8;
        SuperMap_License_Error_WrongFeatureInLicData = SuperMap_License_Error_Code_Base + 9;
    }

    public static boolean findAndReadLicFile() {
        File file;
        if (License.g_debug.booleanValue()) {
            System.out.println("g_inputLicFilePath=" + g_inputLicFilePath);
        }
        if (g_inputLicFilePath != null && !g_inputLicFilePath.equals("") && (file = new File(g_inputLicFilePath)).exists() && file.isFile()) {
            g_currentUsedLicFile = g_inputLicFilePath;
            return true;
        }
        ArrayList<String> findPathes = new ArrayList<String>();
        findPathes.add(g_inputLicFilePath);
        findPathes.add(License.getUGOBasePath());
        findPathes.add(License.PROGRAM_PATH);
        findPathes.add(License.OPT_PATH);
        String javaHomePath = System.getProperty("java.home");
        findPathes.add(javaHomePath);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toUpperCase().endsWith(".LIC7C");
            }
        };
        File dir = null;
        for (String string : findPathes) {
            File[] files;
            if (string == null || string.isEmpty() || !(dir = new File(string)).exists() || (files = dir.listFiles(filter)).length <= 0) continue;
            g_currentUsedLicFile = files[0].getAbsolutePath();
            break;
        }
        if (License.g_debug.booleanValue()) {
            System.out.println("g_currentUsedLicFile=" + g_currentUsedLicFile);
        }
        return g_currentUsedLicFile != null && !g_currentUsedLicFile.isEmpty();
    }

    public void dispose() {
    }

    public int connect(ProductType product) {
        return this.connect(product.getUGCValue());
    }

    public int connect(int featureID) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        Document doc = null;
        try {
            doc = builder.parse(new File(g_currentUsedLicFile));
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_featureInfo = new LicenseFeatureInfo();
        this.m_featureInfo.m_id = featureID;
        Element tempNode = null;
        String temp = "";
        Element root = doc.getDocumentElement();
        String strFeatureID = new Integer(featureID).toString();
        NodeList featureNodes = root.getElementsByTagName("feature");
        Element featureNode = null;
        boolean isConnected = false;
        int i = 0;
        while (i < featureNodes.getLength()) {
            featureNode = (Element)featureNodes.item(i);
            tempNode = License.getFirstElementByName(featureNode, "id");
            temp = tempNode.getFirstChild().getNodeValue();
            if (temp.equals(strFeatureID)) {
                isConnected = true;
                break;
            }
            ++i;
        }
        if (isConnected) {
            tempNode = License.getFirstElementByName(root, "signature");
            String signature = tempNode.getFirstChild().getNodeValue();
            tempNode = License.getFirstElementByName(featureNode, "licdata");
            temp = tempNode.getFirstChild().getNodeValue();
            byte[] decryptData = null;
            try {
                decryptData = Base64.decode(temp);
            }
            catch (Base64DecodingException e) {
                e.printStackTrace();
            }
            String decryptString = new String(LicenseWrapInstance.decrypt(decryptData));
            int code = LicenseWrapInstance.verifyLicense(decryptString, this.m_featureInfo, signature);
            if (code != 0) {
                this.m_featureInfo = null;
                return code;
            }
            this.m_featureInfo.m_licData = temp;
            tempNode = License.getFirstElementByName(featureNode, "name");
            this.m_featureInfo.m_name = temp = tempNode.getFirstChild().getNodeValue();
            tempNode = License.getFirstElementByName(root, "user");
            this.m_user = temp = tempNode.getFirstChild().getNodeValue();
            tempNode = License.getFirstElementByName(root, "company");
            this.m_company = temp = tempNode.getFirstChild().getNodeValue();
            return 0;
        }
        return SuperMap_License_Error_FeatrueNotFound;
    }

    public int verify() {
        return this.connect((int)this.m_featureInfo.getID());
    }

    public void disconnect() {
        this.m_featureInfo = null;
    }

    public String getUser() {
        return this.m_user;
    }

    public String getCompany() {
        return this.m_company;
    }

    public static String getSpecifyLicenseFilePath() {
        return g_inputLicFilePath;
    }

    public static void setSpecifyLicenseFilePath(String value) {
        g_inputLicFilePath = value;
        LicenseWrapInstance.findAndReadLicFile();
    }

    public static synchronized void addLicenseVerifyFailedListener(LicenseVerifyFailedListener l) {
        if (m_licenseVerifyFailedListeners == null) {
            m_licenseVerifyFailedListeners = new Vector();
        }
        if (!m_licenseVerifyFailedListeners.contains(l)) {
            m_licenseVerifyFailedListeners.add(l);
        }
    }

    public static synchronized void removeLicenseVerifyFailedListener(LicenseVerifyFailedListener l) {
        if (m_licenseVerifyFailedListeners != null && m_licenseVerifyFailedListeners.contains(l)) {
            m_licenseVerifyFailedListeners.remove(l);
        }
    }

    protected static void fireLicenseVerifyFailed(LicenseVerifyFailedEvent event) {
        if (m_licenseVerifyFailedListeners != null) {
            Vector<LicenseVerifyFailedListener> listeners = m_licenseVerifyFailedListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                listeners.elementAt(i).licenseVerifyFailed(event);
                ++i;
            }
        }
    }

    public LicenseFeatureInfo getFeatureInfo() {
        return this.m_featureInfo;
    }

    private static byte[] decrypt(byte[] encrypted) {
        BigInteger modulus = new BigInteger("97940149900808251375534752128742394515589720894419487281414832262018030644275525014643445585879780364114176383835238013142689819073723152973127922693584355350878117626063464407872142659013727087204174268107953820379456111862924759697130141776327730513730393977765958470441797160670328283419007898268490444631");
        BigInteger exponent = new BigInteger("65537");
        BigInteger encryptedInt = new BigInteger(encrypted);
        BigInteger resultInt = encryptedInt.modPow(exponent, modulus);
        return resultInt.toByteArray();
    }

    private static int verifyLicense(String encryptData, LicenseFeatureInfo featureInfo, String signature) {
        String[] subStrings = encryptData.split("\\|");
        if (subStrings.length != 7) {
            return SuperMap_License_Error_EncryptFailed;
        }
        String featureID = subStrings[0];
        String version = subStrings[1];
        String licMode = subStrings[2];
        String identifyCode = subStrings[3];
        String startDate = subStrings[4];
        String endDate = subStrings[5];
        String maxLogins = subStrings[6];
        if (!version.equals(VERSION)) {
            return SuperMap_License_Error_WrongProductVersion;
        }
        String strFeatureID = new Integer((int)featureInfo.getID()).toString();
        if (!featureID.equals(strFeatureID)) {
            return SuperMap_License_Error_WrongFeatureInLicData;
        }
        int code = LicenseWrapInstance.verifyLicenseDate(startDate, true, featureInfo);
        if (code != 0) {
            return code;
        }
        code = LicenseWrapInstance.verifyLicenseDate(endDate, false, featureInfo);
        if (code != 0) {
            return code;
        }
        featureInfo.m_maxlogins = Integer.parseInt(maxLogins);
        featureInfo.m_connectmode = licMode;
        if (License.g_debug.booleanValue()) {
            System.out.println("licMode:  " + licMode);
            System.out.println("identifyCode:  " + identifyCode);
        }
        int licModeCode = Integer.parseInt(licMode);
        switch (licModeCode) {
            case 4: {
                if (identifyCode.toUpperCase().equals(LicenseWrapInstance.getComputerName().toUpperCase())) break;
                return SuperMap_License_Error_ComputerNameError;
            }
            case 3: {
                if (LicenseWrapInstance.verifyMACAddress(identifyCode)) break;
                return SuperMap_License_Error_SpecifyMACNotFound;
            }
            case 2: {
                if (!identifyCode.toUpperCase().equals(signature.toUpperCase())) {
                    return SuperMap_License_Error_WrongLicenseData;
                }
                featureInfo.m_isTrial = true;
                break;
            }
            case 5: {
                if (identifyCode.toUpperCase().equals(signature.toUpperCase())) break;
                return SuperMap_License_Error_WrongLicenseData;
            }
        }
        return 0;
    }

    private static String getComputerName() {
        String computerName = "";
        try {
            computerName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        if (License.g_debug.booleanValue()) {
            System.out.println("getComputerName:  " + computerName);
        }
        return computerName;
    }

    private static int verifyLicenseDate(String strDate, boolean isStartDate, LicenseFeatureInfo featureInfo) {
        Date today = new Date();
        int year = Integer.parseInt(strDate.substring(0, 4));
        int month = Integer.parseInt(strDate.substring(4, 6)) - 1;
        int day = Integer.parseInt(strDate.substring(6));
        Calendar cl = Calendar.getInstance();
        if (isStartDate) {
            cl.set(year, month, day, 0, 0, 0);
        } else {
            cl.set(year, month, day, 23, 59, 59);
        }
        Date date = cl.getTime();
        if (isStartDate) {
            if (today.before(date)) {
                return SuperMap_License_Error_EarlyStartDate;
            }
            featureInfo.m_startTime = date;
        } else {
            if (today.after(date)) {
                return SuperMap_License_Error_LaterExpiredDate;
            }
            featureInfo.m_expiredTime = date;
        }
        return 0;
    }

    private static boolean verifyMACAddress(String macAddress) {
        if (g_MACList == null) {
            LicenseWrapInstance.getAllMac();
        }
        for (String mac : g_MACList) {
            if (!mac.equals(macAddress)) continue;
            return true;
        }
        return false;
    }

    public static void getAllMac() {
        g_MACList = new ArrayList<String>();
        String conSym = "";
        conSym = System.getProperty("os.name").toLowerCase().indexOf("windows") != -1 ? "-" : ":";
        if (License.g_debug.booleanValue()) {
            System.out.println("os.name: " + System.getProperty("os.name"));
            System.out.println("conSym is " + conSym);
        }
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface network = e.nextElement();
                if (network == null || network.getHardwareAddress() == null || network.isPointToPoint()) continue;
                byte[] addres = network.getHardwareAddress();
                StringBuffer sb = new StringBuffer();
                if (addres == null || addres.length <= 1) continue;
                sb.append(LicenseWrapInstance.hexByte(addres[0]));
                sb.append(conSym);
                sb.append(LicenseWrapInstance.hexByte(addres[1]));
                sb.append(conSym);
                sb.append(LicenseWrapInstance.hexByte(addres[2]));
                sb.append(conSym);
                sb.append(LicenseWrapInstance.hexByte(addres[3]));
                sb.append(conSym);
                sb.append(LicenseWrapInstance.hexByte(addres[4]));
                sb.append(conSym);
                sb.append(LicenseWrapInstance.hexByte(addres[5]));
                if (License.g_debug.booleanValue()) {
                    System.out.println("getAllMac:  " + sb.toString().toUpperCase());
                }
                g_MACList.add(sb.toString().toUpperCase());
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
    }

    private static String hexByte(byte b) {
        String s = "000000" + Integer.toHexString(b);
        return s.substring(s.length() - 2);
    }
}

